package com.ejianc.business.zhht.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目策划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_targetcost_build_duty")
public class BuildDutyEntity extends BaseEntity {

    private static final long serialVersionUID = -5057191381413882079L;
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="units_name")
    private String unitsName; // 建设单位
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="name")
    private String name; // 目标责任成本名称
    @TableField(value="fee_id")
    private Long feeId; // 费用模板主键
    @TableField(value="fee_name")
    private String feeName; // 费用模板名称
    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象主键
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象编号
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象名称
    @TableField(value="mny")
    private BigDecimal mny; // 目标成本金额(无税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 目标成本金额
    @TableField(value="before_mny")
    private BigDecimal beforeMny; // 变更前金额(无税)
    @TableField(value="before_tax_mny")
    private BigDecimal beforeTaxMny; // 变更前金额
    @TableField(value="convert_flag")
    private Integer convertFlag; // 转换状态 1-是 0-否
    @TableField(value="latest_flag")
    private Integer latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Integer enableState; // 是否生效
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="duty_version")
    private Integer dutyVersion; // 目标责任成本版本
    @TableField(value="last_duty_id")
    private Long lastDutyId; // 上一版本主键
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="before_duty_version")
    private Integer beforeDutyVersion; // 历史版本号
    @TableField(value="one_time")
    private Date oneTime; // 第一版本创建时间
    @TableField(value="base_duty_id")
    private Long baseDutyId; // 原始版本主键
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="additional_tax_rate")
    private BigDecimal additionalTaxRate; // 附加税率
    @TableField(value="planed_total_cost_mny")
    private BigDecimal planedTotalCostMny; // 策划总成本（无税）
    @TableField(value="planed_total_cost_tax_mny")
    private BigDecimal planedTotalCostTaxMny; // 策划总金额（含税）
    @TableField(value="profit_and_loss_tax_mny")
    private BigDecimal profitAndLossTaxMny; // 盈亏金额（含税）
    @TableField(value="plan_profit_rate")
    private BigDecimal planProfitRate; // 策划利润率（含税）

    @TableField(value="before_planed_total_cost_mny")
    private BigDecimal beforePlanedTotalCostMny; // 变更前策划总成本(无税)
    @TableField(value="before_planed_total_cost_tax_mny")
    private BigDecimal beforePlanedTotalCostTaxMny; // 变更前策划总金额（含税）
    @TableField(value="before_profit_and_loss_tax_mny")
    private BigDecimal beforeProfitAndLossTaxMny; // 变更前盈亏金额（含税）
    @TableField(value="before_plan_profit_rate")
    private BigDecimal beforePlanProfitRate; // 变更前策划利润率（含税）

    @TableField(exist=false)
    @SubEntity(serviceName="buildDutySumDetailService", pidName = "sumDutyId")
    private List<BuildDutySumDetailEntity> sumDetailList = new ArrayList<>(); // 项目策划-汇总子表
    @TableField(exist=false)
    @SubEntity(serviceName="buildDutyLaborCostDetailService", pidName = "laborDutyId")
    private List<BuildDutyLaborCostDetailEntity> laborDetailList = new ArrayList<>(); // 项目测试-人工费
    @TableField(exist=false)
    @SubEntity(serviceName="buildDutyMaterialDetailService", pidName = "materialDutyId")
    private List<BuildDutyMaterialDetailEntity> materialDetailList = new ArrayList<>(); // 项目策划-材料费
    @TableField(exist=false)
    @SubEntity(serviceName="buildDutyEquipDetailService", pidName = "equipDutyId")
    private List<BuildDutyEquipDetailEntity> equipDetailList = new ArrayList<>(); // 项目策划-机械费
    @TableField(exist=false)
    @SubEntity(serviceName="buildDutyProSubDetailService", pidName = "proSubDutyId")
    private List<BuildDutyProSubDetailEntity> proSubDetailList = new ArrayList<>(); // 项目策划-专业分包费
    @TableField(exist=false)
    @SubEntity(serviceName="buildDutyMeasureDetailService", pidName = "measureDutyId")
    private List<BuildDutyMeasureDetailEntity> measureDetailList = new ArrayList<>(); // 项目策划-措施费
    @TableField(exist=false)
    @SubEntity(serviceName="buildDutyOtherDetailService", pidName = "otherDutyId")
    private List<BuildDutyOtherDetailEntity> otherDetailList = new ArrayList<>(); // 项目策划-其他费


    public BigDecimal getBeforePlanedTotalCostMny() {
        return beforePlanedTotalCostMny;
    }

    public void setBeforePlanedTotalCostMny(BigDecimal beforePlanedTotalCostMny) {
        this.beforePlanedTotalCostMny = beforePlanedTotalCostMny;
    }

    public BigDecimal getBeforePlanedTotalCostTaxMny() {
        return beforePlanedTotalCostTaxMny;
    }

    public void setBeforePlanedTotalCostTaxMny(BigDecimal beforePlanedTotalCostTaxMny) {
        this.beforePlanedTotalCostTaxMny = beforePlanedTotalCostTaxMny;
    }

    public BigDecimal getBeforeProfitAndLossTaxMny() {
        return beforeProfitAndLossTaxMny;
    }

    public void setBeforeProfitAndLossTaxMny(BigDecimal beforeProfitAndLossTaxMny) {
        this.beforeProfitAndLossTaxMny = beforeProfitAndLossTaxMny;
    }

    public BigDecimal getBeforePlanProfitRate() {
        return beforePlanProfitRate;
    }

    public void setBeforePlanProfitRate(BigDecimal beforePlanProfitRate) {
        this.beforePlanProfitRate = beforePlanProfitRate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getUnitsName() {
        return unitsName;
    }

    public void setUnitsName(String unitsName) {
        this.unitsName = unitsName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }
    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }
    public Integer getConvertFlag() {
        return convertFlag;
    }

    public void setConvertFlag(Integer convertFlag) {
        this.convertFlag = convertFlag;
    }
    public Integer getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Integer latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseDutyId() {
        return baseDutyId;
    }

    public void setBaseDutyId(Long baseDutyId) {
        this.baseDutyId = baseDutyId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public BigDecimal getAdditionalTaxRate() {
        return additionalTaxRate;
    }

    public void setAdditionalTaxRate(BigDecimal additionalTaxRate) {
        this.additionalTaxRate = additionalTaxRate;
    }
    public BigDecimal getPlanedTotalCostMny() {
        return planedTotalCostMny;
    }

    public void setPlanedTotalCostMny(BigDecimal planedTotalCostMny) {
        this.planedTotalCostMny = planedTotalCostMny;
    }
    public BigDecimal getPlanedTotalCostTaxMny() {
        return planedTotalCostTaxMny;
    }

    public void setPlanedTotalCostTaxMny(BigDecimal planedTotalCostTaxMny) {
        this.planedTotalCostTaxMny = planedTotalCostTaxMny;
    }
    public BigDecimal getProfitAndLossTaxMny() {
        return profitAndLossTaxMny;
    }

    public void setProfitAndLossTaxMny(BigDecimal profitAndLossTaxMny) {
        this.profitAndLossTaxMny = profitAndLossTaxMny;
    }
    public BigDecimal getPlanProfitRate() {
        return planProfitRate;
    }

    public void setPlanProfitRate(BigDecimal planProfitRate) {
        this.planProfitRate = planProfitRate;
    }

    public List<BuildDutySumDetailEntity> getSumDetailList() {
        return sumDetailList;
    }

    public void setSumDetailList(List<BuildDutySumDetailEntity> sumDetailList) {
        this.sumDetailList = sumDetailList;
    }

    public List<BuildDutyLaborCostDetailEntity> getLaborDetailList() {
        return laborDetailList;
    }

    public void setLaborDetailList(List<BuildDutyLaborCostDetailEntity> laborDetailList) {
        this.laborDetailList = laborDetailList;
    }

    public List<BuildDutyMaterialDetailEntity> getMaterialDetailList() {
        return materialDetailList;
    }

    public void setMaterialDetailList(List<BuildDutyMaterialDetailEntity> materialDetailList) {
        this.materialDetailList = materialDetailList;
    }

    public List<BuildDutyEquipDetailEntity> getEquipDetailList() {
        return equipDetailList;
    }

    public void setEquipDetailList(List<BuildDutyEquipDetailEntity> equipDetailList) {
        this.equipDetailList = equipDetailList;
    }

    public List<BuildDutyProSubDetailEntity> getProSubDetailList() {
        return proSubDetailList;
    }

    public void setProSubDetailList(List<BuildDutyProSubDetailEntity> proSubDetailList) {
        this.proSubDetailList = proSubDetailList;
    }

    public List<BuildDutyMeasureDetailEntity> getMeasureDetailList() {
        return measureDetailList;
    }

    public void setMeasureDetailList(List<BuildDutyMeasureDetailEntity> measureDetailList) {
        this.measureDetailList = measureDetailList;
    }

    public List<BuildDutyOtherDetailEntity> getOtherDetailList() {
        return otherDetailList;
    }

    public void setOtherDetailList(List<BuildDutyOtherDetailEntity> otherDetailList) {
        this.otherDetailList = otherDetailList;
    }
}
