package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zhht.bean.BuildDutyLaborCostDetailEntity;
import com.ejianc.business.zhht.bean.BuildDutyProSubDetailEntity;
import com.ejianc.business.zhht.service.IBuildDutyLaborCostDetailService;
import com.ejianc.business.zhht.service.IBuildDutyProSubDetailService;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/12/13 10:48
 */
@RestController
@RequestMapping(value = "buildDutyLaborCostDetail")
public class BuildDutyLaborCostDetailController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBuildDutyLaborCostDetailService service;

    @Autowired
    private IBuildDutyProSubDetailService proSubDutyService;

    @Autowired
    private IBuildDutyService buildDutyService;

    @PostMapping(value = "getAllByProjectIdAndDocIds")
    public CommonResponse<List<JSONObject>> getAllByProjectIdAndDocIds(@RequestBody JSONObject params) {
        Long projectId = params.getLong("projectId");
        String docType = params.getString("docType");
        List<Long> docIds = JSONArray.parseArray(params.getString("docIds"), Long.class);

        logger.info("projectId： {}, docType:{}, docIds: {}", projectId, docType, JSONObject.toJSONString(docIds));
        List<JSONObject> resp = null;

        BuildDutyVO buildDuty = buildDutyService.getByProjectId(projectId);
        if(null == buildDuty) {
            return CommonResponse.success(new ArrayList<>());
        }

        if("proSub".equals(docType)) {
            resp = proSubDutyService.getAllByPidAndDocIds(buildDuty.getId(), docIds);
            if(CollectionUtils.isNotEmpty(resp)) {
                resp.stream().forEach(item -> {
                    item.put("docId", item.getLong("proSubDocId"));
                });
            }
        } else {
            resp = service.getAllByPidAndDocIds(buildDuty.getId(), docIds);
            resp.stream().forEach(item -> {
                item.put("docId", item.getLong("laborDocId"));
            });
        }

        return CommonResponse.success(resp);
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBuildDutyDetailData", method = RequestMethod.GET)
    public CommonResponse<IPage<JSONObject>> refBuildDutyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String relyCondition,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        IPage<JSONObject> pageData = null;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long buildDutyId = Long.parseLong(relyCondition.split("=")[1]);

        if(StringUtils.isEmpty(condition)) {
            JSONObject j = new JSONObject();
            j.put("docType", "labor");
            condition = JSONObject.toJSONString(j);
        }

        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);

            if(!_con.containsKey("docType")) {
//                return CommonResponse.error("确实查询参数：docType");
                _con.put("docType","labor");
            }

            if("proSub".equals(_con.getString("docType"))) {
                param.getParams().put("proSubDutyId", Parameter.getEqInstance(buildDutyId));
                if(_con.containsKey("docIds")) {
                    param.getParams().put("proSubDocId", Parameter.getInInstance(JSONArray.parseArray(_con.getString("docIds"), Long.class)));
                }
                param.getParams().put("leafFlag", Parameter.getInInstance(true));
                IPage<BuildDutyProSubDetailEntity> page = proSubDutyService.queryPage(param,false);
                pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList(page.getRecords(), JSONObject.class));
                pageData.getRecords().stream().forEach(item -> {
                    item.put("docName", item.get("proSubDocName"));
                    item.put("docCode", item.get("proSubDocCode"));
                    item.put("docId", item.get("proSubDocId"));
                    item.put("unitName", item.get("proSubUnitName"));
                    item.put("inComePrice", item.get("proSubIncomePrice"));
                    item.put("incomeMny", item.get("proSubIncomeMny"));
                    item.put("costRate", item.get("proSubCostRate"));
                    item.put("costPrice", item.get("proSubCostPrice"));
                    item.put("costTaxPrice", item.get("proSubCostTaxPrice"));
                    item.put("costMny", item.get("proSubCostMny"));
                    item.put("costTaxMny", item.get("proSubCostTaxMny"));
                    item.put("costTax", item.get("proSubCostTax"));
                    item.put("profitAndLossMny", item.get("proSubProfitAndLossMny"));
                    item.put("num", item.get("proSubNum"));
                });
            } else {
                param.getParams().put("laborDutyId", Parameter.getEqInstance(buildDutyId));
                if(_con.containsKey("docIds")) {
                    param.getParams().put("laborDocId", Parameter.getInInstance(JSONArray.parseArray(_con.getString("docIds"), Long.class)));
                }
                param.getParams().put("leafFlag", Parameter.getInInstance(true));
                IPage<BuildDutyLaborCostDetailEntity> page = service.queryPage(param,false);
                pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList(page.getRecords(), JSONObject.class));
                pageData.getRecords().stream().forEach(item -> {
                    item.put("docName", item.get("laborDocName"));
                    item.put("docCode", item.get("laborDocCode"));
                    item.put("docId", item.get("laborDocId"));
                    item.put("unitName", item.get("laborUnitName"));
                    item.put("inComePrice", item.get("laborIncomePrice"));
                    item.put("incomeMny", item.get("laborIncomeMny"));
                    item.put("costRate", item.get("laborCostRate"));
                    item.put("costPrice", item.get("laborCostPrice"));
                    item.put("costTaxPrice", item.get("laborCostTaxPrice"));
                    item.put("costMny", item.get("laborCostMny"));
                    item.put("costTaxMny", item.get("laborCostTaxMny"));
                    item.put("costTax", item.get("laborCostTax"));
                    item.put("profitAndLossMny", item.get("laborProfitAndLossMny"));
                    item.put("num", item.get("laborNum"));
                });
            }
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
    }


}
