package com.ejianc.business.zhht.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zhht.mapper.BuildDutyProSubDetailMapper;
import com.ejianc.business.zhht.bean.BuildDutyProSubDetailEntity;
import com.ejianc.business.zhht.service.IBuildDutyProSubDetailService;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目策划-专业分包费
 * 
 * @author generator
 * 
 */
@Service("buildDutyProSubDetailService")
public class BuildDutyProSubDetailServiceImpl extends BaseServiceImpl<BuildDutyProSubDetailMapper, BuildDutyProSubDetailEntity> implements IBuildDutyProSubDetailService{

    @Override
    public List<JSONObject> getAllByPidAndDocIds(Long pid, List<Long> docIds) {
        List<JSONObject> resp = new ArrayList<>();
        QueryWrapper<BuildDutyProSubDetailEntity> query = new QueryWrapper<>();

        query.eq("pro_sub_duty_id", pid);
        query.in("pro_sub_doc_id", docIds);
        query.eq("leaf_flag", 1);
        List<BuildDutyProSubDetailEntity> dbEntity = super.list(query);
        if(CollectionUtils.isNotEmpty(dbEntity)) {
            resp = BeanMapper.mapList(dbEntity, JSONObject.class);
        }

        return resp;
    }
}
