package com.ejianc.business.zhht.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.mapper.BuildDutyMapper;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目策划
 * 
 * @author generator
 * 
 */
@Service("buildDutyService")
public class BuildDutyServiceImpl extends BaseServiceImpl<BuildDutyMapper, BuildDutyEntity> implements IBuildDutyService{

    @Autowired
    private IDutyService dutyService;

    private static final String BILL_CODE = "BUILD_DUTY_01";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BuildDutyVO getByProjectId(Long projectId) {
        QueryWrapper<BuildDutyEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("latest_flag", 1); //最新
        query.in("bill_state", new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});

        List<BuildDutyEntity> dbEntityList = super.list(query);

        return CollectionUtils.isNotEmpty(dbEntityList) ? BeanMapper.map(dbEntityList.get(0), BuildDutyVO.class) : null;
    }

    @Override
    public BuildDutyVO queryChangeDetail(Long id) {
        BuildDutyVO vo = this.queryDetail(id, false);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDutyId(id);
        vo.setLatestFlag(0);
        vo.setEnableState(0);
        vo.setBaseDutyId(vo.getBaseDutyId());
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);

        vo.setBeforePlanedTotalCostMny(vo.getPlanedTotalCostMny());
        vo.setBeforePlanedTotalCostTaxMny(vo.getPlanedTotalCostTaxMny());
        vo.setBeforePlanProfitRate(vo.getPlanProfitRate());
        vo.setBeforeProfitAndLossTaxMny(vo.getProfitAndLossTaxMny());

        List<BuildDutySumDetailVO> buildPlansList = vo.getSumDetailList();
        if (CollectionUtils.isNotEmpty(buildPlansList)) {
            buildPlansList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeSumPlanTotalRevenueMny(changeDetailVO.getSumPlanTotalRevenueMny());
                changeDetailVO.setBeforeSumPlanTotalCostMny(changeDetailVO.getSumPlanTotalCostMny());
                changeDetailVO.setBeforeSumProfitAndLossMny(changeDetailVO.getSumProfitAndLossMny());
                changeDetailVO.setBeforeSumPlanTotalTax(changeDetailVO.getSumPlanTotalTax());
                changeDetailVO.setBeforeSumProfitAndLossRate(changeDetailVO.getSumProfitAndLossRate());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-便更价，3-变更量价，4-删除项
            });
            vo.setSumDetailList(TreeNodeBUtil.buildTreeS(buildPlansList));
        }

        //人工费
        List<BuildDutyLaborCostDetailVO> buildRgcostList = vo.getLaborDetailList();
        if (CollectionUtils.isNotEmpty(buildRgcostList)) {
            buildRgcostList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());


                changeDetailVO.setBeforeLaborDocCode(changeDetailVO.getLaborDocCode());
                changeDetailVO.setBeforeLaborDocName(changeDetailVO.getLaborDocName());
                changeDetailVO.setBeforeLaborUnitName(changeDetailVO.getLaborUnitName());
                changeDetailVO.setBeforeLaborNum(changeDetailVO.getLaborNum());
                changeDetailVO.setBeforeLaborIncomeMny(changeDetailVO.getLaborIncomeMny());
                changeDetailVO.setBeforeLaborIncomePrice(changeDetailVO.getLaborIncomePrice());
                changeDetailVO.setBeforeLaborCostRate(changeDetailVO.getLaborCostRate());
                changeDetailVO.setBeforeLaborCostPrice(changeDetailVO.getLaborCostPrice());
                changeDetailVO.setBeforeLaborCostTaxPrice(changeDetailVO.getLaborCostTaxPrice());
                changeDetailVO.setBeforeLaborCostMny(changeDetailVO.getLaborCostMny());
                changeDetailVO.setBeforeLaborCostTaxMny(changeDetailVO.getLaborCostTaxMny());
                changeDetailVO.setBeforeLaborUnitId(changeDetailVO.getLaborUnitId());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-便更价，3-变更量价，4-删除项

            });
            vo.setLaborDetailList(TreeNodeBUtil.buildTreeS(buildRgcostList));
        }

        List<BuildDutyProSubDetailVO> buildSubList = vo.getProSubDetailList(); // 专业
        if (CollectionUtils.isNotEmpty(buildSubList)) {
            buildSubList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeProSubDocCode(changeDetailVO.getProSubDocCode());
                changeDetailVO.setBeforeProSubDocName(changeDetailVO.getProSubDocName());
                changeDetailVO.setBeforeProSubUnitName(changeDetailVO.getProSubUnitName());
                changeDetailVO.setBeforeProSubUnitId(changeDetailVO.getProSubUnitId());
                changeDetailVO.setBeforeProSubNum(changeDetailVO.getProSubNum());
                changeDetailVO.setBeforeProSubIncomePrice(changeDetailVO.getProSubIncomePrice());
                changeDetailVO.setBeforeProSubIncomeMny(changeDetailVO.getProSubIncomeMny());
                changeDetailVO.setBeforeProSubCostRate(changeDetailVO.getProSubCostRate());
                changeDetailVO.setBeforeProSubCostPrice(changeDetailVO.getProSubCostPrice());
                changeDetailVO.setBeforeProSubCostTaxPrice(changeDetailVO.getProSubCostTaxPrice());
                changeDetailVO.setBeforeProSubCostMny(changeDetailVO.getProSubCostMny());
                changeDetailVO.setBeforeProSubCostTaxMny(changeDetailVO.getProSubCostTaxMny());
                changeDetailVO.setBeforeProSubTax(changeDetailVO.getProSubTax());
                changeDetailVO.setBeforeProSubProfitAndLossMny(changeDetailVO.getProSubProfitAndLossMny());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-便更价，3-变更量价，4-删除项
            });
            vo.setProSubDetailList(TreeNodeBUtil.buildTreeS(buildSubList));
        }

        List<BuildDutyMaterialDetailVO> buildMaterialList = vo.getMaterialDetailList(); // 材料费
        if (CollectionUtils.isNotEmpty(buildMaterialList)) {
            buildMaterialList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeMaterialDocCode(changeDetailVO.getMaterialDocCode());
                changeDetailVO.setBeforeMaterialDocName(changeDetailVO.getMaterialDocName());
                changeDetailVO.setBeforeMaterialDocSpec(changeDetailVO.getMaterialDocSpec());
                changeDetailVO.setBeforeMaterialUnitName(changeDetailVO.getMaterialUnitName());
                changeDetailVO.setBeforeMaterialUnitId(changeDetailVO.getMaterialUnitId());
                changeDetailVO.setBeforeMaterialNum(changeDetailVO.getMaterialNum());
                changeDetailVO.setBeforeMaterialIncomePrice(changeDetailVO.getMaterialIncomePrice());
                changeDetailVO.setBeforeMaterialIncomeMny(changeDetailVO.getMaterialIncomeMny());
                changeDetailVO.setBeforeMaterialCostRate(changeDetailVO.getMaterialCostRate());
                changeDetailVO.setBeforeMaterialCostPrice(changeDetailVO.getMaterialCostPrice());
                changeDetailVO.setBeforeMaterialCostMny(changeDetailVO.getMaterialCostMny());
                changeDetailVO.setBeforeMaterialCostTaxMny(changeDetailVO.getMaterialCostTaxMny());
                changeDetailVO.setBeforeMaterialCostTax(changeDetailVO.getMaterialCostTax());
                changeDetailVO.setBeforeMaterialCostTaxPrice(changeDetailVO.getMaterialCostTaxPrice());
                changeDetailVO.setBeforeMaterialProfitAndLossMny(changeDetailVO.getMaterialProfitAndLossMny());
                changeDetailVO.setBeforeMaterialProfitAndLossMny(changeDetailVO.getMaterialProfitAndLossMny());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-便更价，3-变更量价，4-删除项
            });
            vo.setMaterialDetailList(TreeNodeBUtil.buildTreeS(buildMaterialList));
        }

        List<BuildDutyEquipDetailVO> equipList = vo.getEquipDetailList(); // 机械费
        if (CollectionUtils.isNotEmpty(equipList)) {
            equipList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeEquipDocCode(changeDetailVO.getEquipDocCode());
                changeDetailVO.setBeforeEquipDocName(changeDetailVO.getEquipDocName());
                changeDetailVO.setBeforeEquipUnitName(changeDetailVO.getEquipUnitName());
                changeDetailVO.setBeforeEquipNum(changeDetailVO.getEquipNum());
                changeDetailVO.setBeforeEquipRentDays(changeDetailVO.getEquipRentDays());
                changeDetailVO.setBeforeEquipIncomeMny(changeDetailVO.getEquipIncomeMny());
                changeDetailVO.setBeforeEquipIncomePrice(changeDetailVO.getEquipIncomePrice());
                changeDetailVO.setBeforeEquipCostRate(changeDetailVO.getEquipCostRate());
                changeDetailVO.setBeforeEquipCostPrice(changeDetailVO.getEquipCostPrice());
                changeDetailVO.setBeforeEquipCostTaxPrice(changeDetailVO.getEquipCostTaxPrice());
                changeDetailVO.setBeforeEquipCostMny(changeDetailVO.getEquipCostMny());
                changeDetailVO.setBeforeEquipCostTaxMny(changeDetailVO.getEquipCostTaxMny());
                changeDetailVO.setBeforeEquipCostTax(changeDetailVO.getEquipCostTax());
                changeDetailVO.setBeforeEquipUnitId(changeDetailVO.getEquipUnitId());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-便更价，3-变更量价，4-删除项
            });
            vo.setEquipDetailList(TreeNodeBUtil.buildTreeS(equipList));
        }

        List<BuildDutyMeasureDetailVO> buildStimulateList = vo.getMeasureDetailList(); // 措施费
        if (CollectionUtils.isNotEmpty(buildStimulateList)) {
            buildStimulateList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeMeasureCode(changeDetailVO.getMeasureCode());
                changeDetailVO.setBeforeMeasureName(changeDetailVO.getMeasureName());
                changeDetailVO.setBeforeMeasureUnitName(changeDetailVO.getMeasureUnitName());
                changeDetailVO.setBeforeMeasureNum(changeDetailVO.getMeasureNum());
                changeDetailVO.setBeforeMeasureUnitId(changeDetailVO.getMeasureUnitId());
                changeDetailVO.setBeforeMeasureIncomePrice(changeDetailVO.getMeasureIncomePrice());
                changeDetailVO.setBeforeMeasureIncomeMny(changeDetailVO.getBeforeMeasureIncomeMny());
                changeDetailVO.setBeforeMeasureCostRate(changeDetailVO.getMeasureCostRate());
                changeDetailVO.setBeforeMeasureCostPrice(changeDetailVO.getMeasureCostPrice());
                changeDetailVO.setBeforeMeasureCostTaxPrice(changeDetailVO.getMeasureCostTaxPrice());
                changeDetailVO.setBeforeMeasureCostTaxMny(changeDetailVO.getMeasureCostTaxMny());
                changeDetailVO.setBeforeMeasureCostMny(changeDetailVO.getMeasureCostMny());
                changeDetailVO.setBeforeMeasureCostTax(changeDetailVO.getMeasureCostTax());
                changeDetailVO.setBeforeMeasureProfitAndLossMny(changeDetailVO.getMeasureProfitAndLossMny());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-便更价，3-变更量价，4-删除项
            });
            vo.setMeasureDetailList(TreeNodeBUtil.buildTreeS(buildStimulateList));
        }
        List<BuildDutyOtherDetailVO> otherList = vo.getOtherDetailList(); //其他费
        if (CollectionUtils.isNotEmpty(otherList)) {
            otherList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());

                changeDetailVO.setBeforeOtherCode(changeDetailVO.getOtherCode());
                changeDetailVO.setBeforeOtherName(changeDetailVO.getOtherName());
                changeDetailVO.setBeforeOtherUnitName(changeDetailVO.getOtherUnitName());
                changeDetailVO.setBeforeOtherUnitId(changeDetailVO.getOtherUnitId());
                changeDetailVO.setBeforeOtherNum(changeDetailVO.getOtherNum());
                changeDetailVO.setBeforeOtherIncomeMny(changeDetailVO.getOtherIncomeMny());
                changeDetailVO.setBeforeOtherCostRate(changeDetailVO.getOtherCostRate());
                changeDetailVO.setBeforeOtherCostPrice(changeDetailVO.getOtherCostPrice());
                changeDetailVO.setBeforeOtherCostTaxPrice(changeDetailVO.getOtherCostTaxPrice());
                changeDetailVO.setBeforeOtherCostMny(changeDetailVO.getOtherCostMny());
                changeDetailVO.setBeforeOtherCostTaxMny(changeDetailVO.getOtherCostTaxMny());
                changeDetailVO.setBeforeOtherCostTax(changeDetailVO.getOtherCostTax());
                changeDetailVO.setBeforeOtherProfitAndLossMny(changeDetailVO.getOtherProfitAndLossMny());
                changeDetailVO.setChangeFlag("0");
                changeDetailVO.setChangeType(null); // 0-新增项，1-变更量，2-变更价，3-变更量价，4-删除项，5-其他变更
            });
            vo.setOtherDetailList(TreeNodeBUtil.buildTreeS(otherList));
        }
        return vo;
    }

    @Override
    public BuildDutyVO ConvertFlag(Long id) {
        BuildDutyEntity entity = super.selectById(id);
        entity.setConvertFlag(1);
        super.updateById(entity);
        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);
        dutyService.pushFromImport(vo, false, ConversionEnum.中核华泰房建.getCode());
        return queryDetail(id, true);
    }

    @Override
    public BuildDutyVO queryDetail(Long id, boolean subTreeFlag) {
        Map<String, LinkedHashMap<String, String>> subOrderMap = new HashMap<>();

        LinkedHashMap<String, String> sumOrder = new LinkedHashMap<>();
        sumOrder.put("sumTreeIndex", "asc");
        subOrderMap.put("sumDetailList", sumOrder);

        LinkedHashMap<String, String> laborOrder = new LinkedHashMap<>();
        laborOrder.put("laborTreeIndex", "asc");
        subOrderMap.put("laborDetailList", laborOrder);

        LinkedHashMap<String, String> materialOrder = new LinkedHashMap<>();
        materialOrder.put("materialTreeIndex", "asc");
        subOrderMap.put("materialDetailList", materialOrder);

        LinkedHashMap<String, String> equipOrder = new LinkedHashMap<>();
        equipOrder.put("equipTreeIndex", "asc");
        subOrderMap.put("equipDetailList", equipOrder);

        LinkedHashMap<String, String> proSubOrder = new LinkedHashMap<>();
        proSubOrder.put("proSubTreeIndex", "asc");
        subOrderMap.put("proSubDetailList", proSubOrder);

        LinkedHashMap<String, String> measureOrder = new LinkedHashMap<>();
        measureOrder.put("measureTreeIndex", "asc");
        subOrderMap.put("measureDetailList", measureOrder);

        LinkedHashMap<String, String> otherOrder = new LinkedHashMap<>();
        otherOrder.put("otherTreeIndex", "asc");
        subOrderMap.put("otherDetailList", otherOrder);

        BuildDutyEntity entity = super.selectById(id, subOrderMap);

        BuildDutyVO vo = BeanMapper.map(entity, BuildDutyVO.class);

        //子表树形处理
        if(CollectionUtils.isNotEmpty(vo.getEquipDetailList())) {
            vo.setEquipDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getEquipDetailList()) : vo.getEquipDetailList());
        }
        if(CollectionUtils.isNotEmpty(vo.getLaborDetailList())) {
            vo.setLaborDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getLaborDetailList()) : vo.getLaborDetailList());
        }
        if(CollectionUtils.isNotEmpty(vo.getMaterialDetailList())) {
            vo.setMaterialDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getMaterialDetailList()) : vo.getMaterialDetailList());
        }
        if(CollectionUtils.isNotEmpty(vo.getSumDetailList())) {
            vo.setSumDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getSumDetailList()) : vo.getSumDetailList());
        }
        if(CollectionUtils.isNotEmpty(vo.getMeasureDetailList())) {
            vo.setMeasureDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getMeasureDetailList()) : vo.getMeasureDetailList());
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherDetailList())) {
            vo.setOtherDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getOtherDetailList()) : vo.getOtherDetailList());
        }
        if(CollectionUtils.isNotEmpty(vo.getProSubDetailList())) {
            vo.setProSubDetailList(subTreeFlag ? TreeNodeBUtil.buildTreeS(vo.getProSubDetailList()) : vo.getProSubDetailList());
        }

        return vo;
    }

    @Override
    public CommonResponse<BuildDutyVO> saveOrUpdate(BuildDutyVO saveOrUpdateVO) {
        BuildDutyEntity entity = BeanMapper.map(saveOrUpdateVO, BuildDutyEntity.class);
        BuildDutyEntity entityByLastDutyId = null;
        if (entity.getLastDutyId() != null) {
            entityByLastDutyId = super.selectById(entity.getLastDutyId());
            if (ChangeStateEnum.变更中.getCode().equals(entityByLastDutyId.getChangeState())) {
                throw new BusinessException("存在变更中的【项目策划】单，不允许新增变更！");
            }
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            if (null == entity.getLastDutyId()) {
                LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(BuildDutyEntity::getProjectId, entity.getProjectId());
                if (super.count(queryWrapper) > 0) {
                    throw new BusinessException("该项目已存在目标责任成本！");
                }
            }


            entity.setId(IdWorker.getId());
            entity.setChangeState(0); //默认未变更
            if(null == entity.getLastDutyId()) {
                entity.setDutyVersion(1);//版本
                entity.setLatestFlag(1); //最新版
                entity.setBaseDutyId(entity.getId());
            }

            entity.setEnableState(0); //没审批前未启用
            entity.setConvertFlag(0); //未转换
            entity.setOneTime(new Date());
            entity.setCreateTime(entity.getOneTime());
        }

        if(null != entityByLastDutyId) {
//            entityByLastDutyId.setLatestFlag(0);
            entityByLastDutyId.setChangeId(entity.getId());
            entityByLastDutyId.setChangeState(ChangeStateEnum.变更中.getCode());
            super.saveOrUpdate(entityByLastDutyId);
        }

        super.saveOrUpdate(entity, false);
        return CommonResponse.success(queryDetail(entity.getId(), true));
    }

    @Override
    public void deleteVos(List<BuildDutyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BuildDutyVO dutyVO : vos) {
                BuildDutyEntity dutyEntity = super.getById(dutyVO.getId());
                if (dutyEntity.getLastDutyId() != null) {
                    BuildDutyEntity revise = super.getById(dutyEntity.getLastDutyId());
                    revise.setChangeId(null);
                    revise.setChangeState(ChangeStateEnum.未变更.getCode());
                    revise.setLatestFlag(1);
                    super.saveOrUpdate(revise);
                }
            }
        }
        super.removeByIds(vos.stream().map(BuildDutyVO::getId).collect(Collectors.toList()), true);
    }
}
