/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyHisVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"buildDuty"})
public class BuildDutyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBuildDutyService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/ConvertFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BuildDutyVO> ConvertFlag(Long id) {
        return CommonResponse.success((String)"\u8f6c\u6362\u6210\u529f\uff01", (Object)this.service.ConvertFlag(id));
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<BuildDutyVO> saveOrUpdate(@RequestBody BuildDutyVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @GetMapping(value={"/countByProjectId"})
    public CommonResponse<Integer> countByProjectId(@RequestParam Long projectId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"latest_flag", (Object)1);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = this.service.list((Wrapper)query);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)dbList.size());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<BuildDutyVO> queryDetail(Long id) {
        BuildDutyVO vo = this.service.queryDetail(id, true);
        if (ChangeStateEnum.\u5df2\u53d8\u66f4.getCode().equals(vo.getChangeState())) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"project_id", (Object)vo.getProjectId());
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            query.ne((Object)"id", (Object)vo.getId());
            query.orderByAsc((Object)"duty_version");
            List hisList = this.service.list((Wrapper)query);
            BuildDutyHisVO hisVO = null;
            if (CollectionUtils.isNotEmpty((Collection)hisList)) {
                for (BuildDutyEntity h : hisList) {
                    hisVO = new BuildDutyHisVO();
                    hisVO.setId(h.getId());
                    hisVO.setHisChangeId(h.getChangeId());
                    hisVO.setHisBillCode(h.getBillCode());
                    hisVO.setHisProjectName(h.getProjectName());
                    hisVO.setHisProjectCode(h.getProjectCode());
                    hisVO.setHisCreateTime(h.getCreateTime());
                    hisVO.setHisLatestFlag(h.getLatestFlag());
                    hisVO.setHisDutyVersion(h.getDutyVersion());
                    hisVO.setHisAdditionalTaxRate(h.getAdditionalTaxRate());
                    hisVO.setHisPlanedTotalCostTaxMny(h.getPlanedTotalCostTaxMny());
                    hisVO.setHisPlanedTotalCostMny(h.getPlanedTotalCostMny());
                    hisVO.setHisPlanProfitRate(h.getPlanProfitRate());
                    hisVO.setHisProfitAndLossTaxMny(h.getProfitAndLossTaxMny());
                    vo.getHisList().add(hisVO);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<BuildDutyVO> vos) {
        this.service.deleteVos(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<BuildDutyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BuildDutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BuildDuty-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBuildDutyData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<BuildDutyVO>> refBuildDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        param.getParams().put("billState", new Parameter("sql", (Object)" bill_state in (1,3) "));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BuildDutyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/buildDutyTree"})
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(10);
        param.setPageIndex(-1);
        param.setSearchText(searchText);
        param.getParams().put("tenantId", Parameter.getInInstance((Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter("sql", (Object)" latest_flag = 1"));
        param.getParams().put("billState", new Parameter("sql", (Object)" bill_state in (1,3) "));
        if (StringUtils.isNotEmpty((CharSequence)relyCondition) && null != (_con = JSONObject.parseObject((String)relyCondition)).get((Object)"projectId")) {
            param.getParams().put("projectId", Parameter.getInInstance((Object)_con.get((Object)"projectId")));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId")) {
            param.getParams().put("projectId", Parameter.getInInstance((Object)_con.get((Object)"projectId")));
        }
        List dataList = this.service.queryList(param);
        List map = BeanMapper.mapList((Iterable)dataList, Map.class);
        map.forEach(l -> {
            l.put("name", l.get("projectName"));
            l.put("key", l.get("projectName"));
            l.put("isLeaf", true);
            l.put("children", null);
            l.put("parentId", null);
        });
        return ResultAsTree.createTreeData((List)map);
    }

    @RequestMapping(value={"/queryChangeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryChangeDetail(Long id) {
        BuildDutyVO changeVO = this.service.queryChangeDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    @RequestMapping(value={"/queryDetailByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryDetailByProject(Long id) {
        BuildDutyVO resVo = new BuildDutyVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BuildDutyEntity::getProjectId, (Object)id);
        queryWrapper.eq(BuildDutyEntity::getLatestFlag, (Object)1);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List buildDutyEntities = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)buildDutyEntities)) {
            resVo = (BuildDutyVO)BeanMapper.map(buildDutyEntities.get(0), BuildDutyVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVo);
    }
}

