/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zhht.service.IBuildDutyLaborCostDetailService;
import com.ejianc.business.zhht.service.IBuildDutyProSubDetailService;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"buildDutyLaborCostDetail"})
public class BuildDutyLaborCostDetailController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBuildDutyLaborCostDetailService service;
    @Autowired
    private IBuildDutyProSubDetailService proSubDutyService;
    @Autowired
    private IBuildDutyService buildDutyService;

    @PostMapping(value={"getAllByProjectIdAndDocIds"})
    public CommonResponse<List<JSONObject>> getAllByProjectIdAndDocIds(@RequestBody JSONObject params) {
        Long projectId = params.getLong("projectId");
        String docType = params.getString("docType");
        List docIds = JSONArray.parseArray((String)params.getString("docIds"), Long.class);
        this.logger.info("projectId\uff1a {}, docType:{}, docIds: {}", new Object[]{projectId, docType, JSONObject.toJSONString((Object)docIds)});
        List<JSONObject> resp = null;
        BuildDutyVO buildDuty = this.buildDutyService.getByProjectId(projectId);
        if (null == buildDuty) {
            return CommonResponse.success(new ArrayList());
        }
        if ("proSub".equals(docType)) {
            resp = this.proSubDutyService.getAllByPidAndDocIds(buildDuty.getId(), docIds);
            if (CollectionUtils.isNotEmpty(resp)) {
                resp.stream().forEach(item -> {
                    item.put("docId", (Object)item.getLong("proSubDocId"));
                    item.put("docName", item.get((Object)"proSubDocName"));
                    item.put("docCode", item.get((Object)"proSubDocCode"));
                    item.put("docId", item.get((Object)"proSubDocId"));
                    item.put("unitName", item.get((Object)"proSubUnitName"));
                    item.put("inComePrice", item.get((Object)"proSubIncomePrice"));
                    item.put("incomeMny", item.get((Object)"proSubIncomeMny"));
                    item.put("costRate", item.get((Object)"proSubCostRate"));
                    item.put("costPrice", item.get((Object)"proSubCostPrice"));
                    item.put("costTaxPrice", item.get((Object)"proSubCostTaxPrice"));
                    item.put("costMny", item.get((Object)"proSubCostMny"));
                    item.put("costTaxMny", item.get((Object)"proSubCostTaxMny"));
                    item.put("costTax", item.get((Object)"proSubCostTax"));
                    item.put("profitAndLossMny", item.get((Object)"proSubProfitAndLossMny"));
                    item.put("num", item.get((Object)"proSubNum"));
                });
            }
        } else {
            resp = this.service.getAllByPidAndDocIds(buildDuty.getId(), docIds);
            resp.stream().forEach(item -> {
                item.put("docId", (Object)item.getLong("laborDocId"));
                item.put("docName", item.get((Object)"laborDocName"));
                item.put("docCode", item.get((Object)"laborDocCode"));
                item.put("docId", item.get((Object)"laborDocId"));
                item.put("unitName", item.get((Object)"laborUnitName"));
                item.put("inComePrice", item.get((Object)"laborIncomePrice"));
                item.put("incomeMny", item.get((Object)"laborIncomeMny"));
                item.put("costRate", item.get((Object)"laborCostRate"));
                item.put("costPrice", item.get((Object)"laborCostPrice"));
                item.put("costTaxPrice", item.get((Object)"laborCostTaxPrice"));
                item.put("costMny", item.get((Object)"laborCostMny"));
                item.put("costTaxMny", item.get((Object)"laborCostTaxMny"));
                item.put("costTax", item.get((Object)"laborCostTax"));
                item.put("profitAndLossMny", item.get((Object)"laborProfitAndLossMny"));
                item.put("num", item.get((Object)"laborNum"));
            });
        }
        return CommonResponse.success(resp);
    }

    @RequestMapping(value={"/refBuildDutyDetailData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<JSONObject>> refBuildDutyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Page pageData = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long buildDutyId = Long.parseLong(relyCondition.split("=")[1]);
        if (StringUtils.isEmpty((CharSequence)condition)) {
            JSONObject j = new JSONObject();
            j.put("docType", (Object)"labor");
            condition = JSONObject.toJSONString((Object)j);
        }
        param.getParams().put("leaf_flag", new Parameter("sql", (Object)" leaf_flag = 1"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"docType")) {
                return CommonResponse.error((String)"\u786e\u5b9e\u67e5\u8be2\u53c2\u6570\uff1adocType");
            }
            if ("proSub".equals(_con.getString("docType"))) {
                param.getParams().put("proSubDutyId", Parameter.getEqInstance((Object)buildDutyId));
                if (_con.containsKey((Object)"docIds")) {
                    param.getParams().put("proSubDocId", Parameter.getInInstance((Object)JSONArray.parseArray((String)_con.getString("docIds"), Long.class)));
                }
                param.getParams().put("proSubSourceDetailId", new Parameter("sql", (Object)" pro_sub_source_detail_id is null "));
                IPage page = this.proSubDutyService.queryPage(param, false);
                pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JSONObject.class));
                pageData.getRecords().stream().forEach(item -> {
                    item.put("docName", item.get((Object)"proSubDocName"));
                    item.put("docCode", item.get((Object)"proSubDocCode"));
                    item.put("docId", item.get((Object)"proSubDocId"));
                    item.put("unitName", item.get((Object)"proSubUnitName"));
                    item.put("inComePrice", item.get((Object)"proSubIncomePrice"));
                    item.put("incomeMny", item.get((Object)"proSubIncomeMny"));
                    item.put("costRate", item.get((Object)"proSubCostRate"));
                    item.put("costPrice", item.get((Object)"proSubCostPrice"));
                    item.put("costTaxPrice", item.get((Object)"proSubCostTaxPrice"));
                    item.put("costMny", item.get((Object)"proSubCostMny"));
                    item.put("costTaxMny", item.get((Object)"proSubCostTaxMny"));
                    item.put("costTax", item.get((Object)"proSubCostTax"));
                    item.put("profitAndLossMny", item.get((Object)"proSubProfitAndLossMny"));
                    item.put("num", item.get((Object)"proSubNum"));
                });
            } else {
                param.getParams().put("laborDutyId", Parameter.getEqInstance((Object)buildDutyId));
                if (_con.containsKey((Object)"docIds")) {
                    param.getParams().put("laborDocId", Parameter.getInInstance((Object)JSONArray.parseArray((String)_con.getString("docIds"), Long.class)));
                }
                param.getParams().put("laborSourceDetailId", new Parameter("sql", (Object)" labor_source_detail_id is null "));
                IPage page = this.service.queryPage(param, false);
                pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JSONObject.class));
                pageData.getRecords().stream().forEach(item -> {
                    item.put("docName", item.get((Object)"laborDocName"));
                    item.put("docCode", item.get((Object)"laborDocCode"));
                    item.put("docId", item.get((Object)"laborDocId"));
                    item.put("unitName", item.get((Object)"laborUnitName"));
                    item.put("inComePrice", item.get((Object)"laborIncomePrice"));
                    item.put("incomeMny", item.get((Object)"laborIncomeMny"));
                    item.put("costRate", item.get((Object)"laborCostRate"));
                    item.put("costPrice", item.get((Object)"laborCostPrice"));
                    item.put("costTaxPrice", item.get((Object)"laborCostTaxPrice"));
                    item.put("costMny", item.get((Object)"laborCostMny"));
                    item.put("costTaxMny", item.get((Object)"laborCostTaxMny"));
                    item.put("costTax", item.get((Object)"laborCostTax"));
                    item.put("profitAndLossMny", item.get((Object)"laborProfitAndLossMny"));
                    item.put("num", item.get((Object)"laborNum"));
                });
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", pageData);
    }
}

