/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.service.impl;

import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="buildDuty")
public class BuildDutyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IBuildDutyService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        BuildDutyEntity buildDutyEntity = (BuildDutyEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isEmpty(buildDutyEntity.getSumDetailList())) {
            return CommonResponse.error((String)"\u5355\u636e\u9700\u6709\u5b50\u8868\u4fe1\u606f\u540e\u624d\u80fd\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        BuildDutyEntity buildDutyEntity = (BuildDutyEntity)((Object)this.service.selectById(billId));
        if (state == 0 && buildDutyEntity.getLastDutyId() == null && (Integer.valueOf(1).equals(buildDutyEntity.getLatestFlag()) || 1 != buildDutyEntity.getDutyVersion() && Integer.valueOf(0).equals(buildDutyEntity.getEnableState()))) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BuildDutyEntity buildDutyEntity = (BuildDutyEntity)((Object)this.service.selectById(billId));
        BuildDutyEntity lasDuty = null;
        if (null != buildDutyEntity.getLastDutyId()) {
            lasDuty = (BuildDutyEntity)((Object)this.service.selectById(buildDutyEntity.getLastDutyId()));
        }
        if (null != lasDuty && ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode().equals(lasDuty.getChangeState())) {
            this.handleChangeBillPass(buildDutyEntity);
        } else {
            this.handleNewBillPass(buildDutyEntity);
        }
        this.updateEnableAndWriteBack(billId, true);
        return CommonResponse.success();
    }

    private void handleNewBillPass(BuildDutyEntity buildDutyEntity) {
        this.dutyService.pushFromImport((BaseVO)BeanMapper.map((Object)((Object)buildDutyEntity), BuildDutyVO.class), false, ConversionEnum.\u4e2d\u6838\u534e\u6cf0\u623f\u5efa.getCode());
        this.dutyService.handleBill(buildDutyEntity.getId(), true, "add", InvocationInfoProxy.getUserid());
    }

    private void handleChangeBillPass(BuildDutyEntity buildDutyEntity) {
        this.dutyService.pushFromImport((BaseVO)BeanMapper.map((Object)((Object)buildDutyEntity), BuildDutyVO.class), false, ConversionEnum.\u4e2d\u6838\u534e\u6cf0\u623f\u5efa.getCode());
        this.dutyService.handleBill(buildDutyEntity.getId(), true, "change", InvocationInfoProxy.getUserid());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BuildDutyEntity dutyEntity = (BuildDutyEntity)((Object)this.service.selectById(billId));
        if (!Integer.valueOf(1).equals(dutyEntity.getEnableState()) || !Integer.valueOf(1).equals(dutyEntity.getLatestFlag())) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BuildDutyEntity dutyEntity = (BuildDutyEntity)((Object)this.service.selectById(billId));
        this.updateEnableAndWriteBack(billId, false);
        this.dutyService.pushFromImport((BaseVO)BeanMapper.map((Object)((Object)dutyEntity), BuildDutyVO.class), false, ConversionEnum.\u4e2d\u6838\u534e\u6cf0\u623f\u5efa.getCode());
        this.dutyService.deleteFromImport(billId, ConversionEnum.\u4e2d\u6838\u534e\u6cf0\u623f\u5efa.getCode());
        return CommonResponse.success();
    }

    private void updateEnableAndWriteBack(Long billId, Boolean isPass) {
        BuildDutyEntity dutyEntity = (BuildDutyEntity)((Object)this.service.selectById(billId));
        dutyEntity.setEnableState(isPass != false ? 1 : 0);
        if (isPass.booleanValue()) {
            dutyEntity.setChangeState(dutyEntity.getLastDutyId() != null ? ChangeStateEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (dutyEntity.getLastDutyId() != null) {
            BuildDutyEntity revise = (BuildDutyEntity)((Object)this.service.getById(dutyEntity.getLastDutyId()));
            revise.setChangeState(isPass != false ? ChangeStateEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setEnableState(isPass != false ? 0 : 1);
            revise.setLatestFlag(isPass != false ? 0 : 1);
            this.service.saveOrUpdate((Object)revise);
            dutyEntity.setLatestFlag(isPass != false ? 1 : 0);
        }
        this.service.saveOrUpdate((Object)dutyEntity);
    }
}

