package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyHisVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目策划
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("buildDuty")
public class BuildDutyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBuildDutyService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description ConvertFlag 转换
     * @param id
     */
    @RequestMapping(value = "/ConvertFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BuildDutyVO> ConvertFlag(Long id) {
        return CommonResponse.success("转换成功！",service.ConvertFlag(id));
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<BuildDutyVO> saveOrUpdate(@RequestBody BuildDutyVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    @GetMapping(value = "/countByProjectId")
    public CommonResponse<Integer> countByProjectId(@RequestParam Long projectId) {
        QueryWrapper<BuildDutyEntity> query= new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("latest_flag", 1); //最新
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<BuildDutyEntity> dbList = service.list(query);

        return CommonResponse.success("查询成功！", dbList.size());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<BuildDutyVO> queryDetail(Long id) {
        BuildDutyVO vo = service.queryDetail(id, true);
        //查询历史版本

        if(ChangeStateEnum.已变更.getCode().equals(vo.getChangeState())) {
            QueryWrapper<BuildDutyEntity> query = new QueryWrapper<>();
            query.eq("project_id", vo.getProjectId());
            query.eq("dr", BaseVO.DR_UNDELETE);
            query.ne("id", vo.getId());
            query.orderByAsc("duty_version");

            List<BuildDutyEntity> hisList = service.list(query);
            BuildDutyHisVO hisVO = null;
            if(CollectionUtils.isNotEmpty(hisList)) {
                for(BuildDutyEntity h : hisList) {
                    hisVO = new BuildDutyHisVO();
                    hisVO.setId(h.getId());
                    hisVO.setHisChangeId(h.getChangeId());
                    hisVO.setHisBillCode(h.getBillCode());
                    hisVO.setHisProjectName(h.getProjectName());
                    hisVO.setHisProjectCode(h.getProjectCode());
                    hisVO.setHisCreateTime(h.getCreateTime());
                    hisVO.setHisLatestFlag(h.getLatestFlag());
                    hisVO.setHisDutyVersion(h.getDutyVersion());
                    hisVO.setHisAdditionalTaxRate(h.getAdditionalTaxRate());
                    hisVO.setHisPlanedTotalCostTaxMny(h.getPlanedTotalCostTaxMny());
                    hisVO.setHisPlanedTotalCostMny(h.getPlanedTotalCostMny());
                    hisVO.setHisPlanProfitRate(h.getPlanProfitRate());
                    hisVO.setHisProfitAndLossTaxMny(h.getProfitAndLossTaxMny());
                    vo.getHisList().add(hisVO);
                }
            }
        }



        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<BuildDutyVO> vos) {
        service.deleteVos(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<BuildDutyVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<BuildDutyEntity> page = service.queryPage(param,false);
        IPage<BuildDutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BuildDutyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("feeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BuildDutyEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BuildDuty-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBuildDutyData", method = RequestMethod.GET)
    public CommonResponse<IPage<BuildDutyVO>> refBuildDutyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));
        param.getParams().put("billState", new Parameter(QueryParam.SQL, " bill_state in (1,3) "));

        IPage<BuildDutyEntity> page = service.queryPage(param,false);
        IPage<BuildDutyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BuildDutyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @GetMapping(value = "/buildDutyTree")
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required = false) String relyCondition,
                                                      @RequestParam(required = false) String condition,
                                                      @RequestParam(required = false) String searchText) {


        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("projectName");
        param.setPageSize(10);
        param.setPageIndex(-1);
        param.setSearchText(searchText);
        param.getParams().put("tenantId", Parameter.getInInstance(InvocationInfoProxy.getTenantid()));
        param.getParams().put("latestFlag", new Parameter(QueryParam.SQL, " latest_flag = 1"));
        param.getParams().put("billState", new Parameter(QueryParam.SQL, " bill_state in (1,3) "));

        if(StringUtils.isNotEmpty(relyCondition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(relyCondition);
            if(null != _con.get("projectId")) {
                param.getParams().put("projectId", Parameter.getInInstance(_con.get("projectId")));
            }
        }
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("projectId")) {
                param.getParams().put("projectId", Parameter.getInInstance(_con.get("projectId")));
            }
        }

        List<BuildDutyEntity> dataList = service.queryList(param);
        List<Map> map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l-> {
            l.put("name", l.get("projectName"));
            l.put("key", l.get("projectName"));
            l.put("isLeaf", true);
            l.put("children", null);
            l.put("parentId", null);
        });

        return ResultAsTree.createTreeData(map);
    }

    /**
     * @Description queryChangeDetail 复制为变更单 取详情
     * @param id
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryChangeDetail(Long id) {
        BuildDutyVO changeVO = service.queryChangeDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description queryDetailByProject
     * @param id
     */
    @RequestMapping(value = "/queryDetailByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BuildDutyVO> queryDetailByProject(Long id) {
        BuildDutyVO resVo = new BuildDutyVO();
        LambdaQueryWrapper<BuildDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BuildDutyEntity::getProjectId, id);
        queryWrapper.eq(BuildDutyEntity::getLatestFlag, 1);
        queryWrapper.orderByDesc(BuildDutyEntity::getCreateTime);
        List<BuildDutyEntity> buildDutyEntities = service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(buildDutyEntities)){
            resVo = BeanMapper.map(buildDutyEntities.get(0),BuildDutyVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",resVo);
    }
}
