package com.ejianc.business.targetcost.handler;


import com.ejianc.business.targetcost.enums.ConversionEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author zhangwx
 * @version 1.0
 * @description: 目标成本转换公共服务工厂
 * @date 2023/07/10
 */
@Component
public class ConversionManageFactory {

    @Autowired
    private Map<String, IConversioneHandler> handlerMap;

    /**
     * @description: 获取导入类型类型处理器
     */
    public IConversioneHandler getHandler(String conversionType) {
        return handlerMap.get(ConversionEnum.getHandlerNameByCode(conversionType));
    }

}
