package com.ejianc.business.targetcost.mapper;

import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 目标责任成本明细项
 *
 * @author generator
 *
 */
@Mapper
public interface DutyDetailItemMapper extends BaseCrudMapper<DutyDetailItemEntity> {

    @Delete("delete from ejc_targetcost_duty_detail_item where duty_id = #{dutyId}")
    int deleteByDutyIdPhy(@Param(value = "dutyId") Long dutyId);

    List<DutyDetailItemVO> queryCostMny(@Param("projectId") Long projectId, @Param("longList") List<Long> longList);

    DutyDetailItemVO queryCostMnyBySubjectId(@Param("projectId") Long projectId, @Param("subjectId") Long subjectId);
}
