package com.ejianc.business.targetcost.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.api.IProincomeBudgetApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.roadbridge.bean.RoadbridgeDutyEntity;
import com.ejianc.business.roadbridge.service.IRoadbridgeDutyService;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.handler.ConversionManageFactory;
import com.ejianc.business.targetcost.handler.IConversioneHandler;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.zhht.bean.BuildDutyEntity;
import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标责任成本
 *
 * @author generator
 */
@Service("dutyService")
@Lazy
public class DutyServiceImpl extends BaseServiceImpl<DutyMapper, DutyEntity> implements IDutyService {
    @Autowired
    private IBillCodeApi billCodeApi;
    /*@Autowired
    private IDutyService service;*/
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IFeeService feeService;
    @Autowired
    private DutyMapper dutyMapper;
    private static final String BILL_CODE = "TC_DUTY";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;
    @Autowired
    private IProincomeBudgetApi proincomeBudgetApi;
    @Autowired
    private ConversionManageFactory conversionManageFactory;
    @Autowired
    private IRoadbridgeDutyService roadbridgeDutyService;
    @Autowired
    private IBuildDutyService buildDutyService;
    @Autowired
    private ITotalExecutionService totalExecutionService;

    @Autowired
    private EnvironmentTools environmentTools;

    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;


    private static final String CHECK_PARAM_BUDGET = "P-t576D10185";

    private static final String CHECK_PARAM_CODE = "P-839rOq97";

    private static final String CHECK_PARAM_CODE_P = "P-zk210W98";

    private static final String CHECK_PARAM_CODE_R = "P-14n3tA0128";

    private static final String CHECK_PARAM_CODE_WZ = "P-DZ2h4i0129";//物质采购管理 材料历史价控材料目标成本

    private static final String CHECK_PARAM_CODE_LW = "P-1319270130";//劳务分包管理 材料历史价控材料目标成本


    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<DutyVO> saveOrUpdate(DutyVO dutyVO) {
        DutyEntity entity = BeanMapper.map(dutyVO, DutyEntity.class);
        //新增默认版本为1(修订的存在版本号)
        if (entity.getDutyVersion() == null) {
            entity.setDutyVersion(1);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            //多目标成本改造：去掉一个项目只能有一个目标成本校验
            /*if(entity.getLastDutyId()==null){
                checkExits(dutyVO.getProjectId());
            }*/
            if (entity.getLastDutyId() != null && null != entity.getFirstImportId()) {
                checkExitsImportChange(entity);
            }
            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效
            entity.setGatherFlag(false);
            entity.setChangeState(ChangeStateEnum.未变更.getCode());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), dutyVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<DutyDetailEntity> dutyDetailEntities = entity.getDutyDetailList();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            if (null != dutyDetailEntity.getGatherTaxMny() && ComputeUtil.equals(dutyDetailEntity.getTaxMny(), dutyDetailEntity.getGatherTaxMny()) && !ComputeUtil.equals(dutyDetailEntity.getMny(), dutyDetailEntity.getGatherMny())) {
                logger.error("明细【" + dutyDetailEntity.getFeeDetailName() + "】的金额与右侧汇总金额不等！");
            }
        }
        saveOrUpdate(entity, false);
        if (entity.getDutyVersion() == 1) {
            entity.setFirstDutyId(entity.getId());
            entity.setShowFlag(true);
            entity.setOneTime(entity.getCreateTime());
        }
        //成本明细数据处理
        //费用明细编码对应主键
        Map<String, Long> map = new HashMap<>();
        //遍历获取真实主键
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            map.put(dutyDetailEntity.getTid(), dutyDetailEntity.getId());
        }
        int totalNum = 0;// 涉及的叶子节点个数
        int completNum = 0;// 完成节点个数
        //设置子节点parentId
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            if (dutyDetailEntity.getInvolveFlag() && dutyDetailEntity.getLeafFlag()) {
                totalNum += 1;
                if (!ComputeUtil.isEmpty(dutyDetailEntity.getGatherMny()) && ComputeUtil.equals(dutyDetailEntity.getMny(), dutyDetailEntity.getGatherMny())
                        && ComputeUtil.equals(dutyDetailEntity.getTaxMny(), dutyDetailEntity.getGatherTaxMny())) {
                    completNum += 1;
                }
            }
            if (!(DocTypeEnum.物料档案.getCode().equals(dutyDetailEntity.getDocType()) && dutyDetailEntity.getLeafFlag())) {
                dutyDetailEntity.setPreTypeAmount(null);
            }
            dutyDetailEntity.setOrgId(entity.getOrgId());
            dutyDetailEntity.setOrgName(entity.getOrgName());
            dutyDetailEntity.setProjectId(entity.getProjectId());
            dutyDetailEntity.setProjectName(entity.getProjectName());
            dutyDetailEntity.setParentId(map.get(dutyDetailEntity.getTpid()));
        }
        entity.setCompleteScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(BigDecimal.valueOf(completNum), BigDecimal.valueOf(totalNum)), BigDecimal.valueOf(100)));


        //表体 0未变更 1已变更  有一个字段变更则跳过，整行变更换颜色
        for (DutyDetailEntity dutyDetailEntity : entity.getDutyDetailList()) {
            if (!ComputeUtil.equals(dutyDetailEntity.getMny(), dutyDetailEntity.getBeforeMny())
                    || !ComputeUtil.equals(dutyDetailEntity.getTaxMny(), dutyDetailEntity.getBeforeTaxMny())
                    || !ComputeUtil.equals(dutyDetailEntity.getTaxRate(), dutyDetailEntity.getBeforeTaxRate())
            ) {
                dutyDetailEntity.setChangeFlag(1);
            } else {
                dutyDetailEntity.setChangeFlag(0);
            }
        }
        BigDecimal amount = BigDecimal.ZERO; // 数量
        int b = 0;
        // 计算子表的数量
        for (int m = 0; m < entity.getDutyDetailList().size(); m++) {
            for (int n = 0; n < entity.getDutyDetailList().get(m).getDutyDetailItemList().size(); n++) {
                if (m != b) {
                    amount = BigDecimal.ZERO;
                    b = m;
                }
                if (entity.getDutyDetailList().get(m).getDutyDetailItemList().get(n).getAmount() == null) {
                    entity.getDutyDetailList().get(m).getDutyDetailItemList().get(n).setAmount(BigDecimal.ZERO);
                }
                amount = amount.add(entity.getDutyDetailList().get(m).getDutyDetailItemList().get(n).getAmount());
                entity.getDutyDetailList().get(m).setTotalAmount(amount);
            }
        }
        this.saveOrUpdate(entity, false);

        //保存成本明细档案
        for (DutyDetailEntity dutyDetailEntity : entity.getDutyDetailList()) {

            //保存新成本明细档案项
            List<DutyDetailItemEntity> dutyDetailItemList = dutyDetailEntity.getDutyDetailItemList();
            if (CollectionUtils.isNotEmpty(dutyDetailItemList)) {
                List<DutyDetailItemEntity> insertList = new ArrayList<>();
                List<Long> delPkList = new ArrayList<>();
                //保存成本明细对应的档案明细
                for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemList) {
                    if ("del".equals(dutyDetailItemEntity.getRowState())) {
                        delPkList.add(dutyDetailItemEntity.getId());
                    } else {
                        dutyDetailItemEntity.setOrgId(entity.getOrgId());
                        dutyDetailItemEntity.setOrgName(entity.getOrgName());
                        dutyDetailItemEntity.setProjectId(entity.getProjectId());
                        dutyDetailItemEntity.setProjectName(entity.getProjectName());
                        dutyDetailItemEntity.setFeeDetailId(dutyDetailEntity.getFeeDetailId());
                        dutyDetailItemEntity.setFeeDetailCode(dutyDetailEntity.getFeeDetailCode());
                        dutyDetailItemEntity.setFeeDetailName(dutyDetailEntity.getFeeDetailName());
                        dutyDetailItemEntity.setCategoryId(dutyDetailItemEntity.getCategoryId());
                        dutyDetailItemEntity.setCategoryName(dutyDetailItemEntity.getCategoryName());
                        dutyDetailItemEntity.setCategoryInnerCode(dutyDetailEntity.getCategoryInnerCode());
                        dutyDetailItemEntity.setDocType(dutyDetailEntity.getDocType());
                        dutyDetailItemEntity.setDutyId(dutyDetailEntity.getDutyId());//成本主键
                        dutyDetailItemEntity.setDutyDetailId(dutyDetailEntity.getId());//成本明细主键
                        insertList.add(dutyDetailItemEntity);
                    }
                }

                //孙表 0未变更 1已变更  有一个字段变更则跳过，整行变更换颜色
                for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailEntity.getDutyDetailItemList()) {
                    if (!ComputeUtil.equals(dutyDetailItemEntity.getMny(), dutyDetailItemEntity.getBeforeMny())
                            || !ComputeUtil.equals(dutyDetailItemEntity.getTaxMny(), dutyDetailItemEntity.getBeforeTaxMny())
                            || !ComputeUtil.equals(dutyDetailItemEntity.getPrice(), dutyDetailItemEntity.getBeforePrice())
                            || !ComputeUtil.equals(dutyDetailItemEntity.getTaxPrice(), dutyDetailItemEntity.getBeforeTaxPrice())
                            || !ComputeUtil.equals(dutyDetailItemEntity.getTaxRate(), dutyDetailItemEntity.getBeforeTaxRate())
                            || !ComputeUtil.equals(dutyDetailItemEntity.getAmount(), dutyDetailItemEntity.getBeforeAmount())
                    ) {
                        dutyDetailItemEntity.setChangeFlag(1);
                    } else {
                        dutyDetailItemEntity.setChangeFlag(0);
                    }
                }
                if (CollectionUtil.isNotEmpty(insertList)) {
                    dutyDetailItemService.saveOrUpdateBatch(dutyDetailEntity.getDutyDetailItemList());
                    dutyDetailService.saveOrUpdate(dutyDetailEntity);
                }
                if (CollectionUtil.isNotEmpty(delPkList)) {
                    dutyDetailItemService.removeByIds(delPkList);
                }
            }
        }

        //返回数据
        DutyVO vo = BeanMapper.map(entity, DutyVO.class);
        List<DutyDetailVO> dutyDetailVOList = vo.getDutyDetailList();
        vo.setDutyDetailList(TreeNodeBUtil.buildTree(dutyDetailVOList));

        //变更单保存
        if (entity.getLastDutyId() != null) {
            DutyEntity revise = this.getById(entity.getLastDutyId());
            revise.setLatestFlag(false);
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.变更中.getCode());
            this.saveOrUpdate(revise);
        }

        return CommonResponse.success("保存或修改单据成功！", queryDetail(vo.getId(), true));
    }

    private void checkExits(Long projectId) {
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        if (count(queryWrapper) > 0) {
            throw new BusinessException("该项目已存在目标责任成本！");
        }
    }

    private void checkExitsImportChange(DutyEntity dutyEntity) {
        if (ConversionEnum.云南路桥.getCode().equals(dutyEntity.getImportType())) {
            LambdaQueryWrapper<RoadbridgeDutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(RoadbridgeDutyEntity::getBaseDutyId, dutyEntity.getFirstImportId());
            queryWrapper.isNotNull(RoadbridgeDutyEntity::getLastDutyId);
            queryWrapper.notIn(RoadbridgeDutyEntity::getBillState, "1,3");
            if (roadbridgeDutyService.count(queryWrapper) > 0) {
                throw new BusinessException("该单据存在变更中的【路桥目标成本导入】单，不允许新增变更！");
            }
        } else if (ConversionEnum.云南房建.getCode().equals(dutyEntity.getImportType())) {
            LambdaQueryWrapper<BuildDutyEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(BuildDutyEntity::getBaseDutyId, dutyEntity.getFirstImportId());
            wrapper.isNotNull(BuildDutyEntity::getLastDutyId);
            wrapper.notIn(BuildDutyEntity::getBillState, "1,3");
            if (buildDutyService.count(wrapper) > 0) {
                throw new BusinessException("该单据存在变更中的【房建目标成本导入】单，不允许新增变更！");
            }
        }
    }

    @Override
    public DutyVO queryDetail(Long id, boolean hasChildren) {
        DutyEntity entity = selectById(id);
        //没查到说明是导入穿透过来的
        if (null == entity) {
            LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(DutyEntity::getImportId, id);
            DutyEntity tmpEntity = getOne(queryWrapper, false);
            entity = selectById(tmpEntity.getId());
        }

        FeeVO feeVO = feeService.queryDetail(entity.getFeeId(), false);
        Map<Long, List<FeeDetailVO>> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(feeVO.getFeeDetailList())) {
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getSelfRelatedFlag()) {
                    map.put(detailVO.getId(), detailVO.getRelatedList());
                }
            }
        }

        //遍历成本明细,查询费用明细业务范围
        List<DutyDetailEntity> dutyDetailEntityList = entity.getDutyDetailList();
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntityList) {
            dutyDetailEntity.setTid(dutyDetailEntity.getId().toString());
            dutyDetailEntity.setTpid(dutyDetailEntity.getParentId() != null && dutyDetailEntity.getParentId() > 0 ? dutyDetailEntity.getParentId().toString() : "");
            List<DutyDetailItemEntity> dutyDetailScopeEntityList = dutyDetailItemService.findByDutyDetailId(dutyDetailEntity.getId());
            dutyDetailEntity.setDutyDetailItemList(dutyDetailScopeEntityList);

            if (map.containsKey(dutyDetailEntity.getFeeDetailId())) {
                dutyDetailEntity.setRelatedDetailList(map.get(dutyDetailEntity.getFeeDetailId()));
            }
        }
        //实现排序
        Collections.sort(dutyDetailEntityList, new DutyDetailCompareEntity());
        entity.setDutyDetailList(dutyDetailEntityList);
        DutyVO vo = BeanMapper.map(entity, DutyVO.class);
        if (hasChildren) {
            vo.setDutyDetailList(TreeNodeBUtil.buildTree(vo.getDutyDetailList()));
        }

        return vo;
    }

    // 实现 Comparator 接口，并实现该接口的 compare 方法的类
    static class DutyDetailCompareEntity implements Comparator<DutyDetailEntity> {
        @Override
        public int compare(DutyDetailEntity o1, DutyDetailEntity o2) {
            String[] parts1 = o1.getTreeIndex().split("\\.");
            String[] parts2 = o2.getTreeIndex().split("\\.");

            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; i++) {
                int part1 = Integer.parseInt(parts1[i]);
                int part2 = Integer.parseInt(parts2[i]);

                if (part1 < part2) {
                    return -1;
                } else if (part1 > part2) {
                    return 1;
                }
            }
            // 如果前面的部分都相等，比较版本号长度
            return Integer.compare(parts1.length, parts2.length);
        }
    }

    @Override
    public DutyVO queryReviseDetail(Long id) {
        DutyVO vo = queryDetail(id, false);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDutyVersion(vo.getDutyVersion() + 1);
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDutyId(id);
        vo.setImportId(null);
        vo.setShowFlag(true);
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeMny(vo.getMny());
        vo.setBeforeTaxMny(vo.getTaxMny());
        vo.setMny(null);
        vo.setTaxMny(null);
        vo.setBeforeDutyVersion(vo.getDutyVersion() - 1);
        List<DutyDetailVO> changeDetailList = vo.getDutyDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            Map<String, Long> idMap = new HashMap<>();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setBeforeGatherMny(changeDetailVO.getGatherMny());
                changeDetailVO.setBeforeGatherTaxRate(changeDetailVO.getBeforeGatherTaxRate());
                changeDetailVO.setBeforeTaxRate(changeDetailVO.getTaxRate());
                changeDetailVO.setBeforeMny(changeDetailVO.getMny());
                changeDetailVO.setBeforeTaxMny(changeDetailVO.getTaxMny());
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
                List<DutyDetailItemVO> dutyDetailItemList = changeDetailVO.getDutyDetailItemList();
                if (CollectionUtils.isNotEmpty(dutyDetailItemList)) {
                    for (DutyDetailItemVO itemVO : dutyDetailItemList) {
                        itemVO.setId(IdWorker.getId());
                        itemVO.setCreateTime(null);
                        itemVO.setCreateUserCode(null);
                        itemVO.setUpdateTime(null);
                        itemVO.setUpdateUserCode(null);
                        itemVO.setDutyDetailId(changeDetailVO.getId());
                        itemVO.setBeforeAmount(itemVO.getAmount());
                        itemVO.setBeforeTaxRate(itemVO.getTaxRate());
                        itemVO.setBeforePrice(itemVO.getPrice());
                        itemVO.setBeforeTaxPrice(itemVO.getTaxPrice());
                        itemVO.setBeforeMny(itemVO.getMny());
                        itemVO.setBeforeTaxMny(itemVO.getTaxMny());
                    }
                }
            });
            for (DutyDetailVO cdEntity : changeDetailList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }

        vo.setDutyDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(DutyVO dutyVO) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckVO> checkDsVOS = new ArrayList<>();
        //查询合同总额
        CommonResponse<BigDecimal> commonResponse = proincomeContractApi.queryContranct(dutyVO.getProjectId());
        BigDecimal incomeMny = commonResponse.isSuccess() ? commonResponse.getData() : null;
        checkDsVOS.addAll(this.checkParamCode(dutyVO, incomeMny));
        checkDsVOS.addAll(checkParamBudgetMny(dutyVO, proincomeBudgetApi.queryAllBudgetMny(dutyVO.getProjectId()).getData()));
        checkDsVOS.addAll(this.checkParamCodeP(dutyVO, incomeMny));
        checkDsVOS.addAll(this.checkParamCodeR(dutyVO, incomeMny));
        checkDsVOS.addAll(this.checkWZ(dutyVO));
        checkDsVOS.addAll(this.checkLW(dutyVO));
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(checkDsVOS)) {
            for (ParamsCheckVO checkVO : checkDsVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVO = map.get(warnType);
                    checkDsVO.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVO);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }

        return paramsCheckVO;
    }

    @Override
    public List<ExecutionLinkVO> linkFeeScale(Long projectId, Long id) {
        List<ExecutionLinkVO> linkVOS = new ArrayList<>();
        CommonResponse<BigDecimal> commonResponse = proincomeContractApi.queryContranct(projectId);
        BigDecimal incomeMny = commonResponse.isSuccess() ? commonResponse.getData() : null;
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<DutyEntity>();
        queryWrapper.eq(DutyEntity::getId, id);
        List<DutyEntity> list = list(queryWrapper);
        List<DutyDetailEntity> listDetail = dutyDetailService.findByDutyId(list.get(0).getId());
        BigDecimal totalMny = BigDecimal.ZERO;
        for (DutyDetailEntity dutyDetailEntity : listDetail) {
            if (null == dutyDetailEntity.getParentId()) {
                ExecutionLinkVO linkVO = BeanMapper.map(dutyDetailEntity, ExecutionLinkVO.class);
                totalMny = ComputeUtil.safeAdd(totalMny, linkVO.getTaxMny());
                linkVO.setFeeDetailCode(dutyDetailEntity.getFeeDetailCode());
                linkVO.setName(dutyDetailEntity.getFeeDetailName());
                linkVO.setIncomeMny(incomeMny);
                linkVO.setContMnyScale(ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(linkVO.getTaxMny(), incomeMny)));
                linkVOS.add(linkVO);
            }
        }
        if (CollectionUtils.isNotEmpty(linkVOS)) {
            for (ExecutionLinkVO linkVO : linkVOS) {
                linkVO.setMnyScale(ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(linkVO.getTaxMny(), totalMny)));
            }
        }
        if (linkVOS.size() >= 7) {
            //计算直接费
            BigDecimal sumDirectMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumDirecttaxMny = new BigDecimal(0);//金额
            BigDecimal sumDirectMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumDirectContMnyScale = new BigDecimal(0);//占总造价比
            for (ExecutionLinkVO linkVO : linkVOS) {
                if ((linkVO.getFeeDetailCode().equals("01") || linkVO.getFeeDetailCode().equals("02") ||
                        linkVO.getFeeDetailCode().equals("03") || linkVO.getFeeDetailCode().equals("04") ||
                        linkVO.getFeeDetailCode().equals("05")) && linkVO.getMny() != null
                ) {
                    sumDirectMny = sumDirectMny.add(linkVO.getMny());
                    if (linkVO.getTaxMny() != null) {
                        sumDirecttaxMny = sumDirecttaxMny.add(linkVO.getTaxMny());
                    }

                }
            }
            sumDirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumDirecttaxMny, totalMny));//直接费占比
            sumDirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumDirecttaxMny, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO = new ExecutionLinkVO();
            executionLinkVO.setId(Long.parseLong("99999"));
            executionLinkVO.setName("小计(直接费)");
            executionLinkVO.setMny(sumDirectMny);
            executionLinkVO.setTaxMny(sumDirecttaxMny);
            executionLinkVO.setMnyScale(sumDirectMnyScale);
            executionLinkVO.setContMnyScale(sumDirectContMnyScale);
            //计算间接费
            BigDecimal sumIndirectMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumIndirecttaxMny = new BigDecimal(0);//金额
            BigDecimal sumIndirectMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumIndirectContMnyScale = new BigDecimal(0);//占总造价比
            for (ExecutionLinkVO linkVO : linkVOS) {
                if ((linkVO.getFeeDetailCode().equals("06") || linkVO.getFeeDetailCode().equals("07")) && linkVO.getMny() != null
                ) {
                    sumIndirectMny = sumIndirectMny.add(linkVO.getMny());
                    if (linkVO.getTaxMny() != null) {
                        sumIndirecttaxMny = sumIndirecttaxMny.add(linkVO.getTaxMny());
                    }

                }
            }
            sumIndirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumIndirecttaxMny, totalMny));//直接费占比
            sumIndirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumIndirecttaxMny, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO2 = new ExecutionLinkVO();
            executionLinkVO2.setId(Long.parseLong("88888"));
            executionLinkVO2.setName("小计(间接费)");
            executionLinkVO2.setMny(sumIndirectMny);
            executionLinkVO2.setTaxMny(sumIndirecttaxMny);
            executionLinkVO2.setMnyScale(sumIndirectMnyScale);
            executionLinkVO2.setContMnyScale(sumIndirectContMnyScale);

            //计算合计
            BigDecimal sumTotalMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumTotaltaxMny = new BigDecimal(0);//金额
            BigDecimal sumTotalMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumTotalContMnyScale = new BigDecimal(0);//占总造价比
            for (ExecutionLinkVO linkVO : linkVOS) {
                if (linkVO.getMny() != null) {
                    sumTotalMny = sumTotalMny.add(linkVO.getMny());
                }
                if (linkVO.getTaxMny() != null) {
                    sumTotaltaxMny = sumTotaltaxMny.add(linkVO.getTaxMny());
                }
                if (linkVO.getMnyScale() != null) {
                    sumTotalMnyScale = sumTotalMnyScale.add(linkVO.getMnyScale());
                }
            }
            sumTotalContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotaltaxMny, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO3 = new ExecutionLinkVO();
            executionLinkVO3.setId(Long.parseLong("66666"));
            executionLinkVO3.setName("合计");
            executionLinkVO3.setMny(sumTotalMny);
            executionLinkVO3.setTaxMny(sumTotaltaxMny);
            executionLinkVO3.setMnyScale(sumTotalMnyScale);
            executionLinkVO3.setContMnyScale(sumTotalContMnyScale);
            List<ExecutionLinkVO> linkVOList = new ArrayList<>();
            for (int i = 0; i <= 4; i++) {
                linkVOList.add(linkVOS.get(i));
            }
            linkVOList.add(executionLinkVO);
            for (int i = 5; i <= 6; i++) {
                linkVOList.add(linkVOS.get(i));
            }
            linkVOList.add(executionLinkVO2);
            linkVOList.add(executionLinkVO3);
            return linkVOList;
        } else {
            return linkVOS;
        }
    }

    @Override
    public List<Map<String, Object>> queryDuty() {
        List<Map<String, Object>> dutyVOList = dutyMapper.queryDuty();
       /* List<Map<String,Object>> dutyListMap = new ArrayList<>();
        Map<String,Object> dutyMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(dutyVOList)){
            for(DutyVO dutyList:dutyVOList){
                dutyMap.put(dutyList.getProjectId().toString(),dutyList.getCostCount());
            }

            dutyListMap.add(dutyMap);
        }*/
        return dutyVOList;
    }

    @Override
    public Map<Long, BigDecimal> queryDoc(Long projectId) {
        List<DutyDetailItemVO> dutyDetailItemVOList = dutyMapper.queryDoc(projectId);
        Map<Long, BigDecimal> dutyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dutyDetailItemVOList)) {
            for (DutyDetailItemVO dutyDetailItemVO : dutyDetailItemVOList) {
                dutyMap.put(dutyDetailItemVO.getDocId(), dutyDetailItemVO.getDocSumAmount());
            }
        }
        return dutyMap;
    }

    @Override
    public Map<Long, DutyDetailItemVO> queryDocDutyDetailItem(Long projectId, Integer docType) {
        List<DutyDetailItemVO> dutyDetailItemVOList = dutyMapper.queryDocDutyDetailItem(projectId, docType);
        Map<Long, DutyDetailItemVO> dutyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dutyDetailItemVOList)) {
            for (DutyDetailItemVO dutyDetailItemVO : dutyDetailItemVOList) {
                dutyMap.put(dutyDetailItemVO.getDocId(), dutyDetailItemVO);
            }
        }
        return dutyMap;
    }

    @Override
    public DutyVO gatherDuty(Long dutyId) {
        DutyVO dutyVO = queryDetail(dutyId, false);
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getProjectId, dutyVO.getProjectId());
//        queryWrapper.ne(DutyEntity::getId, dutyVO.getId());
        queryWrapper.orderByAsc(DutyEntity::getCreateTime);
        List<DutyEntity> dutyEntities = list(queryWrapper);
        //该项目首次做责任成本，而且不是变更，还没生成汇总成本
        if (dutyEntities.size() == 1) {
            //生效时
            if (!dutyEntities.get(0).getGatherFlag()) {
                DutyEntity gatherEntity = BeanMapper.map(dutyVO, DutyEntity.class);
                gatherEntity.setId(IdWorker.getId());
                gatherEntity.setName(gatherEntity.getProjectName() + "总目标责任成本");
                gatherEntity.setDutyVersion(1);
                gatherEntity.setChangeId(null);
                gatherEntity.setChangeState(null);
                gatherEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                gatherEntity.setLastDutyId(null);
                gatherEntity.setLatestFlag(true);
                gatherEntity.setEnableState(true);
                gatherEntity.setGatherFlag(true);
                gatherEntity.setWbsId(null);
                gatherEntity.setWbsName(null);
                gatherEntity.setEmployeeId(null);
                gatherEntity.setEmployeeName(null);
                gatherEntity.setDepartmentId(null);
                gatherEntity.setDepartmentName(null);
                gatherEntity.setCreateTime(null);
                gatherEntity.setCreateUserCode(null);
                gatherEntity.setUpdateTime(null);
                gatherEntity.setUpdateUserCode(null);
                gatherEntity.setVersion(1);
                gatherEntity.setOneTime(null);
                gatherEntity.setProFlag(false);
                gatherEntity.setFloatRate(null);
                gatherEntity.setImportId(null);
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), dutyVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    gatherEntity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                Map<Long, Long> map = new HashMap<>();
                List<DutyDetailItemEntity> insertList = new ArrayList<>();
                for (DutyDetailEntity dutyDetailEntity : gatherEntity.getDutyDetailList()) {
                    Long newId = IdWorker.getId();
                    map.put(dutyDetailEntity.getId(), newId);
                    dutyDetailEntity.setId(newId);
                    dutyDetailEntity.setDutyId(gatherEntity.getId());

                    //保存新成本明细档案项
                    List<DutyDetailItemEntity> dutyDetailItemList = dutyDetailEntity.getDutyDetailItemList();
                    if (CollectionUtils.isNotEmpty(dutyDetailItemList)) {
                        for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemList) {
                            dutyDetailItemEntity.setId(IdWorker.getId());
                            dutyDetailItemEntity.setDutyId(gatherEntity.getId());
                            dutyDetailItemEntity.setDutyDetailId(dutyDetailEntity.getId());//成本明细主键
                            insertList.add(dutyDetailItemEntity);
                        }
                    }
                }
                for (DutyDetailEntity dutyDetailEntity : gatherEntity.getDutyDetailList()) {
                    dutyDetailEntity.setParentId(map.get(dutyDetailEntity.getParentId()));
                }
                saveOrUpdate(gatherEntity, false);
                if (CollectionUtils.isNotEmpty(insertList)) {
                    dutyDetailItemService.saveOrUpdateBatch(insertList);
                }
            } else { //撤回时
                DutyEntity oldGatherEntity = dutyEntities.get(0);
                removeByIds(Arrays.asList(new Long[]{oldGatherEntity.getId()}), false);
                LambdaUpdateWrapper<DutyDetailItemEntity> delete = new LambdaUpdateWrapper<>();
                delete.eq(DutyDetailItemEntity::getDutyId, oldGatherEntity.getId());
                dutyDetailItemService.remove(delete);
            }
        } else {
            List<DutyVO> allDutyList = new ArrayList<>();
            DutyEntity oldGatherEntity = null;
            for (DutyEntity dutyEntity : dutyEntities) {
                if (dutyEntity.getGatherFlag()) {
                    oldGatherEntity = dutyEntity;
                } else {
                    allDutyList.add(queryDetail(dutyEntity.getId(), false));
                }
            }
            DutyEntity gatherEntity = BeanMapper.map(oldGatherEntity, DutyEntity.class);
            gatherEntity.setId(IdWorker.getId());
            gatherEntity.setMny(allDutyList.get(0).getMny());
            gatherEntity.setTaxMny(allDutyList.get(0).getTaxMny());
            gatherEntity.setCreateTime(null);
            gatherEntity.setCreateUserCode(null);
            gatherEntity.setUpdateTime(null);
            gatherEntity.setUpdateUserCode(null);
            gatherEntity.setVersion(1);
            gatherEntity.setOneTime(null);
            gatherEntity.setProFlag(false);
            gatherEntity.setFloatRate(null);

            Map<Long, DutyDetailEntity> detailMap = new HashMap<>();

            Map<Long, Long> map = new HashMap<>();
            for (DutyDetailVO detailVO : allDutyList.get(0).getDutyDetailList()) {
                DutyDetailEntity detailEntity = BeanMapper.map(detailVO, DutyDetailEntity.class);
                Long newId = IdWorker.getId();
                map.put(detailEntity.getId(), newId);
                detailEntity.setId(newId);
                detailEntity.setDutyId(gatherEntity.getId());
                for (DutyDetailItemEntity itemEntity : detailEntity.getDutyDetailItemList()) {
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setDutyId(gatherEntity.getId());
                    itemEntity.setDutyDetailId(detailEntity.getId());
                }
                detailMap.put(detailEntity.getFeeDetailId(), detailEntity);
            }

            for (DutyDetailEntity dutyDetailEntity : detailMap.values()) {
                dutyDetailEntity.setParentId(map.get(dutyDetailEntity.getParentId()));
            }

            for (int i = 1; i < allDutyList.size(); i++) {
                DutyVO duty = allDutyList.get(i);
                gatherEntity.setMny(ComputeUtil.safeAdd(gatherEntity.getMny(), duty.getMny()));
                gatherEntity.setTaxMny(ComputeUtil.safeAdd(gatherEntity.getTaxMny(), duty.getTaxMny()));

                for (DutyDetailVO detailVO : duty.getDutyDetailList()) {
                    DutyDetailEntity detailEntity = detailMap.get(detailVO.getFeeDetailId());
                    detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), detailVO.getMny()));
                    detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), detailVO.getTaxMny()));
                    detailEntity.setTaxRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(detailEntity.getTaxMny(), detailEntity.getMny()), detailEntity.getMny()), BigDecimal.valueOf(100)));
                    detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), detailVO.getPreTypeAmount()));
                    detailEntity.setGatherMny(ComputeUtil.safeAdd(detailEntity.getGatherMny(), detailVO.getGatherMny()));
                    detailEntity.setGatherTaxMny(ComputeUtil.safeAdd(detailEntity.getGatherTaxMny(), detailVO.getGatherTaxMny()));
                    detailEntity.setTotalAmount(ComputeUtil.safeAdd(detailEntity.getTotalAmount(), detailVO.getTotalAmount()));

                    Map<Long, DutyDetailItemEntity> itemMap = new HashMap<>();
                    List<DutyDetailItemEntity> itemList = new ArrayList<>();
                    for (DutyDetailItemEntity itemEntity : detailEntity.getDutyDetailItemList()) {
                        if (null != itemEntity.getDocId()) {
                            if (!itemMap.containsKey(itemEntity.getDocId())) {
                                itemMap.put(itemEntity.getDocId(), itemEntity);
                            }
                        } else {
                            itemList.add(itemEntity);
                        }
                    }

                    for (DutyDetailItemVO itemVO : detailVO.getDutyDetailItemList()) {
                        if (null != itemVO.getDocId()) {
                            if (itemMap.containsKey(itemVO.getDocId())) {
                                DutyDetailItemEntity itemEntity = itemMap.get(itemVO.getDocId());
                                itemEntity.setMny(ComputeUtil.safeAdd(itemEntity.getMny(), itemVO.getMny()));
                                itemEntity.setTaxMny(ComputeUtil.safeAdd(itemEntity.getTaxMny(), itemVO.getTaxMny()));
                                itemEntity.setTaxRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(itemEntity.getTaxMny(), itemEntity.getMny()), itemEntity.getMny()), BigDecimal.valueOf(100)));
                                itemEntity.setAmount(ComputeUtil.safeAdd(itemEntity.getAmount(), itemVO.getAmount()));
                                itemEntity.setPrice(ComputeUtil.safeDiv(itemEntity.getMny(), itemEntity.getAmount()));
                                itemEntity.setTaxPrice(ComputeUtil.safeDiv(itemEntity.getTaxMny(), itemEntity.getAmount()));
                                itemMap.put(itemEntity.getDocId(), itemEntity);
                            } else {
                                DutyDetailItemEntity itemEntity = BeanMapper.map(itemVO, DutyDetailItemEntity.class);
                                itemEntity.setId(IdWorker.getId());
                                itemEntity.setDutyId(gatherEntity.getId());
                                itemEntity.setDutyDetailId(detailEntity.getId());
                                itemMap.put(itemEntity.getDocId(), itemEntity);
                            }
                        } else {
                            DutyDetailItemEntity itemEntity = BeanMapper.map(itemVO, DutyDetailItemEntity.class);
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setDutyId(gatherEntity.getId());
                            itemEntity.setDutyDetailId(detailEntity.getId());
                            itemList.add(itemEntity);
                        }
                    }
                    itemList.addAll(itemMap.values());
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }

            gatherEntity.setDutyDetailList(new ArrayList<>(detailMap.values()));

            List<DutyDetailItemEntity> insertList = new ArrayList<>();
            for (DutyDetailEntity dutyDetailEntity : gatherEntity.getDutyDetailList()) {
                for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailEntity.getDutyDetailItemList()) {
                    insertList.add(dutyDetailItemEntity);
                }
            }
            saveOrUpdate(gatherEntity, false);
            if (CollectionUtils.isNotEmpty(insertList)) {
                dutyDetailItemService.saveOrUpdateBatch(insertList);
            }

            removeByIds(Arrays.asList(new Long[]{oldGatherEntity.getId()}), false);
            LambdaUpdateWrapper<DutyDetailItemEntity> delete = new LambdaUpdateWrapper<>();
            delete.eq(DutyDetailItemEntity::getDutyId, oldGatherEntity.getId());
            dutyDetailItemService.remove(delete);
        }
        return null;
    }

    @Override
    public CommonResponse<String> pushFromImport(BaseVO baseVO, Boolean isEff, String conversionType) {
        IConversioneHandler conversioneHandler = conversionManageFactory.getHandler(conversionType);
        CommonResponse<String> result = conversioneHandler.push(baseVO, isEff);
        return result;
    }

    @Override
    public CommonResponse<String> deleteFromImport(Long importId, String conversionType) {
        IConversioneHandler conversioneHandler = conversionManageFactory.getHandler(conversionType);
        CommonResponse<String> result = conversioneHandler.delete(importId);
        return result;
    }

    @Override
    public Map<Long, BigDecimal> queryPriceByDocIds(Long projectId, Integer docType, Boolean isRent, List<Long> docIds) {
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, true);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(DutyEntity::getBillState, billStatusList);
        DutyEntity dutyEntity = getOne(queryWrapper);
        if (null != dutyEntity) {
            LambdaQueryWrapper<DutyDetailItemEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(DutyDetailItemEntity::getDutyId, dutyEntity.getId());
            wrapper.eq(DutyDetailItemEntity::getProjectId, projectId);
            wrapper.eq(DutyDetailItemEntity::getDocType, docType);
            if (isRent) {
                wrapper.isNotNull(DutyDetailItemEntity::getRmatRentMonth);
            } else {
                wrapper.isNull(DutyDetailItemEntity::getRmatRentMonth);
            }
            wrapper.in(DutyDetailItemEntity::getDocId, docIds);
            List<DutyDetailItemEntity> list = dutyDetailItemService.list(wrapper);
            if (CollectionUtils.isNotEmpty(list)) {
                return list.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, DutyDetailItemEntity::getPrice, (key1, key2) -> key1));
            }
        }
        return null;
    }

    @Override
    public Map<Long, BigDecimal> querySumPreTypeAmount(Long projectId) {
        List<DutyDetailVO> dutyDetailVOList = dutyMapper.querySumPreTypeAmount(projectId);
        Map<Long, BigDecimal> dutyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dutyDetailVOList)) {
            for (DutyDetailVO dutyDetailVO : dutyDetailVOList) {
                dutyMap.put(dutyDetailVO.getCategoryId(), dutyDetailVO.getPreTypeAmount());
            }
        }
        return dutyMap;
    }

    @Override
    public void deleteList(List<DutyVO> vos) {
        for (DutyVO dutyVO : vos) {
            DutyEntity dutyEntity = this.getById(dutyVO.getId());
            if (dutyEntity.getLastDutyId() != null) {
                DutyEntity revise = this.getById(dutyEntity.getLastDutyId());
                revise.setChangeId(null);
                revise.setChangeState(ChangeStateEnum.未变更.getCode());
                revise.setLatestFlag(true);
                this.saveOrUpdate(revise);
            }
        }
        this.removeByIds(vos.stream().map(DutyVO::getId).collect(Collectors.toList()), true);
    }

    private List<ParamsCheckVO> checkParamBudgetMny(DutyVO dutyVO, BigDecimal budgetMny) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_BUDGET, dutyVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            for (BillParamVO billParamVO : billParamByCode.getData()) {
                List<ParamsCheckDsVO> dataSource = new ArrayList<>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                // 默认控制方式为提醒
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                // 不是none时需要控制
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(budgetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (dutyVO.getTaxMny() != null && dutyVO.getTaxMny().compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("目标成本超结");
                        paramsCheckDsVO.setWarnName("目标成本总额 > 预算书总金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次目标成本金额：").append(format(dutyVO.getTaxMny().doubleValue()))
                                .append("元，预算书总金额*").append(roleValue).append("%:").append(format(comMny.doubleValue()))
                                .append("元。超出金额：").append(format(ComputeUtil.safeSub(dutyVO.getTaxMny(), comMny).doubleValue())).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamCode(DutyVO dutyVO, BigDecimal incomeMny) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, dutyVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            for (BillParamVO billParamVO : billParamByCode.getData()) {
                List<ParamsCheckDsVO> dataSource = new ArrayList<>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                // 默认控制方式为提醒
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                // 不是none时需要控制
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(incomeMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (dutyVO.getTaxMny() != null && dutyVO.getTaxMny().compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("目标成本超结");
                        paramsCheckDsVO.setWarnName("目标成本总额 > 施工合同总额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次目标成本金额：").append(format(dutyVO.getTaxMny().doubleValue()))
                                .append("元，施工合同金额*").append(roleValue).append("%:").append(format(comMny.doubleValue()))
                                .append("元。超出金额：").append(format(ComputeUtil.safeSub(dutyVO.getTaxMny(), comMny).doubleValue())).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamCodeP(DutyVO dutyVO, BigDecimal incomeMny) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode_P = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_P, dutyVO.getOrgId());
        if (billParamByCode_P.isSuccess() && null != billParamByCode_P.getData()) {
            for (BillParamVO billParamVO : billParamByCode_P.getData()) {
                List<ParamsCheckDsVO> dataSource = new ArrayList<>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                // 默认控制方式为提醒
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }

                // 不是none时需要控制
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal countMny = new BigDecimal(0);//直接费用总额
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if ((dutyDetailVO.getFeeDetailCode().equals("01") || dutyDetailVO.getFeeDetailCode().equals("02") ||
                                dutyDetailVO.getFeeDetailCode().equals("03") || dutyDetailVO.getFeeDetailCode().equals("04") ||
                                dutyDetailVO.getFeeDetailCode().equals("05")) && dutyDetailVO.getTaxMny() != null
                        ) {
                            countMny = ComputeUtil.safeAdd(countMny, dutyDetailVO.getTaxMny());//countMny.add();
                        }
                    }
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(incomeMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (countMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("目标成本超结");
                        paramsCheckDsVO.setWarnName("目标成本直接费总额 > 施工合同总额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次目标成本直接费总额：").append(format(countMny.doubleValue()))
                                .append("元，施工合同金额*").append(roleValue).append("%:").append(format(comMny.doubleValue()))
                                .append("元。超出金额：").append(format(ComputeUtil.safeSub(countMny, comMny).doubleValue())).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }
        } else {
            logger.info(billParamByCode_P.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamCodeR(DutyVO dutyVO, BigDecimal incomeMny) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode_R = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_R, dutyVO.getOrgId());
        if (billParamByCode_R.isSuccess() && null != billParamByCode_R.getData()) {
            for (BillParamVO billParamVO : billParamByCode_R.getData()) {
                List<ParamsCheckDsVO> dataSource = new ArrayList<>();
                ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                // 默认控制方式为提醒
                if (1 == billParamVO.getControlType()) {
                    paramsCheckVO.setWarnType(paramsArray[1]);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                }
                // 不是none时需要控制
                if (!"none".equals(paramsCheckVO.getWarnType())) {
                    BigDecimal personMny = new BigDecimal(0);//人工费
                    BigDecimal proMny = new BigDecimal(0);//专业分包费
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (dutyDetailVO.getFeeDetailCode().equals("01") && dutyDetailVO.getTaxMny() != null
                        ) {
                            personMny = personMny.add(dutyDetailVO.getTaxMny());
                        }
                        if (dutyDetailVO.getFeeDetailCode().equals("04") && dutyDetailVO.getTaxMny() != null
                        ) {
                            proMny = proMny.add(dutyDetailVO.getTaxMny());
                        }
                    }
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    logger.info("控制规则值-----------------------------------" + roleValue);
                    BigDecimal value = ComputeUtil.safeDiv(roleValue, new BigDecimal(100));
                    logger.info("控制规则值百分比-----------------------------------" + value);
                    //施工合同金额-专业分包费用 * 25%
                    logger.info("施工合同金额------" + incomeMny + "---------------------专业分包费用--------" + proMny);
                    BigDecimal comMny = ComputeUtil.safeMultiply(ComputeUtil.safeSub(incomeMny, proMny), value).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (personMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("目标成本超结");
                        paramsCheckDsVO.setWarnName("目标成本人工费 > (施工合同总金额-专业分包费用)*" + roleValue + "%");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次目标成本人工费：").append(format(personMny.doubleValue()))
                                .append("元，(施工合同总金额-专业分包费用)* ").append(roleValue).append("%:").append(format(comMny.doubleValue()))
                                .append("元。超出金额：").append(format(ComputeUtil.safeSub(personMny, comMny).doubleValue())).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
                paramsCheckVOList.add(paramsCheckVO);
            }
        } else {
            logger.info(billParamByCode_R.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkWZ(DutyVO dutyVO) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode_WZ = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_WZ, dutyVO.getOrgId());
        List<BillParamVO> data = billParamByCode_WZ.getData();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 为none时不需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                //物料档案 --------
                if (billParamByCode_WZ.isSuccess() && null != billParamByCode_WZ.getData()) {
                    BigDecimal small = new BigDecimal(0);//小
                    BigDecimal max = new BigDecimal(0);//大
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (CollectionUtils.isNotEmpty(dutyDetailVO.getDutyDetailItemList())) {
                            for (DutyDetailItemVO dutyDetailItemVO : dutyDetailVO.getDutyDetailItemList()) {
                                if (dutyDetailVO.getDocType() != null && dutyDetailVO.getDocType() == 3) {
                                    if (dutyDetailItemVO.getHistoricalPrice() != null && dutyDetailItemVO.getHistoricalPrice() != "") {
                                        String[] historicalPrice = dutyDetailItemVO.getHistoricalPrice().split("-");
                                        small = new BigDecimal(historicalPrice[0]);
                                        max = new BigDecimal(historicalPrice[1]);
                                        if (small.equals(max)) {
                                            continue;
                                        }
                                        if (dutyDetailItemVO.getPrice() != null) {
                                            if (dutyDetailItemVO.getPrice().compareTo(small) == -1) { // 判断目标金额小于最低价
                                                BigDecimal difference = ComputeUtil.safeSub(small, dutyDetailItemVO.getPrice()); // 计算差额
                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName() + dutyDetailItemVO.getModel());//此处 材料名称+规格型号
                                                paramsCheckDsVO.setWarnName("目标价小于历史最低价格");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("目标单价：").append(format(dutyDetailItemVO.getPrice().doubleValue()))
                                                        .append("元，历史价格区间：").append(dutyDetailItemVO.getHistoricalPrice())
                                                        .append(",历史最低价：").append(small.doubleValue()).append(",低于最低价：")
                                                        .append(difference.doubleValue()).append("元。");
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                dataSource.add(paramsCheckDsVO);
                                                paramsCheckVO.setDataSource(dataSource);
                                            } else if (dutyDetailItemVO.getPrice().compareTo(max) == 1) { // 判断目标金大于最高价
                                                BigDecimal difference = ComputeUtil.safeSub(dutyDetailItemVO.getPrice(), max); // 计算差额
                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName() + dutyDetailItemVO.getModel());//此处 材料名称+规格型号
                                                paramsCheckDsVO.setWarnName("目标价大于历史最高价格");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("目标单价：").append(format(dutyDetailItemVO.getPrice().doubleValue()))
                                                        .append("元，历史价格区间：").append(dutyDetailItemVO.getHistoricalPrice())
                                                        .append(",历史最高价：").append(max.doubleValue()).append(",超出最高价：")
                                                        .append(difference.doubleValue()).append("元。");
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                                dataSource.add(paramsCheckDsVO);
                                                paramsCheckVO.setDataSource(dataSource);
                                            } else {
                                                // 无需控制
                                                paramsCheckVO.setWarnType(paramsArray[0]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                }
                //物料档案 --------
                else {
                    logger.info(billParamByCode_WZ.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkLW(DutyVO dutyVO) {
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> billParamByCode_LW = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE_LW, dutyVO.getOrgId());
        List<BillParamVO> data = billParamByCode_LW.getData();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 为none时不需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                //劳务分包方案 --------
                if (billParamByCode_LW.isSuccess() && null != billParamByCode_LW.getData()) {
                    BigDecimal small = new BigDecimal(0);//小
                    BigDecimal max = new BigDecimal(0);//大
                    for (DutyDetailVO dutyDetailVO : dutyVO.getDutyDetailList()) {
                        if (CollectionUtils.isNotEmpty(dutyDetailVO.getDutyDetailItemList())) {
                            for (DutyDetailItemVO dutyDetailItemVO : dutyDetailVO.getDutyDetailItemList()) {
                                if (dutyDetailVO.getDocType() != null && dutyDetailVO.getDocType() == 1) {
                                    if (dutyDetailItemVO.getHistoricalPrice() != null && dutyDetailItemVO.getHistoricalPrice() != "") {
                                        String[] historicalPrice = dutyDetailItemVO.getHistoricalPrice().split("-");
                                        small = new BigDecimal(historicalPrice[0]);
                                        max = new BigDecimal(historicalPrice[1]);
                                        if (small.equals(max)) {
                                            break;
                                        }
                                        if (dutyDetailItemVO.getPrice() != null) {
                                            if (dutyDetailItemVO.getPrice().compareTo(small) == -1) { // 判断目标金额小于最低价
                                                BigDecimal difference = ComputeUtil.safeSub(small, dutyDetailItemVO.getPrice()); // 计算差额
                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName());//此处 分包清单名称
                                                paramsCheckDsVO.setWarnName("目标价小于历史最低价格");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("目标单价：").append(format(dutyDetailItemVO.getPrice().doubleValue()))
                                                        .append("元，历史价格区间：").append(dutyDetailItemVO.getHistoricalPrice())
                                                        .append(",历史最低价：").append(small.doubleValue()).append(",低于最低价：")
                                                        .append(difference.doubleValue()).append("元。");
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                                dataSource.add(paramsCheckDsVO);
                                                paramsCheckVO.setDataSource(dataSource);
                                            } else if (dutyDetailItemVO.getPrice().compareTo(max) == 1) { // 判断目标金大于最高价
                                                BigDecimal difference = ComputeUtil.safeSub(dutyDetailItemVO.getPrice(), max); // 计算差额
                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setWarnItem(dutyDetailItemVO.getName());//此处 分包清单名称
                                                paramsCheckDsVO.setWarnName("目标价大于历史最高价格");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("目标单价：").append(format(dutyDetailItemVO.getPrice().doubleValue()))
                                                        .append("元，历史价格区间：").append(dutyDetailItemVO.getHistoricalPrice())
                                                        .append(",历史最高价：").append(max.doubleValue()).append(",超出最高价：")
                                                        .append(difference.doubleValue()).append("元。");
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                                dataSource.add(paramsCheckDsVO);
                                                paramsCheckVO.setDataSource(dataSource);
                                            } else {
                                                // 无需控制
                                                paramsCheckVO.setWarnType(paramsArray[0]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                }
                //劳务分包方案 --------
                else {
                    logger.info(billParamByCode_LW.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }


        return paramsCheckVOList;
    }

    //判断是否变更 0未变更 1已变更
    private int getChangeFlag(BigDecimal one, BigDecimal two) {
        int flag;
        if (one.compareTo(two) == 0) {
            flag = 0;
        } else {
            flag = 1;
        }
        return flag;
    }

    //保留两位小数
    public static String format(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);//调用setScale方法进行数据格式化，保留两位小数，采用四舍五入规则
        return bd.toString();
    }

    /**
     * 查询当前项目是否存在目标责任成本
     *
     * @param projectId
     */
    @Override
    public CommonResponse<Boolean> queryDutyByProjectId(Long projectId) {
        QueryWrapper<DutyEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("enable_state", true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", billStatusList);
//        queryWrapper.ne("change_state",1);
        List<DutyEntity> list = super.list(queryWrapper);
        return null != list && CollectionUtils.isNotEmpty(list) ? CommonResponse.success(true) : CommonResponse.success(false);
    }

    @Override
    public CommonResponse<List<Long>> queryDutyByProjectIds(List<Long> projectIds) {
        QueryWrapper<DutyEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("project_id", projectIds);
        queryWrapper.eq("enable_state", true);
        List<Integer> billStatusList = new ArrayList<>();
        billStatusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStatusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", billStatusList);
//        queryWrapper.ne("change_state",1);
        List<DutyEntity> list = super.list(queryWrapper);
        return CollectionUtils.isNotEmpty(list) ? CommonResponse.success("查询成功！", list.stream().map(DutyEntity::getProjectId).collect(Collectors.toList()))
                : CommonResponse.success("查询成功！", new ArrayList<>());
    }

    @Override
    public CommonResponse<List<BuildDutyVO>> buildQueryProjects(List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        List<BuildDutyEntity> queryList = buildDutyService.queryList(param);
        List<BuildDutyVO> dutyVOS = BeanMapper.mapList(queryList, BuildDutyVO.class);
        return CommonResponse.success("查询成功！", dutyVOS);
    }

    /**
     * 将推送生成的目标责任成本置为生效状态（代替流程审批生效回调 ZHHT）
     *
     * @param buildDutyId
     * @param isEff
     * @param type
     */
    @Override
    @Async(value = "taCommonTask")
    public void handleBill(Long buildDutyId, boolean isEff, String type, Long userId) {
        logger.info("*******************将项目策划单id-{}对应目标责任成本单置为生效状态  START *******************");
        //0、上下文初始化
        initContext(userId);

        //1、查询对应的目标责任成本单据
        DutyEntity dutyEntity = null;
        Integer tryTime = 0; //重试三次

        //2、准备查询参数
        QueryWrapper<DutyEntity> query = new QueryWrapper<>();
        query.eq("import_id", buildDutyId);

        try {
            while (null == dutyEntity && tryTime < 3) {
                dutyEntity = super.getOne(query);
                if (null == dutyEntity) {
                    //5秒后重试
                    TimeUnit.SECONDS.sleep(5);
                }
                if (null != dutyEntity) {

                    //3、执行目标责任成本审批生效后逻辑
                    dutyEntity.setEnableState(isEff);
                    super.saveOrUpdate(dutyEntity);

                    //弃审,存在前版本，单据是否生效为是
                    if (dutyEntity.getLastDutyId() != null) {
                        DutyEntity revise = super.getById(dutyEntity.getLastDutyId());
                        revise.setChangeState(isEff ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
                        revise.setEnableState(!isEff);
                        super.saveOrUpdate(revise);
                    }

                    if (isEff) {
                        updateItemSubjectInner(dutyEntity.getId());
                        this.gatherDuty(dutyEntity.getId());
                    }

                    totalExecutionService.reCalc(dutyEntity.getProjectId());
                }
            }
        } catch (Exception e) {
            logger.error("将项目策划单id-" + buildDutyId.toString() + "对应目标责任成本单置为生效状态", e);
        }
        logger.info("*******************将项目策划单id-{}对应目标责任成本单置为生效状态  END *******************");
    }

    private void updateItemSubjectInner(Long dutyId) {
        CommonResponse<List<SubjectOrgVO>> subjectResponse = shareSubjectOrgApi.shareSubjectOrgApi();
        Map<Long, SubjectOrgVO> subjectMap = new HashMap<>();
        if (subjectResponse.isSuccess() && CollectionUtils.isNotEmpty(subjectResponse.getData())) {
            subjectMap = subjectResponse.getData().stream().collect(Collectors.toMap(SubjectOrgVO::getId, Function.identity(), (key1, key2) -> key1));
        }
        LambdaQueryWrapper<DutyDetailItemEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyDetailItemEntity::getDutyId, dutyId);
        queryWrapper.isNull(DutyDetailItemEntity::getSubjectInnerCode);
        queryWrapper.isNotNull(DutyDetailItemEntity::getSubjectId);
        List<DutyDetailItemEntity> list = dutyDetailItemService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            for (DutyDetailItemEntity itemEntity : list) {
                SubjectOrgVO subjectOrgVO = subjectMap.get(itemEntity.getSubjectId());
                itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
                itemEntity.setSubjectInnerCode(subjectOrgVO.getInnerCode());
            }
            dutyDetailItemService.saveOrUpdateBatch(list);
        }
    }


    private void initContext(Long userId) {
        String initContextUrl = environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId=" + userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = userContextResponse.getData().getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get("userType"))
                            .append(";userCode=").append(userContext.get("userCode"))
                            .append(";orgId=").append(userContext.get("orgId"))
                            .append(";tenantid=").append(userContext.get("tenantid"))
                            .append(";token=").append(userContext.get("token"))
                            .append(";u_logints=").append(userContext.get("u_logints"))
                            .append(";u_usercode=").append(userContext.get("u_usercode"))
                            .append(";userId=").append(userContext.get("userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid(userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
                }
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：", e);
        }

    }
}
