package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("duty")
public class DutyBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IDutyService dutyService;

	@Autowired
	private IDutyDetailItemService dutyDetailItemService;


	@Autowired
	private ITotalExecutionService totalExecutionService;
	@Autowired
	private IShareSubjectOrgApi shareSubjectOrgApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================提交前回调====================================== state:"+state);
		/*LambdaQueryWrapper<DutyDetailItemEntity> query = new LambdaQueryWrapper<>();
		query.eq(DutyDetailItemEntity::getDutyId, billId);
		List<DutyDetailItemEntity> dutyDetailItemEntityList = dutyDetailItemService.list(query);
		for(DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList){
			if(dutyDetailItemEntity.getTaxRate() == null){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,税率必填！ ");

			}
			if(dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,数量必填！");
			}
			if(dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ "，单价(无税)必填！");

			}
			if(dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单价必填！");
			}
			if(dutyDetailItemEntity.getUnitName() == null){
				throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单位必填！");
			}
		}*/
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		DutyEntity dutyEntity = dutyService.selectById(billId);
		logger.info("state---------------有审批流的撤回前回调-------------------"+state);
		if (state == 0){ // 点击撤回进入流程，   驳回state传4，直接成功
			if(dutyEntity.getLastDutyId()==null) {
				if (BooleanUtils.isFalse(dutyEntity.getLatestFlag()) || (1 != dutyEntity.getDutyVersion() && BooleanUtils.isFalse(dutyEntity.getEnableState()))) {
					throw new BusinessException("非最新生效版本，不能撤回！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		totalExecutionService.reCalc(dutyService.selectById(billId).getProjectId());
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================终审审核前回调====================================== state:"+state);
		/*if(state == 0){
			LambdaQueryWrapper<DutyDetailItemEntity> query = new LambdaQueryWrapper<>();
			query.eq(DutyDetailItemEntity::getDutyId, billId);
			List<DutyDetailItemEntity> dutyDetailItemEntityList = dutyDetailItemService.list(query);
			for(DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList){
				if(dutyDetailItemEntity.getTaxRate() == null){//需求确认，税率不校验为0情况！
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,税率必填！ ");
				}
				if(dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】,数量必填！");
				}
				if(dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ "，单价(无税)必填！");

				}
				if(dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单价必填！");
				}
				if(dutyDetailItemEntity.getUnitName() == null){
					throw new BusinessException("请检查右侧明细，名称【"+dutyDetailItemEntity.getName()+"】"+ ",单位必填！");
				}
			}
		}*/
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//审核完成是否生效修改为是
		updateEnableAndWriteBack(billId, true);
		updateItemSubjectInner(billId);
		dutyService.gatherDuty(billId);
		totalExecutionService.reCalc(dutyService.selectById(billId).getProjectId());
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("state---------------弃审前事件回调-------------------"+state);
		DutyEntity dutyEntity = dutyService.selectById(billId);
		if(!(dutyEntity.getEnableState() && dutyEntity.getLatestFlag())){
			throw new BusinessException("非最新生效版本，不能弃审！");
		}else if(null != dutyEntity.getImportId()){
			throw new BusinessException("导入推送数据，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//弃审是否生效修改为否
		updateEnableAndWriteBack(billId, false);
		dutyService.gatherDuty(billId);
		totalExecutionService.reCalc(dutyService.selectById(billId).getProjectId());
		return CommonResponse.success();
	}

	private void updateEnableAndWriteBack(Long billId, Boolean isPass){
		DutyEntity dutyEntity = dutyService.getById(billId);
		dutyEntity.setEnableState(isPass);
		dutyService.saveOrUpdate(dutyEntity);
		//弃审,存在前版本，单据是否生效为是
		if(dutyEntity.getLastDutyId()!=null){
			DutyEntity revise = dutyService.getById(dutyEntity.getLastDutyId());
			revise.setChangeState(isPass ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
			revise.setEnableState(!isPass);
			dutyService.saveOrUpdate(revise);
		}
	}

	private void updateItemSubjectInner(Long billId){
		CommonResponse<List<SubjectOrgVO>> subjectResponse = shareSubjectOrgApi.shareSubjectOrgApi();
		Map<Long, SubjectOrgVO> subjectMap = new HashMap<>();
		if(subjectResponse.isSuccess() && CollectionUtils.isNotEmpty(subjectResponse.getData())){
			subjectMap = subjectResponse.getData().stream().collect(Collectors.toMap(SubjectOrgVO::getId, Function.identity(), (key1, key2) -> key1));
		}
		LambdaQueryWrapper<DutyDetailItemEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(DutyDetailItemEntity::getDutyId, billId);
		queryWrapper.isNull(DutyDetailItemEntity::getSubjectInnerCode);
		queryWrapper.isNotNull(DutyDetailItemEntity::getSubjectId);
		List<DutyDetailItemEntity> list = dutyDetailItemService.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(list)) {
			for(DutyDetailItemEntity itemEntity : list){
				SubjectOrgVO subjectOrgVO = subjectMap.get(itemEntity.getSubjectId());
				itemEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
				itemEntity.setSubjectName(subjectOrgVO.getSubjectName());
				itemEntity.setSubjectInnerCode(subjectOrgVO.getInnerCode());
			}
			dutyDetailItemService.saveOrUpdateBatch(list);
		}
	}
}
