/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.utils;

import com.ejianc.business.zhht.utils.ThreadContextDecorator;
import com.ejianc.framework.core.util.EnvironmentTools;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class TargetTaskPoolConfig {
    @Autowired
    private EnvironmentTools environmentTools;

    @Bean(name={"maContextCommonTask"})
    public Executor maContextCommonTask() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(2);
        executor.setMaxPoolSize(8);
        executor.setQueueCapacity(16);
        executor.setKeepAliveSeconds(60);
        executor.setTaskDecorator((TaskDecorator)new ThreadContextDecorator(this.environmentTools.getBaseHost()));
        executor.setThreadNamePrefix("commonTaskExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(name={"taCommonTask"})
    public Executor commonTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(2);
        executor.setMaxPoolSize(8);
        executor.setQueueCapacity(16);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("commonTaskExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }
}

