/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.costinspection.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.costinspection.bean.SiteTrackingEntity;
import com.ejianc.business.costinspection.mapper.SiteTrackingMapper;
import com.ejianc.business.costinspection.service.ISiteTrackingService;
import com.ejianc.business.costinspection.vo.SiteTrackingVO;
import com.ejianc.business.costinspection.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"siteTracking"})
public class SiteTrackingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISiteTrackingService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SiteTrackingMapper mapper;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SiteTrackingVO> saveOrUpdate(@RequestBody SiteTrackingVO saveOrUpdateVO) {
        SiteTrackingEntity entity = (SiteTrackingEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SiteTrackingEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SiteTrackingVO vo = (SiteTrackingVO)BeanMapper.map((Object)((Object)entity), SiteTrackingVO.class);
        vo.setSiteTrackingContentList(TreeNodeBUtil.buildTree((List)vo.getSiteTrackingContentList()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SiteTrackingVO> queryDetail(Long id) {
        SiteTrackingEntity entity = (SiteTrackingEntity)((Object)this.service.selectById(id));
        SiteTrackingVO vo = (SiteTrackingVO)BeanMapper.map((Object)((Object)entity), SiteTrackingVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getSiteTrackingContentList())) {
            vo.setSiteTrackingContentList(TreeNodeBUtil.buildTree((List)vo.getSiteTrackingContentList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SiteTrackingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SiteTrackingVO siteTrackingVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SiteTrackingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SiteTrackingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SiteTracking-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSiteTrackingData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SiteTrackingVO>> refSiteTrackingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (con = JSONObject.parseObject((String)condition)) != null) {
            String isRectificationForm = con.getString("isRectificationForm");
            param.getParams().put("isRectificationForm", new Parameter("eq", (Object)isRectificationForm));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SiteTrackingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SiteTrackingVO>> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<SiteTrackingVO> siteTrackingVOS = this.mapper.reportList((Page<SiteTrackingVO>)page, wrapper);
        List siteIds = siteTrackingVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        List noticeIds = siteTrackingVOS.stream().map(SiteTrackingVO::getNoticeId).collect(Collectors.toList());
        List reportIds = siteTrackingVOS.stream().map(SiteTrackingVO::getReportId).collect(Collectors.toList());
        siteIds.addAll(noticeIds);
        siteIds.addAll(reportIds);
        HashSet<Long> set = new HashSet<Long>(siteIds);
        Long[] array = new Long[set.size()];
        set.toArray(array);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceIds", (Object)array);
        jsonObject.put("orderType", (Object)"desc");
        Map<Object, Object> collect = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(jsonObject);
        if (listCommonResponse.getCode() == 0 && listCommonResponse.getData() != null) {
            collect = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(x -> String.format("%s:%s", x.getSourceId(), x.getSourceType()), AttachmentVO2 -> AttachmentVO2, (k1, k2) -> k1));
        }
        if (collect.size() > 0 && siteTrackingVOS != null) {
            for (SiteTrackingVO siteTrackingVO : siteTrackingVOS) {
                if (collect.containsKey(siteTrackingVO.getId() + ":file1")) {
                    siteTrackingVO.setGzFileName(((AttachmentVO)collect.get(siteTrackingVO.getId() + ":file1")).getFileName());
                    siteTrackingVO.setGzFileUrl(((AttachmentVO)collect.get(siteTrackingVO.getId() + ":file1")).getId() + "");
                } else {
                    siteTrackingVO.setGzFileName("\u65e0");
                    siteTrackingVO.setGzFileUrl("");
                }
                if (collect.containsKey(siteTrackingVO.getId() + ":file2")) {
                    siteTrackingVO.setZgFileName(((AttachmentVO)collect.get(siteTrackingVO.getId() + ":file2")).getFileName());
                    siteTrackingVO.setZgFileUrl(((AttachmentVO)collect.get(siteTrackingVO.getId() + ":file2")).getId() + "");
                } else {
                    siteTrackingVO.setZgFileName("\u65e0");
                    siteTrackingVO.setZgFileUrl("");
                }
                if (collect.containsKey(siteTrackingVO.getNoticeId() + ":file1")) {
                    siteTrackingVO.setHfFileName(((AttachmentVO)collect.get(siteTrackingVO.getNoticeId() + ":file1")).getFileName());
                    siteTrackingVO.setHfFileUrl(((AttachmentVO)collect.get(siteTrackingVO.getNoticeId() + ":file1")).getId() + "");
                } else {
                    siteTrackingVO.setHfFileName("\u65e0");
                    siteTrackingVO.setHfFileUrl("");
                }
                if (collect.containsKey(siteTrackingVO.getReportId() + ":file1")) {
                    siteTrackingVO.setBgFileName(((AttachmentVO)collect.get(siteTrackingVO.getReportId() + ":file1")).getFileName());
                    siteTrackingVO.setBgFileUrl(((AttachmentVO)collect.get(siteTrackingVO.getReportId() + ":file1")).getId() + "");
                    continue;
                }
                siteTrackingVO.setBgFileName("\u65e0");
                siteTrackingVO.setBgFileUrl("");
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(siteTrackingVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

