package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.*;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单个推送计算
 */
public class PushCalcExecCallable implements Callable<CommonResponse<String>> {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static  final  String  TC_LOCK = "TC_LOCK::";

    private RequestAttributes context;
    private String authority;
    private ExecutionVO executionVO;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private IDutyService dutyService;
    private IDutyDetailService dutyDetailService;
    private IDutyDetailItemService dutyDetailItemService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;

    public PushCalcExecCallable(RequestAttributes context, String authority, ExecutionVO executionVO, RedissonClient redissonClient, ITotalCacheService totalCacheService,
                                IDetailCacheService detailCacheService,  IDutyService dutyService,  IDutyDetailService dutyDetailService,
                                IDutyDetailItemService dutyDetailItemService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService ) {
        this.context = context;
        this.authority = authority;
        this.executionVO = executionVO;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyService = dutyService;
        this.dutyDetailService = dutyDetailService;
        this.dutyDetailItemService = dutyDetailItemService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
    }

    @Override
    public CommonResponse<String> call() throws Exception {
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        //获取锁对象
        String lockKey = TC_LOCK + totalExecutionVO.getProjectId();
        RLock mylock = redissonClient.getLock(lockKey);
        try {
            //加锁，并且设置锁过期时间，防止死锁的产生
            boolean lock = mylock.tryLock(20, TimeUnit.SECONDS);
            if(!lock){
                return CommonResponse.error("获取锁失败：" + totalExecutionVO.getProjectId());
            }
            LambdaQueryWrapper<DutyEntity> feeQuery = new LambdaQueryWrapper<>();
            feeQuery.eq(DutyEntity::getProjectId, totalExecutionVO.getProjectId());
            feeQuery.eq(DutyEntity::getEnableState, true);
            feeQuery.eq(DutyEntity::getGatherFlag, true);
            List<DutyEntity> dutyEntities = dutyService.list(feeQuery);
            if (CollectionUtils.isEmpty(dutyEntities)) {
                mylock.unlock();
                return CommonResponse.success("该项目没有生效的目标成本");
            }

            List<Long> feeDetailPks = queryFeeDetailPks(dutyEntities.get(0).getFeeId(), totalExecutionVO);
            if (CollectionUtils.isEmpty(feeDetailPks)) {
                mylock.unlock();
                return CommonResponse.success("该业务单据没有对应的费用项明细");
            }

            Set<Long> keySet = null;

            if (CollectionUtils.isNotEmpty(executionVO.getDetailList())) {
                keySet =  cacheDetails(dutyEntities.get(0), executionVO, feeDetailPks);
            }

            cacheTotal(dutyEntities.get(0), executionVO, feeDetailPks);

            if (CollectionUtils.isNotEmpty(keySet)) {
                detailCacheService.deleteByIdsPhy(new ArrayList<Long>(keySet));
            }
        } catch (Exception e) {
            logger.error("推送目标成本汇总缓存失败:" + JSONObject.toJSONString(e));
        }finally {
            mylock.unlock();
        }
        return CommonResponse.success("单个推送计算缓存表成功");
    }

    private List<Long> queryFeeDetailPks(Long feeId, TotalExecutionVO totalExecutionVO) {
        LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeId, feeId);
        scopeQuery.eq(FeeDetailScopeEntity::getBillCode, totalExecutionVO.getBussinessType());
        scopeQuery.eq(FeeDetailScopeEntity::getPropertyValue, totalExecutionVO.getProperty());
        List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
        if (CollectionUtils.isNotEmpty(scopeEntities)) {
            return scopeEntities.stream().map(FeeDetailScopeEntity::getFeeDetailId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    private void setValue(TotalCacheEntity totalCacheEntity, TotalExecutionVO totalExecutionVO){
        if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setPlanNum(null);
            totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setContNum(null);
            totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setStoreNum(null);
            totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setOtherNum(null);
            totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), totalExecutionVO.getTaxMoney()));
        }
    }

    private void setValue(TotalCacheEntity totalCacheEntity, List<DetailCacheEntity> itemEntityList, TotalExecutionVO totalExecutionVO){
        if(totalCacheEntity.getLeafFlag() && BooleanUtils.isTrue(totalCacheEntity.getSelfScopeFlag()) && !DocTypeEnum.成本科目.getCode().equals(totalCacheEntity.getDocType())){
            if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), totalExecutionVO.getTaxMoney()));
            }
        }else{
            if(totalCacheEntity.getLeafFlag()){
                if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setPlanMoney(null);
                    totalCacheEntity.setPlanNum(null);
                    totalCacheEntity.setPlanTaxMoney(null);
                    totalCacheEntity.setOutPlanMoney(null);
                    totalCacheEntity.setOutPlanTaxMoney(null);
                }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setContMoney(null);
                    totalCacheEntity.setContNum(null);
                    totalCacheEntity.setContTaxMoney(null);
                    totalCacheEntity.setOutContMoney(null);
                    totalCacheEntity.setOutContTaxMoney(null);
                }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setStoreMoney(null);
                    totalCacheEntity.setStoreNum(null);
                    totalCacheEntity.setStoreTaxMoney(null);
                    totalCacheEntity.setOutStoreMoney(null);
                    totalCacheEntity.setOutStoreTaxMoney(null);
                }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setOtherMoney(null);
                    totalCacheEntity.setOtherNum(null);
                    totalCacheEntity.setOtherTaxMoney(null);
                    totalCacheEntity.setOutOtherMoney(null);
                    totalCacheEntity.setOutOtherTaxMoney(null);
                }
            }
            if(CollectionUtils.isNotEmpty(itemEntityList)){
                for(DetailCacheEntity detailCacheEntity : itemEntityList){
                    if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setPlanNum(ComputeUtil.safeAdd(totalCacheEntity.getPlanNum(), detailCacheEntity.getPlanNum()));
                        totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), detailCacheEntity.getPlanMoney()));
                        totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), detailCacheEntity.getPlanTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutPlanMoney(), detailCacheEntity.getPlanMoney()));
                            totalCacheEntity.setOutPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutPlanTaxMoney(), detailCacheEntity.getPlanTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setContNum(ComputeUtil.safeAdd(totalCacheEntity.getContNum(), detailCacheEntity.getContNum()));
                        totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), detailCacheEntity.getContMoney()));
                        totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), detailCacheEntity.getContTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutContMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutContMoney(), detailCacheEntity.getContMoney()));
                            totalCacheEntity.setOutContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutContTaxMoney(), detailCacheEntity.getContTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setStoreNum(ComputeUtil.safeAdd(totalCacheEntity.getStoreNum(), detailCacheEntity.getStoreNum()));
                        totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), detailCacheEntity.getStoreMoney()));
                        totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), detailCacheEntity.getStoreTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutStoreMoney(), detailCacheEntity.getStoreMoney()));
                            totalCacheEntity.setOutStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutStoreTaxMoney(), detailCacheEntity.getStoreTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setOtherNum(ComputeUtil.safeAdd(totalCacheEntity.getOtherNum(), detailCacheEntity.getOtherNum()));
                        totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), detailCacheEntity.getOtherMoney()));
                        totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), detailCacheEntity.getOtherTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutOtherMoney(), detailCacheEntity.getOtherMoney()));
                            totalCacheEntity.setOutOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutOtherTaxMoney(), detailCacheEntity.getOtherTaxMoney()));
                        }
                    }
                }
            }
        }
    }

    private Set<Long> cacheDetails(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks ){
        List<DetailCacheEntity> insertList = new ArrayList<>();
        LambdaQueryWrapper<DutyDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyDetailEntity::getDutyId, dutyEntity.getId());
        queryWrapper.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List<DutyDetailEntity> detailEntities = dutyDetailService.list(queryWrapper);

        List<Long> parentIdList = new ArrayList<>();
        List<Long> detailIdList = new ArrayList<>();
        for (DutyDetailEntity detailEntity : detailEntities) {
            if(detailEntity.getSelfRelatedFlag() && null == detailEntity.getCategoryId()){
                parentIdList.add(detailEntity.getFeeDetailId());
            }
            detailIdList.add(detailEntity.getId());
        }

        Map<Long, List<FeeDetailEntity>> ctyMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(parentIdList)){
            LambdaQueryWrapper<FeeDetailEntity> query = new LambdaQueryWrapper<>();
            query.in(FeeDetailEntity::getParentId, parentIdList);
            List<FeeDetailEntity> feeDetailEntities = feeDetailService.list(query);
            for (FeeDetailEntity detailEntity : feeDetailEntities) {
                List<FeeDetailEntity> list = ctyMap.containsKey(detailEntity.getParentId()) ? ctyMap.get(detailEntity.getParentId()) : new ArrayList<>();
                list.add(detailEntity);
                ctyMap.put(detailEntity.getParentId(), list);
            }
        }

        LambdaQueryWrapper<DutyDetailItemEntity> itemQuery = new LambdaQueryWrapper<>();
        itemQuery.in(DutyDetailItemEntity::getDutyDetailId, detailIdList);
        List<DutyDetailItemEntity> itemAllEntityList = dutyDetailItemService.list(itemQuery);
        Map<Long, List<DutyDetailItemEntity>> itemAllMap = new HashMap<>();
        for (DutyDetailItemEntity itemEntity : itemAllEntityList) {
            List<DutyDetailItemEntity> list = itemAllMap.containsKey(itemEntity.getDutyDetailId()) ? itemAllMap.get(itemEntity.getDutyDetailId()) : new ArrayList<>();
            list.add(itemEntity);
            itemAllMap.put(itemEntity.getDutyDetailId(), list);
        }

        LambdaQueryWrapper<DetailCacheEntity> detailQuery = new LambdaQueryWrapper<>();
        detailQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        List<DetailCacheEntity> detailCacheAllEntities = detailCacheService.list(detailQuery);
        Map<Long, List<DetailCacheEntity>> itemcacheAllMap = new HashMap<>();
        for (DetailCacheEntity cacheEntity : detailCacheAllEntities) {
            List<DetailCacheEntity> list = itemcacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? itemcacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<>();
            list.add(cacheEntity);
            itemcacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity detailEntity : detailEntities) {
            List<Long> categoryList = new ArrayList<>();
            if(detailEntity.getSelfRelatedFlag() && null == detailEntity.getCategoryId() && ctyMap.containsKey(detailEntity.getFeeDetailId())){
                List<FeeDetailEntity> list =  ctyMap.get(detailEntity.getFeeDetailId());
                categoryList = list.stream().map(FeeDetailEntity::getCategoryId).collect(Collectors.toList());
            }
            List<DutyDetailItemEntity> itemEntityList = itemAllMap.get(detailEntity.getId());
            Map<Long, DutyDetailItemEntity> itemMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(itemEntityList)){
                itemMap = itemEntityList.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }

            List<DetailCacheEntity> detailCacheEntities = itemcacheAllMap.get(detailEntity.getId());
            Map<Long, DetailCacheEntity> itemcacheMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(detailCacheEntities)){
                itemcacheMap = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }

            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                Long docId = detailExecutionVO.getDocId();
                if(!check(detailEntity, detailExecutionVO, categoryList)){
                    continue;
                }
                DetailCacheEntity cacheEntity = null;
                if(itemcacheMap.containsKey(docId)){
                    cacheEntity = itemcacheMap.get(docId);
                }else{
                    if(itemMap.containsKey(docId)){
                        DutyDetailItemEntity itemEntity = itemMap.get(docId);
                        cacheEntity = BeanMapper.map(itemEntity, DetailCacheEntity.class);
                        cacheEntity.setDutyItemId(itemEntity.getId());
                        cacheEntity.setSpec(itemEntity.getModel());
                    }else{
                        cacheEntity = BeanMapper.map(detailExecutionVO, DetailCacheEntity.class);
                        if(detailExecutionVO.getCategoryFlag()){
                            cacheEntity.setCode(detailExecutionVO.getCategoryCode());
                            cacheEntity.setName(detailExecutionVO.getCategoryName());
                        }
                        cacheEntity.setPrice(null);
                        cacheEntity.setTaxPrice(null);
                        cacheEntity.setModel(detailExecutionVO.getSpec());
                        cacheEntity.setDutyDetailId(detailEntity.getId());
                        cacheEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                        cacheEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                        cacheEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    }
                    cacheEntity.setProjectId(dutyEntity.getProjectId());
                }
                cacheEntity.setBillCategory(executionVO.getTotalVO().getBillCategory());
                setDetailValue(cacheEntity, detailExecutionVO, executionVO.getTotalVO());
                insertList.add(cacheEntity);
            }
        }

        Set<Long> keySet = new HashSet<>();
        if(CollectionUtils.isNotEmpty(insertList)){
            detailCacheService.saveOrUpdateBatch(insertList);
            for(DetailCacheEntity cacheEntity : insertList){
                if(null == cacheEntity.getDutyItemId()){
                    BigDecimal planTotal = ComputeUtil.safeAdd(cacheEntity.getPlanNum(), cacheEntity.getPlanMoney(), cacheEntity.getPlanTaxMoney());
                    BigDecimal contTotal = ComputeUtil.safeAdd(cacheEntity.getContNum(), cacheEntity.getContMoney(), cacheEntity.getContTaxMoney());
                    BigDecimal storeTotal = ComputeUtil.safeAdd(cacheEntity.getStoreNum(), cacheEntity.getStoreMoney(), cacheEntity.getStoreTaxMoney());
                    BigDecimal otherTotal = ComputeUtil.safeAdd(cacheEntity.getOtherNum(), cacheEntity.getOtherMoney(), cacheEntity.getOtherTaxMoney());
                    BigDecimal total = ComputeUtil.safeAdd(planTotal, contTotal, storeTotal, otherTotal);
                    if (null == total || 0 == total.intValue()) {
                        keySet.add(cacheEntity.getId());
                    }
                }
            }
        }
        return keySet;
    }

    private boolean check(DutyDetailEntity detailEntity, DetailExecutionVO detailExecutionVO, List<Long> categoryList){
        if(null == detailEntity.getCategoryId()  && !DocTypeEnum.成本科目.getCode().equals(detailExecutionVO.getDocType())){
            boolean flag = false;
            if(CollectionUtils.isNotEmpty(categoryList)) {
                for (Long category : categoryList) {
                    if (null !=  detailExecutionVO.getCategoryInnerCode() && detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(category))) {
                        flag = true;
                    }
                }
            }
            return flag;
        }else if(!detailEntity.getLeafFlag()){
            return  false;
        }else if(detailEntity.getDocType().compareTo(detailExecutionVO.getDocType()) != 0){
            return  false;
        }else if(null == detailExecutionVO.getCategoryInnerCode() || !detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(detailEntity.getCategoryId()))){
            return  false;
        }
        return  true;
    }

    private void cacheTotal(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks ){
        List<TotalCacheEntity> insertList = new ArrayList<>();
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        LambdaQueryWrapper<DutyDetailEntity> totalQuery = new LambdaQueryWrapper<>();
        totalQuery.eq(DutyDetailEntity::getDutyId, dutyEntity.getId());
        totalQuery.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List<DutyDetailEntity> dutyDetailEntities = dutyDetailService.list(totalQuery);

        List<Long> detailIdList = new ArrayList<>();
        for (DutyDetailEntity detailEntity : dutyDetailEntities) {
            detailIdList.add(detailEntity.getId());
        }
        LambdaQueryWrapper<TotalCacheEntity> query = new LambdaQueryWrapper<>();
        query.in(TotalCacheEntity::getDutyDetailId, detailIdList);
        List<TotalCacheEntity> totalCacheAllEntities = totalCacheService.list(query);
        Map<Long, List<TotalCacheEntity>> totalMap = new HashMap<>();
        for (TotalCacheEntity cacheEntity : totalCacheAllEntities) {
            List<TotalCacheEntity> list = totalMap.containsKey(cacheEntity.getDutyDetailId()) ? totalMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<>();
            list.add(cacheEntity);
            totalMap.put(cacheEntity.getDutyDetailId(), list);
        }

        LambdaQueryWrapper<DetailCacheEntity> itemQuery = new LambdaQueryWrapper<>();
        itemQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        itemQuery.eq(DetailCacheEntity::getBillCategory, totalExecutionVO.getBillCategory());
        List<DetailCacheEntity> itemEntityAllListdb = detailCacheService.list(itemQuery);
        Map<Long, List<DetailCacheEntity>> cacheAllMap = new HashMap<>();
        for (DetailCacheEntity cacheEntity : itemEntityAllListdb) {
            List<DetailCacheEntity> list = cacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? cacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<>();
            list.add(cacheEntity);
            cacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for(DutyDetailEntity dutyDetailEntity : dutyDetailEntities){
            List<TotalCacheEntity> totalCacheEntities = totalMap.get(dutyDetailEntity.getId());
            TotalCacheEntity totalCacheEntity = CollectionUtils.isNotEmpty(totalCacheEntities) ? totalCacheEntities.get(0) : BeanMapper.map(dutyDetailEntity, TotalCacheEntity.class );
            totalCacheEntity.setDutyDetailId(dutyDetailEntity.getId());

            List<DetailCacheEntity> itemEntityList = cacheAllMap.get(dutyDetailEntity.getId());
            setValue(totalCacheEntity, itemEntityList, totalExecutionVO);
            insertList.add(totalCacheEntity);
        }

        List<Map> resultMapList = BeanMapper.mapList(insertList, Map.class);
        List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);

        gatherMnyAndNum(null, treeData);

        List<TotalCacheEntity> entities = new ArrayList<>();
        treeToList(treeData, entities);


        for (TotalCacheEntity entity : entities) {
            if (BooleanUtils.isTrue(entity.getSelfScopeFlag()) && BooleanUtils.isFalse(entity.getLeafFlag()) && (null == entity.getAllCostFlag() || BooleanUtils.isFalse(entity.getAllCostFlag()))) {
                setValue(entity, totalExecutionVO);
            }
        }

        if(CollectionUtils.isNotEmpty(entities)){
            totalCacheService.saveOrUpdateBatch(entities);
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<TotalCacheEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, TotalCacheEntity.class));
        }
    }

    /**
     * 汇总金额和数量
     */
    private void gatherMnyAndNum(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;

        BigDecimal planMoney = null;
        BigDecimal planTaxMoney = null;
        BigDecimal outPlanMoney = null;
        BigDecimal outPlanTaxMoney = null;

        BigDecimal contMoney = null;
        BigDecimal contTaxMoney = null;
        BigDecimal outContMoney = null;
        BigDecimal outContTaxMoney = null;

        BigDecimal storeMoney = null;
        BigDecimal storeTaxMoney = null;
        BigDecimal outStoreMoney = null;
        BigDecimal outStoreTaxMoney = null;

        BigDecimal otherMoney = null;
        BigDecimal otherTaxMoney = null;
        BigDecimal outOtherMoney = null;
        BigDecimal outOtherTaxMoney = null;

        Boolean allCostFlag = false;

        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                gatherMnyAndNum(ypd, (List) ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, getBigDecimalValue(ypd, "taxMny"));

            planMoney = ComputeUtil.safeAdd(planMoney, getBigDecimalValue(ypd, "planMoney"));
            planTaxMoney = ComputeUtil.safeAdd(planTaxMoney, getBigDecimalValue(ypd, "planTaxMoney"));
            outPlanMoney = ComputeUtil.safeAdd(outPlanMoney, getBigDecimalValue(ypd, "outPlanMoney"));
            outPlanTaxMoney = ComputeUtil.safeAdd(outPlanTaxMoney, getBigDecimalValue(ypd, "outPlanTaxMoney"));

            contMoney = ComputeUtil.safeAdd(contMoney, getBigDecimalValue(ypd, "contMoney"));
            contTaxMoney = ComputeUtil.safeAdd(contTaxMoney, getBigDecimalValue(ypd, "contTaxMoney"));
            outContMoney = ComputeUtil.safeAdd(outContMoney, getBigDecimalValue(ypd, "outContMoney"));
            outContTaxMoney = ComputeUtil.safeAdd(outContTaxMoney, getBigDecimalValue(ypd, "outContTaxMoney"));

            storeMoney = ComputeUtil.safeAdd(storeMoney, getBigDecimalValue(ypd, "storeMoney"));
            storeTaxMoney = ComputeUtil.safeAdd(storeTaxMoney, getBigDecimalValue(ypd, "storeTaxMoney"));
            outStoreMoney = ComputeUtil.safeAdd(outStoreMoney, getBigDecimalValue(ypd, "outStoreMoney"));
            outStoreTaxMoney = ComputeUtil.safeAdd(outStoreTaxMoney, getBigDecimalValue(ypd, "outStoreTaxMoney"));

            otherMoney = ComputeUtil.safeAdd(otherMoney, getBigDecimalValue(ypd, "otherMoney"));
            otherTaxMoney = ComputeUtil.safeAdd(otherTaxMoney, getBigDecimalValue(ypd, "otherTaxMoney"));
            outOtherMoney = ComputeUtil.safeAdd(outOtherMoney, getBigDecimalValue(ypd, "outOtherMoney"));
            outOtherTaxMoney = ComputeUtil.safeAdd(outOtherTaxMoney, getBigDecimalValue(ypd, "outOtherTaxMoney"));

            if (DocTypeEnum.成本科目.getCode().equals(ypd.get("docType"))) {
                allCostFlag = true;
            }
        }
        if(now != null){
            now.put("allCostFlag", allCostFlag);

            now.put("outPlanMoney", outPlanMoney);
            now.put("outPlanTaxMoney", outPlanTaxMoney);
            now.put("outContMoney", outContMoney);
            now.put("outContTaxMoney", outContTaxMoney);
            now.put("outStoreMoney", outStoreMoney);
            now.put("outStoreTaxMoney", outStoreTaxMoney);
            now.put("outOtherMoney", outOtherMoney);
            now.put("outOtherTaxMoney", outOtherTaxMoney);

            if (!(Boolean) now.get("selfScopeFlag") || (!(Boolean) now.get("leafFlag") && allCostFlag)) {
                now.put("planMoney", planMoney);
                now.put("planTaxMoney", planTaxMoney);

                now.put("contMoney", contMoney);
                now.put("contTaxMoney", contTaxMoney);

                now.put("storeMoney", storeMoney);
                now.put("storeTaxMoney", storeTaxMoney);

                now.put("otherMoney", otherMoney);
                now.put("otherTaxMoney", otherTaxMoney);
            }
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code){
        return ypd.get(code) == null ? null : (BigDecimal) ypd.get(code);
    }

    private void setDetailValue(DetailCacheEntity detailCacheEntity, DetailExecutionVO detailExecutionVO, TotalExecutionVO totalVO) {
        if (BillCategoryEnum.计划.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setPlanMoney(ComputeUtil.safeAdd(detailCacheEntity.getPlanMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setPlanNum(ComputeUtil.safeAdd(detailCacheEntity.getPlanNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getPlanTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.合同.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setContMoney(ComputeUtil.safeAdd(detailCacheEntity.getContMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setContNum(ComputeUtil.safeAdd(detailCacheEntity.getContNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getContTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.入库.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setStoreMoney(ComputeUtil.safeAdd(detailCacheEntity.getStoreMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setStoreNum(ComputeUtil.safeAdd(detailCacheEntity.getStoreNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getStoreTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.其他.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setOtherMoney(ComputeUtil.safeAdd(detailCacheEntity.getOtherMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setOtherNum(ComputeUtil.safeAdd(detailCacheEntity.getOtherNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getOtherTaxMoney(), detailExecutionVO.getTaxMoney()));
        }
    }
}
