/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;

public class PushCalcExecCallable
implements Callable<CommonResponse<String>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TC_LOCK = "TC_LOCK::";
    private RequestAttributes context;
    private String authority;
    private ExecutionVO executionVO;
    private RedissonClient redissonClient;
    private ITotalCacheService totalCacheService;
    private IDetailCacheService detailCacheService;
    private IDutyService dutyService;
    private IDutyDetailService dutyDetailService;
    private IDutyDetailItemService dutyDetailItemService;
    private IFeeDetailService feeDetailService;
    private IFeeDetailScopeService feeDetailScopeService;

    public PushCalcExecCallable(RequestAttributes context, String authority, ExecutionVO executionVO, RedissonClient redissonClient, ITotalCacheService totalCacheService, IDetailCacheService detailCacheService, IDutyService dutyService, IDutyDetailService dutyDetailService, IDutyDetailItemService dutyDetailItemService, IFeeDetailService feeDetailService, IFeeDetailScopeService feeDetailScopeService) {
        this.context = context;
        this.authority = authority;
        this.executionVO = executionVO;
        this.redissonClient = redissonClient;
        this.totalCacheService = totalCacheService;
        this.detailCacheService = detailCacheService;
        this.dutyService = dutyService;
        this.dutyDetailService = dutyDetailService;
        this.dutyDetailItemService = dutyDetailItemService;
        this.feeDetailService = feeDetailService;
        this.feeDetailScopeService = feeDetailScopeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<String> call() throws Exception {
        TotalExecutionVO totalExecutionVO = this.executionVO.getTotalVO();
        String lockKey = TC_LOCK + totalExecutionVO.getProjectId();
        RLock mylock = this.redissonClient.getLock(lockKey);
        try {
            boolean lock = mylock.tryLock(20L, TimeUnit.SECONDS);
            if (!lock) {
                CommonResponse commonResponse = CommonResponse.error((String)("\u83b7\u53d6\u9501\u5931\u8d25\uff1a" + totalExecutionVO.getProjectId()));
                return commonResponse;
            }
            LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
            feeQuery.eq(DutyEntity::getProjectId, (Object)totalExecutionVO.getProjectId());
            feeQuery.eq(DutyEntity::getEnableState, (Object)true);
            feeQuery.eq(DutyEntity::getGatherFlag, (Object)true);
            List dutyEntities = this.dutyService.list((Wrapper)feeQuery);
            if (CollectionUtils.isEmpty((Collection)dutyEntities)) {
                mylock.unlock();
                CommonResponse commonResponse = CommonResponse.success((String)"\u8be5\u9879\u76ee\u6ca1\u6709\u751f\u6548\u7684\u76ee\u6807\u6210\u672c");
                return commonResponse;
            }
            List<Long> feeDetailPks = this.queryFeeDetailPks(((DutyEntity)((Object)dutyEntities.get(0))).getFeeId(), totalExecutionVO);
            if (CollectionUtils.isEmpty(feeDetailPks)) {
                mylock.unlock();
                CommonResponse commonResponse = CommonResponse.success((String)"\u8be5\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u660e\u7ec6");
                return commonResponse;
            }
            Set<Long> keySet = null;
            if (CollectionUtils.isNotEmpty((Collection)this.executionVO.getDetailList())) {
                keySet = this.cacheDetails((DutyEntity)((Object)dutyEntities.get(0)), this.executionVO, feeDetailPks);
            }
            this.cacheTotal((DutyEntity)((Object)dutyEntities.get(0)), this.executionVO, feeDetailPks);
            if (CollectionUtils.isNotEmpty(keySet)) {
                this.detailCacheService.deleteByIdsPhy(new ArrayList<Long>(keySet));
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u6c47\u603b\u7f13\u5b58\u5931\u8d25:" + JSONObject.toJSONString((Object)e));
        }
        finally {
            mylock.unlock();
        }
        return CommonResponse.success((String)"\u5355\u4e2a\u63a8\u9001\u8ba1\u7b97\u7f13\u5b58\u8868\u6210\u529f");
    }

    private List<Long> queryFeeDetailPks(Long feeId, TotalExecutionVO totalExecutionVO) {
        LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeId, (Object)feeId);
        scopeQuery.eq(FeeDetailScopeEntity::getBillCode, (Object)totalExecutionVO.getBussinessType());
        scopeQuery.eq(FeeDetailScopeEntity::getPropertyValue, (Object)totalExecutionVO.getProperty());
        List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
        if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
            return scopeEntities.stream().map(FeeDetailScopeEntity::getFeeDetailId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private void setValue(TotalCacheEntity totalCacheEntity, TotalExecutionVO totalExecutionVO) {
        if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setPlanNum(null);
            totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanMoney(), (BigDecimal)totalExecutionVO.getMoney()));
            totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setContNum(null);
            totalCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContMoney(), (BigDecimal)totalExecutionVO.getMoney()));
            totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setStoreNum(null);
            totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreMoney(), (BigDecimal)totalExecutionVO.getMoney()));
            totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setOtherNum(null);
            totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherMoney(), (BigDecimal)totalExecutionVO.getMoney()));
            totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
        }
    }

    private void setValue(TotalCacheEntity totalCacheEntity, List<DetailCacheEntity> itemEntityList, TotalExecutionVO totalExecutionVO) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (!totalCacheEntity.getLeafFlag().booleanValue() || !BooleanUtils.isTrue((Boolean)totalCacheEntity.getSelfScopeFlag()) || DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(totalCacheEntity.getDocType())) break block13;
                            if (!BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) break block14;
                            totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanMoney(), (BigDecimal)totalExecutionVO.getMoney()));
                            totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
                            break block15;
                        }
                        if (!BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) break block16;
                        totalCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContMoney(), (BigDecimal)totalExecutionVO.getMoney()));
                        totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
                        break block15;
                    }
                    if (!BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) break block17;
                    totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreMoney(), (BigDecimal)totalExecutionVO.getMoney()));
                    totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
                    break block15;
                }
                if (!BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) break block15;
                totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherMoney(), (BigDecimal)totalExecutionVO.getMoney()));
                totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (BigDecimal)totalExecutionVO.getTaxMoney()));
                break block15;
            }
            if (totalCacheEntity.getLeafFlag().booleanValue()) {
                if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setPlanMoney(null);
                    totalCacheEntity.setPlanNum(null);
                    totalCacheEntity.setPlanTaxMoney(null);
                    totalCacheEntity.setOutPlanMoney(null);
                    totalCacheEntity.setOutPlanTaxMoney(null);
                } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setContMoney(null);
                    totalCacheEntity.setContNum(null);
                    totalCacheEntity.setContTaxMoney(null);
                    totalCacheEntity.setOutContMoney(null);
                    totalCacheEntity.setOutContTaxMoney(null);
                } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setStoreMoney(null);
                    totalCacheEntity.setStoreNum(null);
                    totalCacheEntity.setStoreTaxMoney(null);
                    totalCacheEntity.setOutStoreMoney(null);
                    totalCacheEntity.setOutStoreTaxMoney(null);
                } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setOtherMoney(null);
                    totalCacheEntity.setOtherNum(null);
                    totalCacheEntity.setOtherTaxMoney(null);
                    totalCacheEntity.setOutOtherMoney(null);
                    totalCacheEntity.setOutOtherTaxMoney(null);
                }
            }
            if (CollectionUtils.isNotEmpty(itemEntityList)) {
                for (DetailCacheEntity detailCacheEntity : itemEntityList) {
                    if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setPlanNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanNum(), (BigDecimal)detailCacheEntity.getPlanNum()));
                        totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanMoney(), (BigDecimal)detailCacheEntity.getPlanMoney()));
                        totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getPlanTaxMoney(), (BigDecimal)detailCacheEntity.getPlanTaxMoney()));
                        if (null != detailCacheEntity.getDutyItemId()) continue;
                        totalCacheEntity.setOutPlanMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutPlanMoney(), (BigDecimal)detailCacheEntity.getPlanMoney()));
                        totalCacheEntity.setOutPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutPlanTaxMoney(), (BigDecimal)detailCacheEntity.getPlanTaxMoney()));
                        continue;
                    }
                    if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setContNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContNum(), (BigDecimal)detailCacheEntity.getContNum()));
                        totalCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContMoney(), (BigDecimal)detailCacheEntity.getContMoney()));
                        totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getContTaxMoney(), (BigDecimal)detailCacheEntity.getContTaxMoney()));
                        if (null != detailCacheEntity.getDutyItemId()) continue;
                        totalCacheEntity.setOutContMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutContMoney(), (BigDecimal)detailCacheEntity.getContMoney()));
                        totalCacheEntity.setOutContTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutContTaxMoney(), (BigDecimal)detailCacheEntity.getContTaxMoney()));
                        continue;
                    }
                    if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setStoreNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreNum(), (BigDecimal)detailCacheEntity.getStoreNum()));
                        totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreMoney(), (BigDecimal)detailCacheEntity.getStoreMoney()));
                        totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getStoreTaxMoney(), (BigDecimal)detailCacheEntity.getStoreTaxMoney()));
                        if (null != detailCacheEntity.getDutyItemId()) continue;
                        totalCacheEntity.setOutStoreMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutStoreMoney(), (BigDecimal)detailCacheEntity.getStoreMoney()));
                        totalCacheEntity.setOutStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutStoreTaxMoney(), (BigDecimal)detailCacheEntity.getStoreTaxMoney()));
                        continue;
                    }
                    if (!BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalExecutionVO.getBillCategory())) continue;
                    totalCacheEntity.setOtherNum(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherNum(), (BigDecimal)detailCacheEntity.getOtherNum()));
                    totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherMoney(), (BigDecimal)detailCacheEntity.getOtherMoney()));
                    totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOtherTaxMoney(), (BigDecimal)detailCacheEntity.getOtherTaxMoney()));
                    if (null != detailCacheEntity.getDutyItemId()) continue;
                    totalCacheEntity.setOutOtherMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutOtherMoney(), (BigDecimal)detailCacheEntity.getOtherMoney()));
                    totalCacheEntity.setOutOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)totalCacheEntity.getOutOtherTaxMoney(), (BigDecimal)detailCacheEntity.getOtherTaxMoney()));
                }
            }
        }
    }

    private Set<Long> cacheDetails(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks) {
        ArrayList<DetailCacheEntity> insertList = new ArrayList<DetailCacheEntity>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        queryWrapper.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List detailEntities = this.dutyDetailService.list((Wrapper)queryWrapper);
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        for (DutyDetailEntity detailEntity : detailEntities) {
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId()) {
                parentIdList.add(detailEntity.getFeeDetailId());
            }
            detailIdList.add(detailEntity.getId());
        }
        HashMap ctyMap = new HashMap();
        if (CollectionUtils.isNotEmpty(parentIdList)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(FeeDetailEntity::getParentId, parentIdList);
            List feeDetailEntities = this.feeDetailService.list((Wrapper)query);
            for (Object detailEntity : feeDetailEntities) {
                ArrayList<Object> list = ctyMap.containsKey(((FeeDetailEntity)((Object)detailEntity)).getParentId()) ? (List)ctyMap.get(((FeeDetailEntity)((Object)detailEntity)).getParentId()) : new ArrayList<Object>();
                list.add(detailEntity);
                ctyMap.put(((FeeDetailEntity)((Object)detailEntity)).getParentId(), list);
            }
        }
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.in(DutyDetailItemEntity::getDutyDetailId, detailIdList);
        List itemAllEntityList = this.dutyDetailItemService.list((Wrapper)itemQuery);
        HashMap itemAllMap = new HashMap();
        for (DutyDetailItemEntity itemEntity : itemAllEntityList) {
            ArrayList<DutyDetailItemEntity> list = itemAllMap.containsKey(itemEntity.getDutyDetailId()) ? (List)itemAllMap.get(itemEntity.getDutyDetailId()) : new ArrayList<DutyDetailItemEntity>();
            list.add(itemEntity);
            itemAllMap.put(itemEntity.getDutyDetailId(), list);
        }
        LambdaQueryWrapper detailQuery = new LambdaQueryWrapper();
        detailQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        List detailCacheAllEntities = this.detailCacheService.list((Wrapper)detailQuery);
        HashMap itemcacheAllMap = new HashMap();
        for (DetailCacheEntity cacheEntity : detailCacheAllEntities) {
            ArrayList<DetailCacheEntity> list = itemcacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)itemcacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<DetailCacheEntity>();
            list.add(cacheEntity);
            itemcacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity detailEntity : detailEntities) {
            ArrayList<Long> categoryList = new ArrayList();
            if (detailEntity.getSelfRelatedFlag().booleanValue() && null == detailEntity.getCategoryId() && ctyMap.containsKey(detailEntity.getFeeDetailId())) {
                List list = (List)ctyMap.get(detailEntity.getFeeDetailId());
                categoryList = list.stream().map(FeeDetailEntity::getCategoryId).collect(Collectors.toList());
            }
            List itemEntityList = (List)itemAllMap.get(detailEntity.getId());
            Map<Object, Object> itemMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemEntityList)) {
                itemMap = itemEntityList.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }
            List detailCacheEntities = (List)itemcacheAllMap.get(detailEntity.getId());
            Map<Object, Object> itemcacheMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)detailCacheEntities)) {
                itemcacheMap = detailCacheEntities.stream().collect(Collectors.toMap(DetailCacheEntity::getDocId, Function.identity(), (key1, key2) -> key1));
            }
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                Long docId = detailExecutionVO.getDocId();
                if (!this.check(detailEntity, detailExecutionVO, categoryList)) continue;
                DetailCacheEntity cacheEntity = null;
                if (itemcacheMap.containsKey(docId)) {
                    cacheEntity = (DetailCacheEntity)((Object)itemcacheMap.get(docId));
                } else {
                    if (itemMap.containsKey(docId)) {
                        DutyDetailItemEntity itemEntity = (DutyDetailItemEntity)((Object)itemMap.get(docId));
                        cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)((Object)itemEntity), DetailCacheEntity.class));
                        cacheEntity.setDutyItemId(itemEntity.getId());
                        cacheEntity.setSpec(itemEntity.getModel());
                    } else {
                        cacheEntity = (DetailCacheEntity)((Object)BeanMapper.map((Object)detailExecutionVO, DetailCacheEntity.class));
                        if (detailExecutionVO.getCategoryFlag().booleanValue()) {
                            cacheEntity.setCode(detailExecutionVO.getCategoryCode());
                            cacheEntity.setName(detailExecutionVO.getCategoryName());
                        }
                        cacheEntity.setPrice(null);
                        cacheEntity.setTaxPrice(null);
                        cacheEntity.setModel(detailExecutionVO.getSpec());
                        cacheEntity.setDutyDetailId(detailEntity.getId());
                        cacheEntity.setFeeDetailId(detailEntity.getFeeDetailId());
                        cacheEntity.setFeeDetailCode(detailEntity.getFeeDetailCode());
                        cacheEntity.setFeeDetailName(detailEntity.getFeeDetailName());
                    }
                    cacheEntity.setProjectId(dutyEntity.getProjectId());
                }
                cacheEntity.setBillCategory(executionVO.getTotalVO().getBillCategory());
                this.setDetailValue(cacheEntity, detailExecutionVO, executionVO.getTotalVO());
                insertList.add(cacheEntity);
            }
        }
        HashSet<Long> keySet = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.detailCacheService.saveOrUpdateBatch(insertList);
            for (DetailCacheEntity cacheEntity : insertList) {
                BigDecimal otherTotal;
                BigDecimal storeTotal;
                BigDecimal contTotal;
                BigDecimal planTotal;
                BigDecimal total;
                if (null != cacheEntity.getDutyItemId() || null != (total = ComputeUtil.safeAdd((BigDecimal)(planTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getPlanNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getPlanMoney(), cacheEntity.getPlanTaxMoney()})), (BigDecimal[])new BigDecimal[]{contTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getContNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getContMoney(), cacheEntity.getContTaxMoney()}), storeTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getStoreNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getStoreMoney(), cacheEntity.getStoreTaxMoney()}), otherTotal = ComputeUtil.safeAdd((BigDecimal)cacheEntity.getOtherNum(), (BigDecimal[])new BigDecimal[]{cacheEntity.getOtherMoney(), cacheEntity.getOtherTaxMoney()})})) && 0 != total.intValue()) continue;
                keySet.add(cacheEntity.getId());
            }
        }
        return keySet;
    }

    private boolean check(DutyDetailEntity detailEntity, DetailExecutionVO detailExecutionVO, List<Long> categoryList) {
        if (null == detailEntity.getCategoryId() && !DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(detailExecutionVO.getDocType())) {
            boolean flag = false;
            if (CollectionUtils.isNotEmpty(categoryList)) {
                for (Long category : categoryList) {
                    if (null == detailExecutionVO.getCategoryInnerCode() || !detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(category))) continue;
                    flag = true;
                }
            }
            return flag;
        }
        if (!detailEntity.getLeafFlag().booleanValue()) {
            return false;
        }
        if (detailEntity.getDocType().compareTo(detailExecutionVO.getDocType()) != 0) {
            return false;
        }
        return null != detailExecutionVO.getCategoryInnerCode() && detailExecutionVO.getCategoryInnerCode().contains(String.valueOf(detailEntity.getCategoryId()));
    }

    private void cacheTotal(DutyEntity dutyEntity, ExecutionVO executionVO, List<Long> feeDetailPks) {
        ArrayList<TotalCacheEntity> insertList = new ArrayList<TotalCacheEntity>();
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        LambdaQueryWrapper totalQuery = new LambdaQueryWrapper();
        totalQuery.eq(DutyDetailEntity::getDutyId, (Object)dutyEntity.getId());
        totalQuery.in(DutyDetailEntity::getFeeDetailId, feeDetailPks);
        List dutyDetailEntities = this.dutyDetailService.list((Wrapper)totalQuery);
        ArrayList<Long> detailIdList = new ArrayList<Long>();
        for (DutyDetailEntity detailEntity : dutyDetailEntities) {
            detailIdList.add(detailEntity.getId());
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(TotalCacheEntity::getDutyDetailId, detailIdList);
        List totalCacheAllEntities = this.totalCacheService.list((Wrapper)query);
        HashMap totalMap = new HashMap();
        for (TotalCacheEntity cacheEntity : totalCacheAllEntities) {
            ArrayList<TotalCacheEntity> list = totalMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)totalMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<TotalCacheEntity>();
            list.add(cacheEntity);
            totalMap.put(cacheEntity.getDutyDetailId(), list);
        }
        LambdaQueryWrapper itemQuery = new LambdaQueryWrapper();
        itemQuery.in(DetailCacheEntity::getDutyDetailId, detailIdList);
        itemQuery.eq(DetailCacheEntity::getBillCategory, (Object)totalExecutionVO.getBillCategory());
        List itemEntityAllListdb = this.detailCacheService.list((Wrapper)itemQuery);
        HashMap cacheAllMap = new HashMap();
        for (DetailCacheEntity cacheEntity : itemEntityAllListdb) {
            ArrayList<DetailCacheEntity> list = cacheAllMap.containsKey(cacheEntity.getDutyDetailId()) ? (List)cacheAllMap.get(cacheEntity.getDutyDetailId()) : new ArrayList<DetailCacheEntity>();
            list.add(cacheEntity);
            cacheAllMap.put(cacheEntity.getDutyDetailId(), list);
        }
        for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities) {
            List totalCacheEntities = (List)totalMap.get(dutyDetailEntity.getId());
            TotalCacheEntity totalCacheEntity = CollectionUtils.isNotEmpty((Collection)totalCacheEntities) ? (TotalCacheEntity)((Object)totalCacheEntities.get(0)) : (TotalCacheEntity)((Object)BeanMapper.map((Object)dutyDetailEntity, TotalCacheEntity.class));
            totalCacheEntity.setDutyDetailId(dutyDetailEntity.getId());
            List itemEntityList = (List)cacheAllMap.get(dutyDetailEntity.getId());
            this.setValue(totalCacheEntity, itemEntityList, totalExecutionVO);
            insertList.add(totalCacheEntity);
        }
        List resultMapList = BeanMapper.mapList(insertList, Map.class);
        List<Map<String, Object>> treeData = TreeNodeBUtil.createTreeData(resultMapList);
        this.gatherMnyAndNum(null, treeData);
        ArrayList<TotalCacheEntity> entities = new ArrayList<TotalCacheEntity>();
        this.treeToList(treeData, entities);
        for (TotalCacheEntity entity : entities) {
            if (!BooleanUtils.isTrue((Boolean)entity.getSelfScopeFlag()) || !BooleanUtils.isFalse((Boolean)entity.getLeafFlag()) || null != entity.getAllCostFlag() && !BooleanUtils.isFalse((Boolean)entity.getAllCostFlag())) continue;
            this.setValue(entity, totalExecutionVO);
        }
        if (CollectionUtils.isNotEmpty(entities)) {
            this.totalCacheService.saveOrUpdateBatch(entities);
        }
    }

    private void treeToList(List<Map<String, Object>> treeData, List<TotalCacheEntity> entities) {
        for (Map<String, Object> ypd : treeData) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((TotalCacheEntity)((Object)BeanMapper.map(ypd, TotalCacheEntity.class)));
        }
    }

    private void gatherMnyAndNum(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;
        BigDecimal planMoney = null;
        BigDecimal planTaxMoney = null;
        BigDecimal outPlanMoney = null;
        BigDecimal outPlanTaxMoney = null;
        BigDecimal contMoney = null;
        BigDecimal contTaxMoney = null;
        BigDecimal outContMoney = null;
        BigDecimal outContTaxMoney = null;
        BigDecimal storeMoney = null;
        BigDecimal storeTaxMoney = null;
        BigDecimal outStoreMoney = null;
        BigDecimal outStoreTaxMoney = null;
        BigDecimal otherMoney = null;
        BigDecimal otherTaxMoney = null;
        BigDecimal outOtherMoney = null;
        BigDecimal outOtherTaxMoney = null;
        Boolean allCostFlag = false;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.gatherMnyAndNum(ypd, (List)ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, (BigDecimal)this.getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, (BigDecimal)this.getBigDecimalValue(ypd, "taxMny"));
            planMoney = ComputeUtil.safeAdd(planMoney, (BigDecimal)this.getBigDecimalValue(ypd, "planMoney"));
            planTaxMoney = ComputeUtil.safeAdd(planTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "planTaxMoney"));
            outPlanMoney = ComputeUtil.safeAdd(outPlanMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outPlanMoney"));
            outPlanTaxMoney = ComputeUtil.safeAdd(outPlanTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outPlanTaxMoney"));
            contMoney = ComputeUtil.safeAdd(contMoney, (BigDecimal)this.getBigDecimalValue(ypd, "contMoney"));
            contTaxMoney = ComputeUtil.safeAdd(contTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "contTaxMoney"));
            outContMoney = ComputeUtil.safeAdd(outContMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outContMoney"));
            outContTaxMoney = ComputeUtil.safeAdd(outContTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outContTaxMoney"));
            storeMoney = ComputeUtil.safeAdd(storeMoney, (BigDecimal)this.getBigDecimalValue(ypd, "storeMoney"));
            storeTaxMoney = ComputeUtil.safeAdd(storeTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "storeTaxMoney"));
            outStoreMoney = ComputeUtil.safeAdd(outStoreMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outStoreMoney"));
            outStoreTaxMoney = ComputeUtil.safeAdd(outStoreTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outStoreTaxMoney"));
            otherMoney = ComputeUtil.safeAdd(otherMoney, (BigDecimal)this.getBigDecimalValue(ypd, "otherMoney"));
            otherTaxMoney = ComputeUtil.safeAdd(otherTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "otherTaxMoney"));
            outOtherMoney = ComputeUtil.safeAdd(outOtherMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outOtherMoney"));
            outOtherTaxMoney = ComputeUtil.safeAdd(outOtherTaxMoney, (BigDecimal)this.getBigDecimalValue(ypd, "outOtherTaxMoney"));
            if (!DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode().equals(ypd.get("docType"))) continue;
            allCostFlag = true;
        }
        if (now != null) {
            now.put("allCostFlag", allCostFlag);
            now.put("outPlanMoney", outPlanMoney);
            now.put("outPlanTaxMoney", outPlanTaxMoney);
            now.put("outContMoney", outContMoney);
            now.put("outContTaxMoney", outContTaxMoney);
            now.put("outStoreMoney", outStoreMoney);
            now.put("outStoreTaxMoney", outStoreTaxMoney);
            now.put("outOtherMoney", outOtherMoney);
            now.put("outOtherTaxMoney", outOtherTaxMoney);
            if (!((Boolean)now.get("selfScopeFlag")).booleanValue() || !((Boolean)now.get("leafFlag")).booleanValue() && allCostFlag.booleanValue()) {
                now.put("planMoney", planMoney);
                now.put("planTaxMoney", planTaxMoney);
                now.put("contMoney", contMoney);
                now.put("contTaxMoney", contTaxMoney);
                now.put("storeMoney", storeMoney);
                now.put("storeTaxMoney", storeTaxMoney);
                now.put("otherMoney", otherMoney);
                now.put("otherTaxMoney", otherTaxMoney);
            }
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal)ypd.get(code);
    }

    private void setDetailValue(DetailCacheEntity detailCacheEntity, DetailExecutionVO detailExecutionVO, TotalExecutionVO totalVO) {
        if (BillCategoryEnum.\u8ba1\u5212.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setPlanMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getPlanMoney(), (BigDecimal)detailExecutionVO.getMoney()));
            detailCacheEntity.setPlanNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getPlanNum(), (BigDecimal)detailExecutionVO.getNum()));
            detailCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getPlanTaxMoney(), (BigDecimal)detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.\u5408\u540c.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setContMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getContMoney(), (BigDecimal)detailExecutionVO.getMoney()));
            detailCacheEntity.setContNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getContNum(), (BigDecimal)detailExecutionVO.getNum()));
            detailCacheEntity.setContTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getContTaxMoney(), (BigDecimal)detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.\u5165\u5e93.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setStoreMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getStoreMoney(), (BigDecimal)detailExecutionVO.getMoney()));
            detailCacheEntity.setStoreNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getStoreNum(), (BigDecimal)detailExecutionVO.getNum()));
            detailCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getStoreTaxMoney(), (BigDecimal)detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.\u5176\u4ed6.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setOtherMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getOtherMoney(), (BigDecimal)detailExecutionVO.getMoney()));
            detailCacheEntity.setOtherNum(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getOtherNum(), (BigDecimal)detailExecutionVO.getNum()));
            detailCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd((BigDecimal)detailCacheEntity.getOtherTaxMoney(), (BigDecimal)detailExecutionVO.getTaxMoney()));
        }
    }
}

