package com.ejianc.business.costplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.costplan.bean.TargetCostPlanDetailEntity;
import com.ejianc.business.costplan.service.ITargetCostPlanDetailService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.costplan.mapper.TargetCostPlanMapper;
import com.ejianc.business.costplan.bean.TargetCostPlanEntity;
import com.ejianc.business.costplan.service.ITargetCostPlanService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;

/**
 * 目标成本月计划
 * 
 * @author generator
 * 
 */
@Service("targetCostPlanService")
public class TargetCostPlanServiceImpl extends BaseServiceImpl<TargetCostPlanMapper, TargetCostPlanEntity> implements ITargetCostPlanService{
   @Autowired
   private ITargetCostPlanDetailService detailService;


   @Override
    public String updateFinishStateTargetCost( Long projectId,Long coseCloseId,Integer isFinish ){
        LambdaUpdateWrapper<TargetCostPlanDetailEntity> updateWrapper =new LambdaUpdateWrapper<>();
        updateWrapper.set(TargetCostPlanDetailEntity::getIsFinish, isFinish);
        if (isFinish == 1) {
            //改为结束
            updateWrapper.set(TargetCostPlanDetailEntity::getFinishDate, new Date());
            updateWrapper.set(TargetCostPlanDetailEntity::getCostCloseId, coseCloseId);
        }else {
            //改为未结束
            updateWrapper.set(TargetCostPlanDetailEntity::getFinishDate, null);
            updateWrapper.set(TargetCostPlanDetailEntity::getCostCloseId, null);
        }

        updateWrapper.eq(TargetCostPlanDetailEntity::getProjectId,projectId);
        detailService.update(updateWrapper);
        return "查询详情数据成功！";
    }
}
