package com.ejianc.business.targetcost.controller;

import java.io.Serializable;

import com.ejianc.business.targetcost.vo.RuleControlVO;
import com.ejianc.business.targetcost.vo.RuleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.vo.RuleDetailVO;

/**
 * 控制规则明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("ruleDetail")
public class RuleDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IRuleDetailService ruleDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RuleDetailVO> saveOrUpdate(@RequestBody RuleDetailVO saveOrUpdateVO) {
    	RuleDetailEntity entity = BeanMapper.map(saveOrUpdateVO, RuleDetailEntity.class);
        ruleDetailService.saveOrUpdate(entity, false);
    	RuleDetailVO vo = BeanMapper.map(entity, RuleDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RuleDetailVO> queryDetail(Long id) {
    	RuleDetailEntity entity = ruleDetailService.selectById(id);
    	RuleDetailVO vo = BeanMapper.map(entity, RuleDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @param feeDetailId
     * @Description queryControlByFeeDetailId 根据费用模板明细ID查询控制信息
     */
    @RequestMapping(value = "/queryControlByFeeDetailId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RuleControlVO>> queryControlByFeeDetailId(@RequestParam(value = "ruleId") Long ruleId, @RequestParam(value = "feeDetailId") Long feeDetailId) {
        return CommonResponse.success("查询详情数据成功！", ruleDetailService.queryControlByFeeDetailId(ruleId, feeDetailId));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RuleDetailVO> vos) {
        ruleDetailService.removeByIds(vos.stream().map(RuleDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
