/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.costplan.service.ITargetCostPlanService;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ChangeStateEnum;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.DutyWarnVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="duty")
public class DutyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private ITargetCostPlanService costPlanService;
    @Autowired
    private DutyMapper dutyMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static String PC_URL = "/ejc-targetcost-frontend/#/duty/card?id=";
    static String TEST_AGENTID = "1000038";
    static String TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static String PRO_AGENTID = "1000036";
    static String PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u63d0\u4ea4\u524d\u56de\u8c03====================================== state:" + state);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(DutyDetailItemEntity::getDutyId, (Object)billId);
        List dutyDetailItemEntityList = this.dutyDetailItemService.list((Wrapper)query);
        for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList) {
            if (dutyDetailItemEntity.getTaxRate() == null) {
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u7a0e\u7387\u5fc5\u586b\uff01 ");
            }
            if (null != dutyEntity.getLastDutyId()) {
                if (dutyDetailItemEntity.getAmount() == null) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u6570\u91cf\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getPrice() == null) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011\uff0c\u5355\u4ef7(\u65e0\u7a0e)\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getTaxPrice() == null) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4ef7\u5fc5\u586b\uff01");
                }
            } else {
                if (dutyEntity.getDutyVersion() == 1 && (dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0)) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u6570\u91cf\u5fc5\u586b\u4e14\u4e0d\u80fd\u4e3a\u96f6\uff01");
                }
                if (dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011\uff0c\u5355\u4ef7(\u65e0\u7a0e)\u5fc5\u586b\u4e14\u4e0d\u80fd\u4e3a\u96f6\uff01");
                }
                if (dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4ef7\u5fc5\u586b\u4e14\u4e0d\u80fd\u4e3a\u96f6\uff01");
                }
            }
            if (dutyDetailItemEntity.getUnitName() != null) continue;
            throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4f4d\u5fc5\u586b\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        this.logger.info("state---------------\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03-------------------" + state);
        if (state == 0 && dutyEntity.getLastDutyId() == null && (BooleanUtils.isFalse((Boolean)dutyEntity.getLatestFlag()) || 1 != dutyEntity.getDutyVersion() && BooleanUtils.isFalse((Boolean)dutyEntity.getEnableState()))) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        this.totalExecutionService.reCalc(((DutyEntity)((Object)this.dutyService.selectById(billId))).getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        this.logger.info("======================================\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03====================================== state:" + state);
        if (state == 0) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(DutyDetailItemEntity::getDutyId, (Object)billId);
            List dutyDetailItemEntityList = this.dutyDetailItemService.list((Wrapper)query);
            for (DutyDetailItemEntity dutyDetailItemEntity : dutyDetailItemEntityList) {
                if (dutyDetailItemEntity.getTaxRate() == null) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u7a0e\u7387\u5fc5\u586b\uff01 ");
                }
                if (dutyEntity.getDutyVersion() == 1 && (dutyDetailItemEntity.getAmount() == null || dutyDetailItemEntity.getAmount().compareTo(new BigDecimal(0)) == 0)) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u6570\u91cf\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getPrice() == null || dutyDetailItemEntity.getPrice().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011\uff0c\u5355\u4ef7(\u65e0\u7a0e)\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getTaxPrice() == null || dutyDetailItemEntity.getTaxPrice().compareTo(new BigDecimal(0)) == 0) {
                    throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4ef7\u5fc5\u586b\uff01");
                }
                if (dutyDetailItemEntity.getUnitName() != null) continue;
                throw new BusinessException("\u8bf7\u68c0\u67e5\u53f3\u4fa7\u660e\u7ec6\uff0c\u540d\u79f0\u3010" + dutyDetailItemEntity.getName() + "\u3011,\u5355\u4f4d\u5fc5\u586b\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DutyWarnVO dutyWarnVO;
        this.updateEnableAndWriteBack(billId, true);
        this.dutyService.gatherDuty(billId);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        this.totalExecutionService.reCalc(dutyEntity.getProjectId());
        this.costPlanService.updateFinishStateTargetCost(dutyEntity.getProjectId(), dutyEntity.getId(), 1);
        if (dutyEntity.getFloatRate().compareTo(new BigDecimal(5)) < 0 && (dutyWarnVO = this.dutyMapper.queryProjectById(dutyEntity.getProjectId())) != null) {
            ArrayList<String> strList = new ArrayList<String>();
            if (dutyEntity.getFloatRate().compareTo(new BigDecimal(3)) <= 0) {
                strList.add("1502571539046862850");
            } else {
                strList.add("1502571539046862850");
            }
            if (CollectionUtils.isNotEmpty(strList)) {
                for (String s : strList) {
                    this.sendSys(s, dutyEntity.getFloatRate(), dutyEntity.getProjectName(), dutyEntity.getId());
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("state---------------\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03-------------------" + state);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        if (!dutyEntity.getEnableState().booleanValue() || !dutyEntity.getLatestFlag().booleanValue()) {
            throw new BusinessException("\u975e\u6700\u65b0\u751f\u6548\u7248\u672c\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateEnableAndWriteBack(billId, false);
        this.dutyService.gatherDuty(billId);
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.selectById(billId));
        this.totalExecutionService.reCalc(dutyEntity.getProjectId());
        this.costPlanService.updateFinishStateTargetCost(dutyEntity.getProjectId(), dutyEntity.getId(), 0);
        return CommonResponse.success();
    }

    private void updateEnableAndWriteBack(Long billId, Boolean isPass) {
        DutyEntity dutyEntity = (DutyEntity)((Object)this.dutyService.getById(billId));
        dutyEntity.setEnableState(isPass);
        this.dutyService.saveOrUpdate((Object)dutyEntity);
        if (dutyEntity.getLastDutyId() != null) {
            DutyEntity revise = (DutyEntity)((Object)this.dutyService.getById(dutyEntity.getLastDutyId()));
            revise.setChangeState(isPass != false ? ChangeStateEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setEnableState(isPass == false);
            this.dutyService.saveOrUpdate((Object)revise);
        }
    }

    public boolean sendSys(String receiverId, BigDecimal floatRate, String projectName, Long id) {
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("weixinee");
        channel.add("sys");
        Object[] receivers = new String[]{receiverId};
        parameter.setReceivers((String[])receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("earlywarning");
        parameter.setSubject(projectName + "\u76ee\u6807\u6210\u672c\u5206\u89e3\u5229\u6da6\u7387\u4e3a" + floatRate + "%");
        parameter.setContent("\u5185\u5bb9");
        parameter.setPcUrl(PC_URL + id);
        parameter.setMobileUrl(PC_URL + id);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", (Object)PRO_AGENTID);
        weixineeParams.put("secret", (Object)PRO_SECRET);
        weixineeParams.put("msgtype", (Object)"textcard");
        weixineeParams.put("title", (Object)"\u6d41\u7a0b\u5ba1\u6279\u8d85\u671f\u672a\u5904\u7406\u901a\u77e5");
        weixineeParams.put("description", (Object)(projectName + "\u76ee\u6807\u6210\u672c\u5206\u89e3\u5229\u6da6\u7387\u4e3a" + floatRate + "%"));
        weixineeParams.put("url", (Object)("https://pms.zzyjjt.com/portal/sso/index?&userid=" + receiverId + "&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-targetcost-frontend%2f%23%2fduty%2fcard%3fid%3d" + id));
        weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
        parameter.setWeixineeParams(weixineeParams);
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->,\u63a5\u6536\u4eba:{}", (Object)Arrays.toString(receivers));
            return true;
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
        return false;
    }
}

