/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleReceiverEntity;
import com.ejianc.business.targetcost.enums.FeeTypeEnum;
import com.ejianc.business.targetcost.mapper.RuleDetailMapper;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.vo.RuleControlBillVO;
import com.ejianc.business.targetcost.vo.RuleControlVO;
import com.ejianc.business.targetcost.vo.RuleDetailVO;
import com.ejianc.business.targetcost.vo.RuleReceiverVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ruleDetailService")
public class RuleDetailServiceImpl
extends BaseServiceImpl<RuleDetailMapper, RuleDetailEntity>
implements IRuleDetailService {
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IRuleReceiverService ruleReceiverService;

    @Override
    public List<RuleControlVO> queryControlByFeeDetailId(Long ruleId, Long feeDetailId) {
        FeeDetailEntity feeDetailEntity = (FeeDetailEntity)((Object)this.feeDetailService.selectById(feeDetailId));
        List<FeeDetailScopeEntity> feeDetailScopeList = feeDetailEntity.getFeeDetailScopeList();
        if (CollectionUtils.isEmpty(feeDetailScopeList)) {
            return null;
        }
        ArrayList<RuleControlVO> ruleControlVOList = new ArrayList<RuleControlVO>();
        HashMap ruleDetailMap = new HashMap();
        if (null != ruleId) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(RuleDetailEntity::getFeeDetailId, (Object)feeDetailId);
            queryWrapper.eq(RuleDetailEntity::getRuleId, (Object)ruleId);
            List ruleDetailEntities = this.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)ruleDetailEntities)) {
                for (RuleDetailEntity ruleDetailEntity : ruleDetailEntities) {
                    ArrayList<RuleDetailVO> vos = ruleDetailMap.containsKey(ruleDetailEntity.getFeeType()) ? (List)ruleDetailMap.get(ruleDetailEntity.getFeeType()) : new ArrayList<RuleDetailVO>();
                    RuleDetailVO detailVO = (RuleDetailVO)((Object)BeanMapper.map((Object)((Object)ruleDetailEntity), RuleDetailVO.class));
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.eq(RuleReceiverEntity::getRuleDetailId, (Object)detailVO.getId());
                    detailVO.setMessageReceiver(BeanMapper.mapList((Iterable)this.ruleReceiverService.list((Wrapper)query), RuleReceiverVO.class));
                    vos.add(detailVO);
                    ruleDetailMap.put(ruleDetailEntity.getFeeType(), vos);
                }
            }
        }
        HashMap billMap = new HashMap();
        for (FeeDetailScopeEntity scopeEntity : feeDetailScopeList) {
            String typeString = scopeEntity.getMemoValue();
            for (String type : typeString.split(",")) {
                Integer typeInt = Integer.valueOf(type);
                if (!feeDetailEntity.getLeafFlag().booleanValue() && FeeTypeEnum.\u5206\u7c7b\u91cf\u63a7.getCode().equals(typeInt)) continue;
                List<RuleControlBillVO> vos = billMap.containsKey(typeInt) ? (List)billMap.get(typeInt) : new ArrayList();
                RuleControlBillVO ruleControlBillVO = new RuleControlBillVO();
                ruleControlBillVO.setId(scopeEntity.getId());
                ruleControlBillVO.setBillType(scopeEntity.getBillType());
                ruleControlBillVO.setMemo(scopeEntity.getMemo());
                ruleControlBillVO.setProperty(scopeEntity.getProperty());
                vos.add(ruleControlBillVO);
                billMap.put(typeInt, vos);
            }
        }
        for (Integer key : billMap.keySet()) {
            RuleControlVO ruleControlVO = new RuleControlVO();
            ruleControlVO.setFeeId(feeDetailEntity.getFeeId());
            ruleControlVO.setFeeDetailId(feeDetailId);
            ruleControlVO.setFeeInnerCode(feeDetailEntity.getInnerCode());
            ruleControlVO.setFeeSelfFlag(feeDetailEntity.getSelfFlag());
            ruleControlVO.setFeeType(key);
            ruleControlVO.setControlBillVOList((List)billMap.get(key));
            ruleControlVO.setDetailVOList((List)ruleDetailMap.get(key));
            ruleControlVO.setNullControlFlag(ruleDetailMap.containsKey(key) ? ((RuleDetailVO)((Object)((List)ruleDetailMap.get(key)).get(0))).getNullControlFlag() : false);
            ruleControlVOList.add(ruleControlVO);
        }
        return ruleControlVOList;
    }
}

