package com.ejianc.business.targetcost.service.impl;

import cn.hutool.core.util.BooleanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.mapper.DetailCacheMapper;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDutyDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标成本明细汇总缓存
 *
 * @author generator
 *
 */
@Service("detailCacheService")
public class DetailCacheServiceImpl extends BaseServiceImpl<DetailCacheMapper, DetailCacheEntity> implements IDetailCacheService{

    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailService dutyDetailService;

    @Override
    public List<DetailCacheEntity> queryReportDetail(Long dutyDetailId, Boolean containChange, Boolean isAll) {
        LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailCacheEntity::getDutyDetailId, dutyDetailId);
        queryWrapper.isNull(!isAll, DetailCacheEntity::getDutyItemId);
        List<DetailCacheEntity> list = list(queryWrapper);
        if (BooleanUtil.isTrue(containChange)) {
            DutyDetailEntity detailEntity = dutyDetailService.selectById(dutyDetailId);
            DutyEntity dutyEntity = dutyService.gatherWithChange(detailEntity.getProjectId(), null);
            Map<Long, DutyDetailEntity> detailMap = dutyEntity.getDutyDetailList().stream().collect(Collectors.toMap(DutyDetailEntity::getFeeDetailId, Function.identity(), (key1, key2) -> key1));
            List<DutyDetailItemEntity> itemList = detailMap.get(detailEntity.getFeeDetailId()).getDutyDetailItemList();
            if (CollectionUtils.isNotEmpty(itemList)) {
                if (null != itemList.get(0).getDocId()) {
                    Map<Long, DutyDetailItemEntity> itemMap = itemList.stream().collect(Collectors.toMap(DutyDetailItemEntity::getDocId, Function.identity(), (key1, key2) -> key1));
                    for(DetailCacheEntity cacheEntity : list){
                        if (itemMap.containsKey(cacheEntity.getDocId())) {
                            DutyDetailItemEntity itemEntity = itemMap.get(cacheEntity.getDocId());
                            cacheEntity.setTaxRate(itemEntity.getTaxRate());
                            cacheEntity.setPrice(itemEntity.getPrice());
                            cacheEntity.setTaxPrice(itemEntity.getTaxPrice());
                            cacheEntity.setAmount(itemEntity.getAmount());
                            cacheEntity.setMny(itemEntity.getMny());
                            cacheEntity.setTaxMny(itemEntity.getTaxMny());
                            itemMap.remove(cacheEntity.getDocId());
                        }
                    }
                    if (!itemMap.isEmpty()) {
                        for(DutyDetailItemEntity itemEntity : itemMap.values()){
                            DetailCacheEntity newCache = BeanMapper.map(itemEntity, DetailCacheEntity.class);
                            newCache.setDutyItemId(itemEntity.getId());
                            newCache.setSpec(itemEntity.getModel());
                            list.add(newCache);
                        }
                    }
                }else {
                    list = new ArrayList<>();
                    for(DutyDetailItemEntity itemEntity : itemList){
                        DetailCacheEntity newCache = BeanMapper.map(itemEntity, DetailCacheEntity.class);
                        newCache.setDutyItemId(itemEntity.getId());
                        newCache.setSpec(itemEntity.getModel());
                        list.add(newCache);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public List<DetailCacheEntity> queryByProjAndFeeDetail(Long projectId, Long feeDetailId, Boolean isAll) {
        LambdaQueryWrapper<DetailCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DetailCacheEntity::getProjectId, projectId);
        queryWrapper.eq(DetailCacheEntity::getFeeDetailId, feeDetailId);
        queryWrapper.isNull(!isAll, DetailCacheEntity::getDutyItemId);
        List<DetailCacheEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            for(DetailCacheEntity detailCacheEntity : list){
                detailCacheEntity.setAmount(detailCacheEntity.getContNum());
            }
        }
        return list;
    }

    @Override
    public void deleteByProjectIdPhy(Long projectId) {
        baseMapper.deleteByProjectIdPhy(projectId);
    }

    @Override
    public void deleteByIdsPhy(List<Long> idList) {
        baseMapper.deleteByIdsPhy(idList);
    }
}
