package com.ejianc.business.targetcost.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.service.IAssessDetailService;
import com.ejianc.business.targetcost.service.IDutyAssessAdjustDetailService;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.vo.AssessDetailVO;
import com.ejianc.business.targetcost.vo.DutyWarnVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author
 * @Description:
 * @date
 */
@RestController
@RequestMapping(value = "/dutyWarn/")
public class DutyWarnController {
//       * * * 26 * ?
//       {"dispatchCode":"WARNING000088"}
//    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDutyService service;

    @Autowired
    private IAssessDetailService assessDetailService;

    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private DutyMapper dutyMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static  String  PC_URL_EC = "/ejc-targetcost-frontend/#/execution?projectId=";
    static  String  TEST_AGENTID = "1000038";
    static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static  String  PRO_AGENTID = "1000036";
    static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";

    static  String  PC_URL = "/ejc-targetcost-frontend/#/duty";

    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        Integer day = 15;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据

            List<AssessDetailVO> assessDetailVOS = service.queryWarnList();

            if (ListUtil.isNotEmpty(assessDetailVOS)) {
                for (AssessDetailVO assessDetailVO : assessDetailVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = assessDetailVO.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     **/
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        Date now = new Date();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            day = set.getBigDecimal("parameterValue").intValue();
                            if ("高".equals(set.getString("warningLevel"))) {
                                if ((assessDetailVO.getAssessTime().getTime() - now.getTime()) / (1000 * 60 * 60 * 24) <= day
                                        && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / (1000 * 60 * 60 * 24) >= 0) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if ((assessDetailVO.getAssessTime().getTime() - now.getTime()) / (1000 * 60 * 60 * 24) <= day
                                        && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / (1000 * 60 * 60 * 24) >= 0) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if ((assessDetailVO.getAssessTime().getTime() - now.getTime()) / (1000 * 60 * 60 * 24) <= day
                                        && (assessDetailVO.getAssessTime().getTime() - now.getTime()) / (1000 * 60 * 60 * 24) >= 0) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            String pattern = "yyyy-MM-dd HH:mm:ss";
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    assessDetailVO.getProjectName());
                            vo.setPcTitle("目标责任成本");
                            vo.setPcUrl(PC_URL + assessDetailVO.getParentId());
                            vo.setOrgId(assessDetailVO.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                            vo.setOrgName(assessDetailVO.getOrgName());
                            vo.setSourceId(assessDetailVO.getParentId().toString());
                            vo.setTenantId(999999L);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName())
                                                .replaceAll("#assessName#", assessDetailVO.getAssessName())
                                                .replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime()))

                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName())
                                                .replaceAll("#assessName#", assessDetailVO.getAssessName())
                                                .replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getProjectName())
                                                .replaceAll("#assessName#", assessDetailVO.getAssessName())
                                                .replaceAll("#assessTime#", simpleDateFormat.format(assessDetailVO.getAssessTime()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
    @PostMapping(value = "noDutyExecute")
    public CommonResponse<String> noDutyExecute(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;


        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            List<DutyWarnVO> dutyWarnVOS = service.queryProjectList();

            if (ListUtil.isNotEmpty(dutyWarnVOS)) {
                for (DutyWarnVO assessDetailVO : dutyWarnVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = assessDetailVO.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     **/
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        Date now = new Date();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                                //判断是否epc和费率项目
                                if(!((assessDetailVO.getProjectType() != null && assessDetailVO.getProjectType().equals(1506581476628926466L)) || (assessDetailVO.getContractValuationType() != null && assessDetailVO.getContractValuationType().equals(1269824218831179778L)))){
                                    //判断工期和施工合同额
                                    if((assessDetailVO.getPlanDateNum() != null && assessDetailVO.getPlanDateNum() >= 365) || (assessDetailVO.getBaseTaxMoney() == null && assessDetailVO.getBaseTaxMoney().compareTo(new BigDecimal("10000*1000*5")) >= 0)){
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 90){
                                            //7
                                            low = true;
                                            useSetLow = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 120){
                                            //8
                                            meddle = true;
                                            useSetMeddle = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 150){
                                            //9
                                            high = true;
                                            useSetHigh = set;
                                        }
                                    }else if((assessDetailVO.getPlanDateNum() != null && assessDetailVO.getPlanDateNum() >= 180) || (assessDetailVO.getBaseTaxMoney() == null && assessDetailVO.getBaseTaxMoney().compareTo(new BigDecimal("10000*1000*2")) >= 0)){
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 60){
                                            //4
                                            low = true;
                                            useSetLow = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 90){
                                            //5
                                            meddle = true;
                                            useSetMeddle = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 120){
                                            //6
                                            high = true;
                                            useSetHigh = set;
                                        }
                                    }else {
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 30){
                                            //1
                                            low = true;
                                            useSetLow = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 60){
                                            //2
                                            meddle = true;
                                            useSetMeddle = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 90){
                                            //3
                                            high = true;
                                            useSetHigh = set;
                                        }
                                    }

                                }else {
                                        //EPC和费率合同不再判断工期和施工合同额
                                     if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 90){
                                            //7
                                            low = true;
                                            useSetLow = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 120){
                                            //8
                                            meddle = true;
                                            useSetMeddle = set;
                                        }
                                        if (assessDetailVO.getChangeStatusDate() != null && (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) > 150){
                                            //9
                                            high = true;
                                            useSetHigh = set;
                                        }

                                }



                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            String pattern = "yyyy-MM-dd HH:mm:ss";
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    assessDetailVO.getName());
                            vo.setPcTitle("目标责任成本未编制");
                            vo.setPcUrl(PC_URL );
                            vo.setOrgId(assessDetailVO.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                            vo.setOrgName(assessDetailVO.getName());
                            vo.setSourceId(assessDetailVO.getId().toString());
                            vo.setTenantId(999999L);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                        .replaceAll("#day#", (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) +"")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                        .replaceAll("#day#", (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) +"")

                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#day#", (now.getTime()-assessDetailVO.getChangeStatusDate().getTime()) / (1000 * 60 * 60 * 24) +"")

                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }


    @PostMapping(value = "queryExecution")
    public CommonResponse<List<JSONObject>> queryExecution(HttpServletRequest request) {
        logger.info("消息发送前1---------------->");
        List<DutyWarnVO> taskinstVOS = dutyMapper.queryExecution();
        logger.info("消息发送前2---------------->{}",taskinstVOS.size());
        //发送消息
        if(CollectionUtils.isNotEmpty(taskinstVOS)) {
            for (DutyWarnVO taskEntity : taskinstVOS) {
                sendSys(taskEntity.getCostAdapter() + "", taskEntity.getName(), taskEntity.getProjectName(), taskEntity.getProjectId());
                try {
                    //睡眠0.1s
                    Thread.currentThread().sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success("执行成功！");
    }
    public boolean sendSys(String receiverId,String name,String projectName,Long projectId){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {receiverId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("earlywarning");//预警消息
        parameter.setSubject(projectName+"项目物资模块的（"+name+"），超出目标成本");// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl(PC_URL_EC+projectId);// pc端url
        parameter.setMobileUrl(PC_URL_EC+projectId);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid",PRO_AGENTID);//企业微信应用id
        weixineeParams.put("secret", PRO_SECRET);//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "目标成本超出提醒");
        weixineeParams.put("description", projectName+"项目物资模块的（"+name+"），超出目标成本的对应费用项金额，请及时前往电脑端查看数据排查原因，如有问题及时与项目沟通。");
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
                "&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-targetcost-frontend%2f%23%2fexecution%3fprojectId%3d%0a"+projectId));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.info("消息发送成功---------------->,接收人:{}", Arrays.toString(receivers));

            return true;
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return false;
        }
    }
}