package com.ejianc.business.costinspection.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 成本巡检现场跟踪表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costinspection_site_tracking")
public class SiteTrackingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="inspection_time")
    private Date inspectionTime; // 巡检时间
    @TableField(value="project_leader_id")
    private Long projectLeaderId; // 项目负责人
    @TableField(value="project_leader")
    private String projectLeader; // 项目负责人名称
    @TableField(value="cost_communicat_id")
    private Long costCommunicatId; // 项目成本对接人
    @TableField(value="cost_communicat_name")
    private String costCommunicatName; // 项目成本对接人名称
    @TableField(value="inspection_person_id")
    private Long inspectionPersonId; // 成本巡检人员
    @TableField(value="inspection_person_name")
    private String inspectionPersonName; // 成本巡检人员名称
    @TableField(value="participant")
    private String participant; // 项目参与人员
    @TableField(value="is_rectification_form")
    private String isRectificationForm; // 是否下发整改单
    @TableField(value="rectification_time")
    private Date rectificationTime; // 限时整改日期
    @TableField(value="is_inspection")
    private String isInspection; // 项目参与人员
    @TableField(value="inspection_type")
    private String inspectionType; // 巡检类型


    @TableField(exist=false)
    @SubEntity(serviceName="siteTrackingContentService")
    private List<SiteTrackingContentEntity> siteTrackingContentList = new ArrayList<>(); // 巡检跟踪子表
    @TableField(exist=false)
    @SubEntity(serviceName="siteTrackingRectifyContentService")
    private List<SiteTrackingRectifyContentEntity> siteTrackingRectifyContentList = new ArrayList<>(); // 巡检跟踪整改子表


    public String getInspectionType() {
        return inspectionType;
    }

    public void setInspectionType(String inspectionType) {
        this.inspectionType = inspectionType;
    }

    public List<SiteTrackingRectifyContentEntity> getSiteTrackingRectifyContentList() {
        return siteTrackingRectifyContentList;
    }

    public void setSiteTrackingRectifyContentList(List<SiteTrackingRectifyContentEntity> siteTrackingRectifyContentList) {
        this.siteTrackingRectifyContentList = siteTrackingRectifyContentList;
    }

    public String getIsInspection() {
        return isInspection;
    }

    public void setIsInspection(String isInspection) {
        this.isInspection = isInspection;
    }

    public List<SiteTrackingContentEntity> getSiteTrackingContentList() {
        return siteTrackingContentList;
    }

    public void setSiteTrackingContentList(List<SiteTrackingContentEntity> siteTrackingContentList) {
        this.siteTrackingContentList = siteTrackingContentList;
    }

    public String getIsRectificationForm() {
        return isRectificationForm;
    }

    public void setIsRectificationForm(String isRectificationForm) {
        this.isRectificationForm = isRectificationForm;
    }

    public Date getRectificationTime() {
        return rectificationTime;
    }

    public void setRectificationTime(Date rectificationTime) {
        this.rectificationTime = rectificationTime;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }
    public Long getProjectLeaderId() {
        return projectLeaderId;
    }

    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }
    public String getProjectLeader() {
        return projectLeader;
    }

    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    public Long getCostCommunicatId() {
        return costCommunicatId;
    }

    public void setCostCommunicatId(Long costCommunicatId) {
        this.costCommunicatId = costCommunicatId;
    }
    public String getCostCommunicatName() {
        return costCommunicatName;
    }

    public void setCostCommunicatName(String costCommunicatName) {
        this.costCommunicatName = costCommunicatName;
    }
    public Long getInspectionPersonId() {
        return inspectionPersonId;
    }

    public void setInspectionPersonId(Long inspectionPersonId) {
        this.inspectionPersonId = inspectionPersonId;
    }
    public String getInspectionPersonName() {
        return inspectionPersonName;
    }

    public void setInspectionPersonName(String inspectionPersonName) {
        this.inspectionPersonName = inspectionPersonName;
    }
    public String getParticipant() {
        return participant;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }
    
}
