package com.ejianc.business.costinspection.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.costinspection.mapper.SiteTrackingMapper;
import com.ejianc.business.costinspection.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.costinspection.bean.SiteTrackingEntity;
import com.ejianc.business.costinspection.service.ISiteTrackingService;
import com.ejianc.business.costinspection.vo.SiteTrackingVO;

/**
 * 成本巡检现场跟踪表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("siteTracking")
public class SiteTrackingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISiteTrackingService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private SiteTrackingMapper mapper;
    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SiteTrackingVO> saveOrUpdate(@RequestBody SiteTrackingVO saveOrUpdateVO) {
    	SiteTrackingEntity entity = BeanMapper.map(saveOrUpdateVO, SiteTrackingEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SiteTrackingVO vo = BeanMapper.map(entity, SiteTrackingVO.class);


        vo.setSiteTrackingContentList(TreeNodeBUtil.buildTree(vo.getSiteTrackingContentList()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SiteTrackingVO> queryDetail(Long id) {
    	SiteTrackingEntity entity = service.selectById(id);
    	SiteTrackingVO vo = BeanMapper.map(entity, SiteTrackingVO.class);

        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getSiteTrackingContentList())) {
            vo.setSiteTrackingContentList(TreeNodeBUtil.buildTree(vo.getSiteTrackingContentList()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SiteTrackingVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SiteTrackingVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SiteTrackingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SiteTrackingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SiteTrackingEntity> page = service.queryPage(param,false);
        IPage<SiteTrackingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SiteTrackingVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SiteTrackingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SiteTracking-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSiteTrackingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SiteTrackingVO>> refSiteTrackingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        //组织过滤
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).
                        getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if (con != null) {
                String isRectificationForm = con.getString("isRectificationForm");//是否下发整改单
                param.getParams().put("isRectificationForm", new Parameter(QueryParam.EQ, isRectificationForm));
            }
        }

        IPage<SiteTrackingEntity> page = service.queryPage(param,false);
        IPage<SiteTrackingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SiteTrackingVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SiteTrackingVO>> queryReportList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        Page<SiteTrackingVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<SiteTrackingVO> siteTrackingVOS = mapper.reportList(page, wrapper);

        List<Long> siteIds = siteTrackingVOS.stream().map(SiteTrackingVO::getId).collect(Collectors.toList());
        List<Long> noticeIds = siteTrackingVOS.stream().map(SiteTrackingVO::getNoticeId).collect(Collectors.toList());
        List<Long> reportIds = siteTrackingVOS.stream().map(SiteTrackingVO::getReportId).collect(Collectors.toList());
        siteIds.addAll(noticeIds);
        siteIds.addAll(reportIds);
        HashSet<Long> set = new HashSet<>(siteIds);
        Long[] array = new Long[set.size()];
        set.toArray(array);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceIds",array);
        jsonObject.put("orderType","desc");

        //附件集合
        Map<String, AttachmentVO> collect = new HashMap<>();
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(jsonObject);
        if (listCommonResponse.getCode() == 0){
            if(listCommonResponse.getData() != null){
                collect = listCommonResponse.getData().stream().collect(
                        Collectors.toMap(x -> String.format("%s:%s", x.getSourceId(), x.getSourceType()), AttachmentVO -> AttachmentVO,(k1,k2)->k1));
            }
        }
        if (collect.size() > 0 && siteTrackingVOS != null){
            for (SiteTrackingVO siteTrackingVO : siteTrackingVOS) {
                //跟踪单附件
                if (collect.containsKey(siteTrackingVO.getId()+":file1")){
                    siteTrackingVO.setGzFileName(collect.get(siteTrackingVO.getId()+":file1").getFileName());
                    siteTrackingVO.setGzFileUrl(collect.get(siteTrackingVO.getId()+":file1").getId()+"");
                }else {
                    siteTrackingVO.setGzFileName("无");
                    siteTrackingVO.setGzFileUrl("");
                }
                //整改单附件
                if (collect.containsKey(siteTrackingVO.getId()+":file2")){
                    siteTrackingVO.setZgFileName(collect.get(siteTrackingVO.getId()+":file2").getFileName());
                    siteTrackingVO.setZgFileUrl(collect.get(siteTrackingVO.getId()+":file2").getId()+"");
                }else {
                    siteTrackingVO.setZgFileName("无");
                    siteTrackingVO.setZgFileUrl("");
                }
                //回复单附件
                if (collect.containsKey(siteTrackingVO.getNoticeId()+":file1")){
                    siteTrackingVO.setHfFileName(collect.get(siteTrackingVO.getNoticeId()+":file1").getFileName());
                    siteTrackingVO.setHfFileUrl(collect.get(siteTrackingVO.getNoticeId()+":file1").getId()+"");
                }else {
                    siteTrackingVO.setHfFileName("无");
                    siteTrackingVO.setHfFileUrl("");
                }
                //报告附件
                if (collect.containsKey(siteTrackingVO.getReportId()+":file1")){
                    siteTrackingVO.setBgFileName(collect.get(siteTrackingVO.getReportId()+":file1").getFileName());
                    siteTrackingVO.setBgFileUrl(collect.get(siteTrackingVO.getReportId()+":file1").getId()+"");
                }else {
                    siteTrackingVO.setBgFileName("无");
                    siteTrackingVO.setBgFileUrl("");
                }
            }
        }

        IPage<SiteTrackingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(siteTrackingVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }




}
