package com.ejianc.business.targetcost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.targetcost.bean.DutyAssessAdjustDetailEntity;
/**
 * 成本分析节点调整申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_targetcost_duty_assess_adjust")
public class DutyAssessAdjustEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="project_id")
    private Long projectId; // 所属项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="duty_id")
    private Long dutyId; // 目标责任成本
    @TableField(value="duty_name")
    private String dutyName; // 目标责任成本名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    
    @TableField(exist=false)
    @SubEntity(serviceName="dutyAssessAdjustDetailService", pidName = "parentId")
    private List<DutyAssessAdjustDetailEntity> dutyAssessAdjustDetailList = new ArrayList<>(); // 成本分析节点调整申请明细


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Long getDutyId() {
        return dutyId;
    }

    public void setDutyId(Long dutyId) {
        this.dutyId = dutyId;
    }
    public String getDutyName() {
        return dutyName;
    }

    public void setDutyName(String dutyName) {
        this.dutyName = dutyName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<DutyAssessAdjustDetailEntity> getDutyAssessAdjustDetailList() {
        return dutyAssessAdjustDetailList;
    }

    public void setDutyAssessAdjustDetailList(List<DutyAssessAdjustDetailEntity> dutyAssessAdjustDetailList) {
        this.dutyAssessAdjustDetailList = dutyAssessAdjustDetailList;
    }
}
