package com.ejianc.business.tax.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 收票管理发票明细表
 *
 * @author generator
 *
 */
public class InvoiceDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    private String invoiceNumber; // 发票号码
    private String invoiceCode; // 发票代码
    private Date invoiceDate; // 开票日期
    private BigDecimal invoiceMny; // 发票金额（不含税）
    private BigDecimal taxMny; // 税额（税金）
    private BigDecimal invoiceTaxMny; // 价税合计
    private String invoiceTypeName; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    private Long invoiceReceiveId; // 收票登记id
    private BigDecimal taxRate; // 税率
    private String memo; // 备注
    private Long receiveId; // 收票登记主键
    private String isDz; // 是否电子发票0-否 1-是
    private String mxCustomerName; // 发票信息-购方名称
    private String mxCustomerCreditCode; // 发票信息-纳税人识别号
    private String mxSupplierName; // 发票信息-销方名称
    private String mxSupplierCreditCode; // 发票信息-销方纳税人识别号
    private Integer inputMethod; // 录入方式 1-发票采集 2-手动录入


    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }

    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public Long getInvoiceReceiveId() {
        return invoiceReceiveId;
    }

    public void setInvoiceReceiveId(Long invoiceReceiveId) {
        this.invoiceReceiveId = invoiceReceiveId;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getReceiveId() {
        return receiveId;
    }

    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }
    public String getIsDz() {
        return isDz;
    }

    public void setIsDz(String isDz) {
        this.isDz = isDz;
    }
    public String getMxCustomerName() {
        return mxCustomerName;
    }

    public void setMxCustomerName(String mxCustomerName) {
        this.mxCustomerName = mxCustomerName;
    }
    public String getMxCustomerCreditCode() {
        return mxCustomerCreditCode;
    }

    public void setMxCustomerCreditCode(String mxCustomerCreditCode) {
        this.mxCustomerCreditCode = mxCustomerCreditCode;
    }
    public String getMxSupplierName() {
        return mxSupplierName;
    }

    public void setMxSupplierName(String mxSupplierName) {
        this.mxSupplierName = mxSupplierName;
    }
    public String getMxSupplierCreditCode() {
        return mxSupplierCreditCode;
    }

    public void setMxSupplierCreditCode(String mxSupplierCreditCode) {
        this.mxSupplierCreditCode = mxSupplierCreditCode;
    }
    public Integer getInputMethod() {
        return inputMethod;
    }

    public void setInputMethod(Integer inputMethod) {
        this.inputMethod = inputMethod;
    }
}
