package com.ejianc.business.tax.service;

import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 有合同开票 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IInvoiceReceiveService extends IBaseService<InvoiceReceiveEntity> {
    /**
     * 保存或修改信息
     *
     * @param RentContractVo
     * @return
     */
    CommonResponse<InvoiceReceiveVO> saveOrUpdate(InvoiceReceiveVO RentContractVo);
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    InvoiceReceiveVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deleteInvoiceReceive(List<InvoiceReceiveVO> vos);
    BigDecimal getReceiveMny(Long contractId, Long orgId);


    InvoiceReceiveRecordVO getInvoiceReceiveRecord(Long id);
    Map<Long,InvoiceReceiveRecordVO> getInvoiceReceiveRecords(List<Long> ids);

    CommonResponse<String> updateFlag(List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS);

    Map<String, InvoiceMnyWarnVO> getInvoiceMnyByTenantIds(InvoicePubWarnQueryVO pubWarnQueryVO);

    List<InvoiceReceiveVO> getTaxReceive(Long projectId);

    Map<String,InvoiceMnyWarnVO> getWarnInvoiceMny(InvoicePubWarnQueryVO pubWarnQueryVO);

    CommonResponse<String> updateUsedInvoiceMny(List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS);
}
