package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceOpenApplyMapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 开票申请
 * 
 * @author generator
 * 
 */
@Service("invoiceOpenApplyService")
public class InvoiceOpenApplyServiceImpl extends BaseServiceImpl<InvoiceOpenApplyMapper, InvoiceOpenApplyEntity> implements IInvoiceOpenApplyService{

     @Autowired
     private IInvoiceOpenRegistService invoiceOpenRegistService;

    /**
     * 根据合同id统计本次申请金额(含税)
     * @param contractId
     * @return
     */
    public Map<String, BigDecimal> selectSumApplyMnyTax(Long contractId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<InvoiceOpenApplyEntity> query = new QueryWrapper<InvoiceOpenApplyEntity>();
        query.select("  sum(apply_mny_tax) as totalOpenApplyMnyTax ");
        query.eq("contract_id", contractId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state",BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);

        if(null != data) {
            resp.put("totalOpenApplyMnyTax", null != data.get("totalOpenApplyMnyTax") ? new BigDecimal(data.get("totalOpenApplyMnyTax").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalOpenApplyMnyTax", BigDecimal.ZERO);
        }

        Map<String, BigDecimal> invoiceMnyMap= invoiceOpenRegistService.selectSumInvoiceMny(contractId);
        resp.put("totalOpenMny",invoiceMnyMap.get("totalInvoiceMny"));
        return resp;
    }


}
