package com.ejianc.business.tax.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 合同收票表 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IInvoiceOpenService extends IBaseService<InvoiceOpenEntity> {
    /**
     * 保存或修改信息
     *
     * @param in
     * @return
     */
    CommonResponse<InvoiceOpenVO> saveOrUpdate(InvoiceOpenVO RentContractVo);
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    InvoiceOpenVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param ids
     */
    void deleteInvoiceOpen(List<InvoiceOpenVO> vos);
    BigDecimal getOpenMny(Long contractId, Long orgId);
    InvoiceOpenRecordVO getInvoiceOpenRecord(Long id);

    BigDecimal getNoContractOpenMny(Long projectId, Long customerId);

    BigDecimal billingContract(Long projectId);

    List<InvoiceOpenVO> queryInvoiceOpenList(QueryWrapper wrapper, Page<InvoiceOpenVO> page);
}
