package com.ejianc.business.taxnew.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.taxnew.bean.InvoiceDeducBillSubEntity;
/**
 * 进项抵扣单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_deduction_bill")
public class InvoiceDeducBillEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="apply_date")
    private java.util.Date applyDate; // 申请日期
    @TableField(value="apply_person_id")
    private Long applyPersonId; // 申请人id
    @TableField(value="apply_person_name")
    private String applyPersonName; // 申请人
    @TableField(value="apply_deduc_mny")
    private java.math.BigDecimal applyDeducMny; // 本次申请抵扣金额
    @TableField(value="deduc_tax_mny")
    private java.math.BigDecimal deducTaxMny; // 本次申请抵扣税额
    @TableField(value="total_apply_deduc_mny")
    private java.math.BigDecimal totalApplyDeducMny; // 累计已抵扣发票金额（不含本次）
    @TableField(value="total_deduc_tax_mny")
    private java.math.BigDecimal totalDeducTaxMny; // 累计抵扣税额(不含本次)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="actual_deduc_mny")
    private java.math.BigDecimal actualDeducMny; // 本次实际抵扣金额
    @TableField(value="actual_deduc_tax_mny")
    private java.math.BigDecimal actualDeducTaxMny; // 本次实际抵扣税额
    @TableField(value="already_deduc")
    private Boolean alreadyDeduc; // 是否完成抵扣（抵扣单审批通过）
    @TableField(value="process_person_id")
    private Long processPersonId; // 经办人id
    @TableField(value="process_person_name")
    private String processPersonName; // 经办人名称
    @TableField(value="apply_id")
    private Long applyId; // 申请单id
    @TableField(value="apply_invoice_quantity")
    private Integer applyInvoiceQuantity; // 申请发票数量
    @TableField(value="actual_invoice_quantity")
    private Integer actualInvoiceQuantity; // 实际抵扣发票数量

    @TableField(exist=false)
    @SubEntity(serviceName="invoiceDeducBillSubService")
    private List<InvoiceDeducBillSubEntity> invoiceDeducBillSubs = new ArrayList<>(); // 进项抵扣单子表
    

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 申请人id
     */
    public Long getApplyPersonId() {
        return applyPersonId;
    }

    /**
     * 申请人id
     */
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    /**
     * 申请人
     */
    public String getApplyPersonName() {
        return applyPersonName;
    }

    /**
     * 申请人
     */
    public void setApplyPersonName(String applyPersonName) {
        this.applyPersonName = applyPersonName;
    }
    /**
     * 本次申请抵扣金额
     */
    public java.math.BigDecimal getApplyDeducMny() {
        return applyDeducMny;
    }

    /**
     * 本次申请抵扣金额
     */
    public void setApplyDeducMny(java.math.BigDecimal applyDeducMny) {
        this.applyDeducMny = applyDeducMny;
    }
    /**
     * 本次申请抵扣税额
     */
    public java.math.BigDecimal getDeducTaxMny() {
        return deducTaxMny;
    }

    /**
     * 本次申请抵扣税额
     */
    public void setDeducTaxMny(java.math.BigDecimal deducTaxMny) {
        this.deducTaxMny = deducTaxMny;
    }
    /**
     * 累计已抵扣发票金额（不含本次）
     */
    public java.math.BigDecimal getTotalApplyDeducMny() {
        return totalApplyDeducMny;
    }

    /**
     * 累计已抵扣发票金额（不含本次）
     */
    public void setTotalApplyDeducMny(java.math.BigDecimal totalApplyDeducMny) {
        this.totalApplyDeducMny = totalApplyDeducMny;
    }
    /**
     * 累计抵扣税额(不含本次)
     */
    public java.math.BigDecimal getTotalDeducTaxMny() {
        return totalDeducTaxMny;
    }

    /**
     * 累计抵扣税额(不含本次)
     */
    public void setTotalDeducTaxMny(java.math.BigDecimal totalDeducTaxMny) {
        this.totalDeducTaxMny = totalDeducTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 本次实际抵扣金额
     */
    public java.math.BigDecimal getActualDeducMny() {
        return actualDeducMny;
    }

    /**
     * 本次实际抵扣金额
     */
    public void setActualDeducMny(java.math.BigDecimal actualDeducMny) {
        this.actualDeducMny = actualDeducMny;
    }
    /**
     * 本次实际抵扣税额
     */
    public java.math.BigDecimal getActualDeducTaxMny() {
        return actualDeducTaxMny;
    }

    /**
     * 本次实际抵扣税额
     */
    public void setActualDeducTaxMny(java.math.BigDecimal actualDeducTaxMny) {
        this.actualDeducTaxMny = actualDeducTaxMny;
    }
    /**
     * 是否完成抵扣（抵扣单审批通过）
     */
    public Boolean getAlreadyDeduc() {
        return alreadyDeduc;
    }

    /**
     * 是否完成抵扣（抵扣单审批通过）
     */
    public void setAlreadyDeduc(Boolean alreadyDeduc) {
        this.alreadyDeduc = alreadyDeduc;
    }
    /**
     * 经办人id
     */
    public Long getProcessPersonId() {
        return processPersonId;
    }

    /**
     * 经办人id
     */
    public void setProcessPersonId(Long processPersonId) {
        this.processPersonId = processPersonId;
    }
    /**
     * 经办人名称
     */
    public String getProcessPersonName() {
        return processPersonName;
    }

    /**
     * 经办人名称
     */
    public void setProcessPersonName(String processPersonName) {
        this.processPersonName = processPersonName;
    }

    public List<InvoiceDeducBillSubEntity> getInvoiceDeducBillSubs() {
        return invoiceDeducBillSubs;
    }

    public void setInvoiceDeducBillSubs(List<InvoiceDeducBillSubEntity> invoiceDeducBillSubs) {
        this.invoiceDeducBillSubs = invoiceDeducBillSubs;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Integer getApplyInvoiceQuantity() {
        return applyInvoiceQuantity;
    }

    public void setApplyInvoiceQuantity(Integer applyInvoiceQuantity) {
        this.applyInvoiceQuantity = applyInvoiceQuantity;
    }

    public Integer getActualInvoiceQuantity() {
        return actualInvoiceQuantity;
    }

    public void setActualInvoiceQuantity(Integer actualInvoiceQuantity) {
        this.actualInvoiceQuantity = actualInvoiceQuantity;
    }
}
