package com.ejianc.business.taxnew.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.finance.vo.ReceiveInvoiceVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 销项发票池
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceOpenPool")
public class InvoiceOpenPoolController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IInvoiceOpenPoolService service;

    @Autowired
    private IReceiveManageApi receiveManageApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceOpenPoolVO> saveOrUpdate(@RequestBody InvoiceOpenPoolVO saveorUpdateVO) {
    	InvoiceOpenPoolEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceOpenPoolEntity.class);
    	service.saveOrUpdate(entity, false);
    	InvoiceOpenPoolVO vo = BeanMapper.map(entity, InvoiceOpenPoolVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenPoolVO> queryDetail(Long id) {
    	InvoiceOpenPoolEntity entity = service.selectById(id);
    	InvoiceOpenPoolVO vo = BeanMapper.map(entity, InvoiceOpenPoolVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceOpenPoolVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceOpenPoolVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceOpenPoolVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("invoiceCode");
        param.getFuzzyFields().add("invoiceNumber");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("registCode");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("regist",new Parameter(QueryParam.EQ,1));

        if(param.getParams().get("hasMyRegist") != null){
            if(param.getParams().get("hasMyRegist").getValue().equals("1")){
                param.getParams().put("employeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            }else if(param.getParams().get("hasMyRegist").getValue().equals("0")){
                param.getParams().put("employeeId", new Parameter(QueryParam.NE, InvocationInfoProxy.getUserid()));
            }
            param.getParams().remove("hasMyRegist");

        }

        IPage<InvoiceOpenPoolEntity> page = service.queryPage(param,false);
        IPage<InvoiceOpenPoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<InvoiceOpenPoolVO> invoiceOpenPoolVOS = BeanMapper.mapList(page.getRecords(), InvoiceOpenPoolVO.class);
        if (CollectionUtils.isNotEmpty(invoiceOpenPoolVOS)) {
            List<Long> invoiceIds = invoiceOpenPoolVOS.stream().map(InvoiceOpenPoolVO::getId).collect(Collectors.toList());
            PayInvoiceUseVO payInvoiceUseVO = new PayInvoiceUseVO();
            payInvoiceUseVO.setInvoiceIds(invoiceIds);
            CommonResponse<List<PayInvoiceUseVO>> listCommonResponse = receiveManageApi.countOpenUseNum(payInvoiceUseVO);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                List<PayInvoiceUseVO> payInvoiceUseVOList = listCommonResponse.getData();
                Map<Long, Integer> map = payInvoiceUseVOList.stream().collect(Collectors.toMap(PayInvoiceUseVO::getInvoiceId, PayInvoiceUseVO::getInvoiceBillNum));
                invoiceOpenPoolVOS.forEach(t -> t.setInvoiceBillNum(map.get(t.getId())));
            }
            for (InvoiceOpenPoolVO vo : invoiceOpenPoolVOS) {
                try {
                    if (vo.getContractId() != null) {
                        JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getContractId()), "income-contract");
                        if (jArray != null && jArray.size() > 0) {
                            JSONObject json = (JSONObject) jArray.get(0);
                            vo.setContractCode(json.getString("code"));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
        pageData.setRecords(invoiceOpenPoolVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 根据登记id查询数据
     * @param registId
     * @return
     */
    @RequestMapping(value = "/queryListByRegistId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryListByRegistId(Long registId){
        JSONObject data = new JSONObject();
        List<InvoiceOpenPoolVO> list = new ArrayList<>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("regist_id" ,registId);
        List<InvoiceOpenPoolEntity> invoiceOpenPoolEntityList =service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(invoiceOpenPoolEntityList)) {
            list = BeanMapper.mapList(invoiceOpenPoolEntityList, InvoiceOpenPoolVO.class);
        }
        data.put("contractItemList",list);
        return CommonResponse.success("查询已登记发票成功！", data);
    }
    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("projectName");

        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("regist",new Parameter(QueryParam.EQ,1));

        IPage<InvoiceOpenPoolEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceOpenPoolVO> voList = new ArrayList<InvoiceOpenPoolVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(invoiceOpenPoolEntity -> {
                InvoiceOpenPoolVO r = BeanMapper.map(invoiceOpenPoolEntity, InvoiceOpenPoolVO.class);
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("invoiceOpenRegistPool-export.xlsx", beans, response);
    }

    /**
     * 导出发票
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelReportExport")
    public void excelReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("projectName");

        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("regist",new Parameter(QueryParam.EQ,1));

        IPage<InvoiceOpenPoolEntity> pageData = service.queryPage(queryParam, false);
        List<InvoiceOpenPoolVO> voList = new ArrayList<InvoiceOpenPoolVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(invoiceOpenPoolEntity -> {
                InvoiceOpenPoolVO r = BeanMapper.map(invoiceOpenPoolEntity, InvoiceOpenPoolVO.class);
                try {
                    if (r.getContractId() != null) {
                        JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(r.getContractId()), "income-contract");
                        if (jArray != null && jArray.size() > 0) {
                            JSONObject json = (JSONObject) jArray.get(0);
                            r.setContractCode(json.getString("code"));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("reportRegistPool-export.xlsx", beans, response);
    }

    /**
     * 根据收票登记id查询销项发票池信息
     *
     * @param registId
     * @return
     */
    @RequestMapping(value = "/queryInvoiceOpenPoolVOInfo", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<ReceiveVO> queryInvoiceOpenPoolVOInfo(@RequestParam("registId") Long registId){
        QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("regist_id",registId);
        List<InvoiceOpenPoolEntity> list = service.list(queryWrapper);
        InvoiceOpenPoolEntity invoiceOpenPoolEntity = list.get(0);
        ReceiveVO receiveVO = new ReceiveVO();
        receiveVO.setOrgId(invoiceOpenPoolEntity.getOrgId());
        receiveVO.setOrgName(invoiceOpenPoolEntity.getOrgName());
        receiveVO.setProjectId(invoiceOpenPoolEntity.getProjectId());
        receiveVO.setProjectName(invoiceOpenPoolEntity.getProjectName());
        if (invoiceOpenPoolEntity.getContractId()!=null){
            receiveVO.setReceiveType(1275321308270993409L);
        }else {
            receiveVO.setReceiveType(1275321354706132993L);
        }
        receiveVO.setContractId(invoiceOpenPoolEntity.getContractId());
        receiveVO.setContractName(invoiceOpenPoolEntity.getContractName());
        receiveVO.setContractCode(invoiceOpenPoolEntity.getContractCode());
        receiveVO.setContractCode(invoiceOpenPoolEntity.getContractCode());
        receiveVO.setReceiveUnitId(invoiceOpenPoolEntity.getCustomerId());
        receiveVO.setReceiveUnitName(invoiceOpenPoolEntity.getContractName());
        List<ReceiveInvoiceVO> invoiceVOList = new ArrayList<>();
        List<InvoiceOpenPoolVO> invoiceOpenPoolVOS = BeanMapper.mapList(list, InvoiceOpenPoolVO.class);
        for (InvoiceOpenPoolVO vo : invoiceOpenPoolVOS) {
            ReceiveInvoiceVO receiveInvoiceVO = new ReceiveInvoiceVO();
            receiveInvoiceVO.setId(IdWorker.getId());
            receiveInvoiceVO.setInvoiceId(vo.getId());
            receiveInvoiceVO.setInvoiceNumber(vo.getInvoiceNumber());
            receiveInvoiceVO.setInvoiceCode(vo.getInvoiceCode());
            receiveInvoiceVO.setInvoiceMny(vo.getInvoiceMny());
            receiveInvoiceVO.setTaxMny(vo.getTaxMny());
            receiveInvoiceVO.setCreateUserName(vo.getCreateUserName());
            receiveInvoiceVO.setInvoiceTaxMny(vo.getInvoiceTaxMny());
            receiveInvoiceVO.setCreateUserCode(vo.getCreateUserCode());
            receiveInvoiceVO.setCreateTime(vo.getCreateTime());
            receiveInvoiceVO.setInvoiceVersion(vo.getVersion());
            receiveInvoiceVO.setSurplusInvoiceTaxMny(ComputeUtil.safeSub(vo.getInvoiceTaxMny(), vo.getUseInvoiceTaxMny()));
            invoiceVOList.add(receiveInvoiceVO);
        }
        receiveVO.setInvoiceVOList(invoiceVOList);
        return CommonResponse.success("查询成功！", receiveVO);
    }
}
