package com.ejianc.business.taxnew.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.business.tax.utils.ConvertUpMoney;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceReceiveRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistDetailVO;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收票登记
 *
 * @author generator
 *
 */
@Service("invoiceReceiveRegistService")
public class InvoiceReceiveRegistServiceImpl extends BaseServiceImpl<InvoiceReceiveRegistMapper, InvoiceReceiveRegistEntity> implements IInvoiceReceiveRegistService{

    private static final String TAX_INVOICE_RECEIVE_BILL_CODE = "TAX_RECEIVE";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IInvoiceReceivePoolService invoiceReceivePoolService;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "tax-receive-code-001";

    //收票登记 发票代码
    private static final String configCodeDm = "TAX_FPDM";
    //收票登记 发票号码
    private static final String configCodeHm = "TAX_FPHM";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 增加或修改对象
     *
     * @param entity 实体对象
     */
    @Override
    public boolean insertOrUpdate(InvoiceReceiveRegistEntity entity) {
        Long invoiceQuantity = 0L ; // 发票数量
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            checkPool(entity.getInvoiceReceiveList());
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(ListUtil.isNotEmpty(entity.getInvoiceReceiveList())){
            CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = getDefMap(defList.getData());

            invoiceQuantity = entity.getInvoiceReceiveList().stream().filter(e -> !"del".equals(e.getRowState())).count();
            for (InvoiceReceivePoolEntity poolEntity : entity.getInvoiceReceiveList()) {
                if ("add".equals(poolEntity.getRowState())) {
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        poolEntity.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    BigDecimal taxMny = poolEntity.getTaxMny();
                    String memo = poolEntity.getMemo();
                    List<Long> attachIds = poolEntity.getAttachIds();
                    BeanUtils.copyProperties(entity, poolEntity, "invoiceType", "invoiceTypeName");
                    poolEntity.setAttachIds(attachIds);
                    poolEntity.setMemo(memo);
                    poolEntity.setTaxMny(taxMny);
                    poolEntity.setId(null);
                    poolEntity.setBillState(0);
                }
                poolEntity.setInvoiceTypeName(defMap.get(poolEntity.getInvoiceType()+""));
                poolEntity.setReceiveBillCode(entity.getCode());
                poolEntity.setReceiveBillId(entity.getId());
                poolEntity.setContractId(entity.getContractId());
                poolEntity.setContractName(entity.getContractName());
                poolEntity.setSupplierId(entity.getSellerId());
                poolEntity.setSupplierName(entity.getSellerName());
                poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
                poolEntity.setCustomerId(entity.getBuyerId());
                poolEntity.setCustomerName(entity.getBuyerName());
                poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
                poolEntity.setEmployeeId(entity.getProcessPersonId());
                poolEntity.setEmployeeName(entity.getProcessPersonName());
                poolEntity.setRegist(false);
                poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
                poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
                poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
                poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
                poolEntity.setAuthState(0);
                poolEntity.setDeductionState(0);
                poolEntity.setFlag(0);
                if(entity.getPurchaseType()!= null){
                    poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
                }
                if(entity.getDependOnProject()!= null){
                    poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
                }
                if(entity.getReceiveType() != null){
                    poolEntity.setContractType(String.valueOf(entity.getReceiveType()));
                }
                if(poolEntity.getContractId()!= null ){
                    poolEntity.setType(1);
                }else{
                    poolEntity.setType(2);
                }
                poolEntity.setOrgId(entity.getOrgId());
                poolEntity.setOrgName(entity.getOrgName());
                poolEntity.setProjectId(entity.getProjectId());
                poolEntity.setProjectName(entity.getProjectName());
                poolEntity.setContractCode(entity.getContractCode());
                // 平台优化后，子表创建人编码不自动添加了，这里手动添加下
                poolEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            }
        }

        entity.setInvoiceQuantity(invoiceQuantity.intValue());
        return super.saveOrUpdateNoES(entity);
    }

    /**
     * 验证发票提交中的发票是否存在重复
     * @param poolList
     */
    public void checkPool(List<InvoiceReceivePoolEntity> poolList) {
        List<String> invoiceNumberList = new ArrayList<>();
        for (InvoiceReceivePoolEntity vo : poolList) {
            if (!"del".equals(vo.getRowState())) {
                String invoiceNumber = vo.getInvoiceNumber();
                if (StringUtils.isNotEmpty(invoiceNumber)) {
                    if (invoiceNumberList.contains(invoiceNumber)) {
                        throw new BusinessException("发票号码【" + invoiceNumber + "】录入重复！");
                    }
                    invoiceNumberList.add(invoiceNumber);

                    LambdaQueryWrapper<InvoiceReceivePoolEntity> invoiceNumberQueryWrapper = new LambdaQueryWrapper<>();
                    invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    invoiceNumberQueryWrapper.eq(InvoiceReceivePoolEntity::getInvoiceNumber, invoiceNumber);
                    invoiceNumberQueryWrapper.ne(vo.getReceiveBillId() != null, InvoiceReceivePoolEntity::getReceiveBillId, vo.getReceiveBillId());
                    int count = invoiceReceivePoolService.count(invoiceNumberQueryWrapper);
                    if (count > 0) {
                        throw new BusinessException("发票号码【" + vo.getInvoiceNumber() + "】已存在！");
                    }
                }
            }

        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    /**
     *  生成一条子表数据
     * @param entity
     * @return
     */
    public List<InvoiceReceivePoolEntity> generateInvoiceReceivePool(InvoiceReceiveRegistEntity entity){
        InvoiceReceivePoolEntity poolEntity = new InvoiceReceivePoolEntity();
        //originType为0 是默认生成
        poolEntity.setOriginType(0);
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_RECEIVE_BILL_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            poolEntity.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        poolEntity.setId(null);
        poolEntity.setReceiveBillCode(entity.getCode());
        poolEntity.setReceiveBillId(entity.getId());
        //无合同
        poolEntity.setType(2);
        poolEntity.setBillState(0);
        //其他
        CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("tax-invoice-type");
        Map<String,String> defMap =getDefMapName(defList.getData());
        String invoiceType = defMap.get("其他");
        if(StringUtils.isNotEmpty(invoiceType)){
            poolEntity.setInvoiceType(Long.valueOf(invoiceType));
            poolEntity.setInvoiceTypeName("其他");
        }else{
            throw new BusinessException("网络异常， 发票类型获取失败");
        }
        poolEntity.setInvoiceCode(getBillCode(configCodeDm));
        poolEntity.setInvoiceNumber(getBillCode(configCodeHm));
        poolEntity.setInvoiceDate(new Date());
        poolEntity.setInvoiceMny(ComputeUtil.nullToZero(entity.getCurrentReceiveMny()));
        poolEntity.setTaxMny(ComputeUtil.nullToZero(entity.getTaxMny()));
        poolEntity.setInvoiceTaxMny(ComputeUtil.nullToZero(ComputeUtil.safeAdd(poolEntity.getInvoiceMny(),poolEntity.getTaxMny())));
        //金额转中文大写
        //整数
        if(new BigDecimal(poolEntity.getInvoiceTaxMny().intValue()).compareTo(poolEntity.getInvoiceTaxMny())==0){
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString())+"整");
        }else{
            poolEntity.setInvoiceTaxMnys(ConvertUpMoney.toChinese(poolEntity.getInvoiceTaxMny().toString()));
        }

        poolEntity.setContractId(entity.getContractId());
        poolEntity.setContractCode(entity.getContractCode());
        poolEntity.setContractName(entity.getContractName());
        poolEntity.setSupplierId(entity.getSellerId());
        poolEntity.setSupplierName(entity.getSellerName());
        poolEntity.setSupplierCreditCode(entity.getSellerTaxNo());
        poolEntity.setCustomerId(entity.getBuyerId());
        poolEntity.setCustomerName(entity.getBuyerName());
        poolEntity.setCustomerCreditCode(entity.getBuyerTaxNo());
        poolEntity.setEmployeeId(entity.getProcessPersonId());
        poolEntity.setEmployeeName(entity.getProcessPersonName());
        poolEntity.setRegist(false);
        poolEntity.setBuyerBankAccount(entity.getBuyerBankAccount());
        poolEntity.setBuyerAddrPhone(entity.getBuyerAddrPhone());
        poolEntity.setSellerBankAccount(entity.getSellerBankAccount());
        poolEntity.setSellerAddrPhone(entity.getSellerAddrPhone());
        poolEntity.setAuthState(0);
        poolEntity.setDeductionState(0);
        poolEntity.setFlag(0);
        if(entity.getPurchaseType()!= null){
            poolEntity.setPurchaseType(String.valueOf(entity.getPurchaseType()));
        }
        if(entity.getDependOnProject()!= null){
            poolEntity.setDependOnProject(String.valueOf(entity.getDependOnProject()));
        }
        if(entity.getReceiveType() != null){
            poolEntity.setContractType(String.valueOf(entity.getReceiveType()));
        }
        if(poolEntity.getContractId()!= null ){
            poolEntity.setType(1);
        }else{
            poolEntity.setType(2);
        }
        poolEntity.setOrgId(entity.getOrgId());
        poolEntity.setOrgName(entity.getOrgName());
        poolEntity.setProjectId(entity.getProjectId());
        poolEntity.setProjectName(entity.getProjectName());

        List<InvoiceReceivePoolEntity> list = new ArrayList<>();
        list.add(poolEntity);
        return list;
    }

    /**
     * 获取billCode
     * @return
     */
    public String getBillCode(String code){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            return billCode.getData();
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    @Override
    public PSRMResponse saveOrUpdatePsrmObj(InvoiceReceiveRegistVO vo) {
         /*     请求参数
f_synccreator	string	益企联创建人（必填）
f_syncauditor	string	益企联审核人（必填）
f_synccode	string	益企联编码（必填）
f_billername	string	开票人姓名（可选）
f_paymenttypecode	string	付款条款编码（可选）
f_supplycode	string	供应商编码（必填）
f_engineeringcode	string	工程项目编码（必填）
f_databaseconfigcode	string	账套编码（必填）
f_currencycode	string	币别编码（必填）
f_exchangeratetypecode	string	汇率类型编码（必填）
f_address	string	地址（可选）
f_bank	string	开户银行（可选）
f_billno	string	发票号码（可选）
f_contractcode	string	合同编号（可选）
f_explanation	string	摘要（可选）
f_invoicetype	string	发票类型（可选）
f_issync	string	是否同步（可选）
f_potype	string	采购类别（可选）
f_postyle	string	采购方式（可选）
f_source	string	单据来源（可选）
f_taxnum	string	纳税登记号（可选）
f_synctime	string	同步时间（可选）
f_settledate	string	付款日期（可选）
f_date	string	业务日期（可选）



*/
        InvoiceReceivePoolVO invoiceReceivePoolVO = vo.getInvoiceReceiveList().get(0);

        String signDate = DateUtil.format(vo.getRegistDate(), DateUtil.DATE);
        JSONObject obj = new JSONObject();

        obj.put("f_synccode", vo.getCode());
        obj.put("f_status", "Y");
        obj.put("f_date", signDate);
        obj.put("f_billno", invoiceReceivePoolVO.getInvoiceNumber());

        Integer f_invoicetype = 1;
        Long invoiceType = invoiceReceivePoolVO.getInvoiceType();
        if (invoiceType.equals(1277537516768632833L)) {

        } else if (invoiceType.equals(1277537563879055362L)) {
            f_invoicetype = 2;
        } else {
            f_invoicetype = 3;
        }
        obj.put("f_invoicetype", f_invoicetype);
        //obj.put("f_settledate", signDate);
        try {
            if (vo.getSellerId() != null) {
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getSellerId()), "support-supplier");
                if (jArray != null && jArray.size() > 0) {
                    JSONObject json = (JSONObject) jArray.get(0);
                    obj.put("f_supplycode", json.getString("code"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getProjectId() != null) {
            JSONArray jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getProjectId()), "market-project");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject) jArray.get(0);
                obj.put("f_engineeringcode", json.getString("code"));
            }
        }
        obj.put("f_empname", vo.getProcessPersonName());
        obj.put("f_contractcode", vo.getContractCode());
        obj.put("f_synccreator", vo.getCreateUserName());
        UserContext userContext = sessionManager.getUserContext();
        obj.put("f_syncauditor", userContext.getUserName());

         /*
detail	array	明细
f_materialcode	string	物料编码（必填）
f_allamount	string	总金额（可选）
f_amount	string	金额（可选）
f_auxprice	string	辅助单价（可选）
f_auxpricediscount	string	辅助折扣单价（可选）
f_auxtaxprice	string	辅助含税单价（可选）
f_cess	string	税率（可选）
f_descount	string	折扣金额（可选）
f_qty	string	数量（可选）
f_seq	string	序号（可选）
f_spec	string	规格（可选）
f_stdallamount	string	标准总金额（可选）
f_stdamount	string	标准金额（可选）
f_taxamount	string	税额（可选）
f_taxrate	string	税率（可选）
f_unit	string	单位（可选）
f_auxpropname	string	辅助属性名称（可选）

*/


        List<JSONObject> detail = new ArrayList<>();
        Integer receiveType = vo.getReceiveType();
        if(4 == receiveType.intValue()){
            List<InvoiceReceiveRegistDetailVO> invoiceReceiveRegistDetailList = vo.getInvoiceReceiveRegistDetailList();
            for (InvoiceReceiveRegistDetailVO sub : invoiceReceiveRegistDetailList) {
                // 子表
                JSONObject subObj = new JSONObject();
                subObj.put("f_synentryid",sub.getId());
                subObj.put("f_materialcode", sub.getMaterialCode());
                subObj.put("f_spec", sub.getSpec());
                subObj.put("f_unit", sub.getMeasureUnit());
                subObj.put("f_qty", sub.getCount());
                subObj.put("f_auxtaxprice", sub.getUnitPrice());
                subObj.put("f_amount", sub.getTotalAmount());
                subObj.put("f_allamount", sub.getTotalAmount());
                subObj.put("f_note", sub.getMaterialRemark());
                subObj.put("f_sourcebillno", vo.getContractCode());
                subObj.put("f_contractsynId", sub.getMaterialContractDetailId());
                subObj.put("f_contractbillno", vo.getContractCode());
                subObj.put("f_cess", vo.getTaxRate());
                detail.add(subObj);
            }
        } else if (1 == receiveType.intValue()) {
            JSONObject subObj = new JSONObject();
            subObj.put("f_synentryid",vo.getId());
            subObj.put("f_materialcode", "99999995");
            subObj.put("f_qty", 1);
            subObj.put("f_auxtaxprice", vo.getCurrentReceiveMnyTax());
            subObj.put("f_allamount", vo.getCurrentReceiveMnyTax());
            subObj.put("f_amount", vo.getCurrentReceiveMnyTax());
            subObj.put("f_note", vo.getMemo());
            subObj.put("f_sourcebillno", vo.getContractCode());
            subObj.put("f_contractsynId", vo.getContractId());
            subObj.put("f_contractbillno", vo.getContractCode());
            subObj.put("f_cess", vo.getTaxRate());
            detail.add(subObj);
        }
        obj.put("detail", detail);
        return psrmRestUtil.postReq(obj, getSaveMethodName());
    }

    @Override
    public String getSaveMethodName() {
        return "dmp.purchaseinvoice.add";
    }


    @Override
    public String getUpdateMethodName() {
        return null;
    }
}
