/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.mapper.InvoiceOpenRegistMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceOpenPoolService")
public class InvoiceOpenPoolServiceImpl
extends BaseServiceImpl<InvoiceOpenPoolMapper, InvoiceOpenPoolEntity>
implements IInvoiceOpenPoolService {
    @Autowired
    private InvoiceOpenPoolMapper invoiceOpenPoolMapper;
    @Autowired
    private InvoiceOpenRegistMapper invoiceOpenRegistMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_POOL_CODE = "tax-open-pool-001";
    private static final String configCodeDm = "TAX_FPDM";
    private static final String configCodeHm = "TAX_FPHM";

    @Override
    public void deleteRegistId(Long registId) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"regist_id", (Object)registId);
        this.invoiceOpenPoolMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public List<InvoiceOpenPoolEntity> queryRegistById(Long registId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"regist_id", (Object)registId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        return this.invoiceOpenPoolMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<InvoiceOpenPoolVO> queryList(QueryWrapper<InvoiceOpenPoolEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InvoiceOpenPoolVO.class);
    }

    @Override
    public void deleteBatchRegistId(List<Long> registIds) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.in((Object)"regist_id", registIds);
        this.invoiceOpenPoolMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public void createSave(InvoiceOpenApplyEntity invoiceOpenApplyEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"apply_id", (Object)invoiceOpenApplyEntity.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List invoiceOpenRegistEntities = this.invoiceOpenRegistMapper.selectList((Wrapper)queryWrapper);
        System.out.println("================");
        System.out.println(invoiceOpenRegistEntities.size());
        if (invoiceOpenRegistEntities.size() == 1) {
            InvoiceOpenRegistEntity invoiceOpenRegistEntity = (InvoiceOpenRegistEntity)((Object)invoiceOpenRegistEntities.get(0));
            InvoiceOpenPoolEntity pool = new InvoiceOpenPoolEntity();
            pool.setOpenApplyType(1);
            pool.setApplyCode(invoiceOpenRegistEntity.getApplyCode());
            pool.setApplyId(invoiceOpenRegistEntity.getApplyId());
            pool.setApplyMnyTax(invoiceOpenRegistEntity.getApplyMnyTax());
            pool.setType(invoiceOpenRegistEntity.getHasContract());
            pool.setOpenApplyType(invoiceOpenRegistEntity.getRegistOpenType());
            pool.setContractId(invoiceOpenRegistEntity.getContractId());
            pool.setContractName(invoiceOpenRegistEntity.getContractName());
            pool.setCustomerId(invoiceOpenRegistEntity.getBuyerId());
            pool.setCustomerName(invoiceOpenRegistEntity.getBuyer());
            pool.setCustomerCreditCode(invoiceOpenRegistEntity.getBuyerTaxId());
            pool.setEmployeeId(invoiceOpenRegistEntity.getRegistUserId());
            pool.setEmployeeName(invoiceOpenRegistEntity.getRegistUserName());
            pool.setOrgId(invoiceOpenRegistEntity.getOrgId());
            pool.setOrgName(invoiceOpenRegistEntity.getOrgName());
            pool.setProjectId(invoiceOpenRegistEntity.getProjectId());
            pool.setProjectName(invoiceOpenRegistEntity.getProjectName());
            pool.setRegistId(invoiceOpenRegistEntity.getId());
            pool.setRegistCode(invoiceOpenRegistEntity.getCode());
            pool.setSupplierCreditCode(invoiceOpenRegistEntity.getSellerTaxCode());
            pool.setSupplierName(invoiceOpenRegistEntity.getSeller());
            pool.setSupplierId(invoiceOpenRegistEntity.getSellerId());
            pool.setType(invoiceOpenRegistEntity.getHasContract());
            pool.setMoneyTypeId(invoiceOpenRegistEntity.getMoneyTypeId());
            pool.setMoneyKindId(invoiceOpenRegistEntity.getMoneyKindId());
            pool.setMoneyKind(invoiceOpenRegistEntity.getMoneyKind());
            pool.setBuyerAddrPhone(invoiceOpenRegistEntity.getBuyerAddrPhone());
            pool.setBuyerBankAccount(invoiceOpenRegistEntity.getBuyerBankAccount());
            pool.setSellerAddrPhone(invoiceOpenRegistEntity.getSellerAddrPhone());
            pool.setSellerBankAccount(invoiceOpenRegistEntity.getSellerBankAccount());
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("tax-invoice-type");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            pool.setBillCode(this.getBillCode(BILL_POOL_CODE));
            pool.setInvoiceType(invoiceOpenApplyEntity.getInvoiceType());
            pool.setInvoiceTypeName(defMap.get(pool.getInvoiceType() + ""));
            pool.setRegist(0);
            pool.setInvoiceCode(this.getBillCode(configCodeDm));
            pool.setInvoiceNumber(this.getBillCode(configCodeHm));
            pool.setInvoiceDate(new Date());
            pool.setTaxMny(invoiceOpenApplyEntity.getTaxAmount() == null ? BigDecimal.ZERO : invoiceOpenApplyEntity.getTaxAmount());
            pool.setInvoiceTaxMny(invoiceOpenApplyEntity.getApplyMnyTax() == null ? BigDecimal.ZERO : invoiceOpenApplyEntity.getApplyMnyTax());
            pool.setInvoiceMny(pool.getInvoiceTaxMny().subtract(pool.getTaxMny()));
            pool.setInvoiceTaxMnyChn(invoiceOpenApplyEntity.getApplyMnyTaxChn());
            pool.setInvoiceContent(invoiceOpenApplyEntity.getInvoiceInfo());
            this.invoiceOpenPoolMapper.insert((Object)pool);
        }
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public String getBillCode(String code) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

