/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.tax.bean.InvoiceDetailEntity;
import com.ejianc.business.tax.service.IInvoiceDetailService;
import com.ejianc.business.tax.util.InvoiceUtil;
import com.ejianc.business.tax.vo.InvoiceDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invoiceDetail"})
public class InvoiceDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInvoiceDetailService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvoiceDetailVO> saveOrUpdate(@RequestBody InvoiceDetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        InvoiceDetailEntity entity = (InvoiceDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InvoiceDetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        InvoiceDetailVO vo = (InvoiceDetailVO)BeanMapper.map((Object)((Object)entity), InvoiceDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceDetailVO> queryDetail(Long id) {
        InvoiceDetailEntity entity = (InvoiceDetailEntity)((Object)this.service.selectById(id));
        InvoiceDetailVO vo = (InvoiceDetailVO)BeanMapper.map((Object)((Object)entity), InvoiceDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InvoiceDetailVO invoiceDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvoiceDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInvoiceDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvoiceDetailVO>> refInvoiceDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvoiceDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInvoice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryInvoice(String ids) {
        ArrayList<InvoiceDetailVO> successList = new ArrayList<InvoiceDetailVO>();
        ArrayList<InvoiceDetailVO> errorList = new ArrayList<InvoiceDetailVO>();
        InvoiceUtil invoiceUtil = new InvoiceUtil();
        String[] list = ids.split(",");
        String host = "https://open.cs.zbj.com";
        for (String id : list) {
            String path;
            InvoiceDetailVO purchaseSettlementInvoiceDetailVO = new InvoiceDetailVO();
            CommonResponse attachmentVOResponse = this.attachmentApi.queryDetail(id);
            AttachmentVO attachmentVO = (AttachmentVO)attachmentVOResponse.getData();
            String name = attachmentVO.getFileName();
            String type = name.substring(name.length() - 3);
            HashMap<String, String> bodys = new HashMap<String, String>();
            String leixing = "OCR";
            if (type.equals("pdf") || type.equals("PDF")) {
                leixing = "PDF";
                path = "/v2/invoice/pdf";
                String pdfurldown = attachmentVO.getTruePath();
                bodys.put("pdfBase64", "");
                bodys.put("pdfUrl", pdfurldown);
            } else {
                path = "/v2/invoice/ocr";
                String imgurl = attachmentVO.getTruePath();
                bodys.put("img", "");
                bodys.put("url", imgurl);
            }
            String results = "";
            try {
                results = invoiceUtil.doRequest(host + path, bodys);
            }
            catch (Exception e) {
                e.printStackTrace();
                purchaseSettlementInvoiceDetailVO.setErrorMessage(id + "\u8c03\u7528PDF\u8bc6\u522b\u63a5\u53e3\u5931\u8d25\uff01");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            JSONObject object = JSONObject.parseObject((String)results);
            String success = object.getString("success");
            if (!"true".equals(success)) {
                String description = object.getString("description") == null ? "\u65e0" : object.getString("description");
                purchaseSettlementInvoiceDetailVO.setErrorMessage(leixing + "\u8bc6\u522b\u5931\u8d25\uff01\u63cf\u8ff0\uff1a'" + description + "'");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            String code = object.getString("code");
            if ("1013".equals(code)) {
                String description = object.getString("description") == null ? "\u65e0" : object.getString("description");
                purchaseSettlementInvoiceDetailVO.setErrorMessage(leixing + "\u8bc6\u522b\u6210\u529f\u4f46\u67e5\u9a8c\u5931\u8d25\uff01\u63cf\u8ff0\uff1a'" + description + "'");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            JSONObject dataobject = JSONObject.parseObject((String)object.getString("data"));
            String fphm = dataobject.getString("fphm");
            QueryParam queryParammx = new QueryParam();
            queryParammx.getParams().put("invoice_number", new Parameter("eq", (Object)fphm));
            queryParammx.getParams().put("dr", new Parameter("eq", (Object)"0"));
            List Invoicelist = this.service.queryList(queryParammx);
            if (Invoicelist.size() > 1) {
                purchaseSettlementInvoiceDetailVO.setErrorMessage("\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728\u3002");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            purchaseSettlementInvoiceDetailVO.setAttid(attachmentVO.getId());
            purchaseSettlementInvoiceDetailVO.setInvoiceCode(dataobject.getString("fpdm"));
            purchaseSettlementInvoiceDetailVO.setInvoiceDate(dataobject.getDate("kprq"));
            purchaseSettlementInvoiceDetailVO.setTaxMny(dataobject.getBigDecimal("taxamount"));
            purchaseSettlementInvoiceDetailVO.setInvoiceNumber(fphm);
            purchaseSettlementInvoiceDetailVO.setInvoiceTaxMny(dataobject.getBigDecimal("sumamount"));
            purchaseSettlementInvoiceDetailVO.setInvoiceMny(purchaseSettlementInvoiceDetailVO.getInvoiceTaxMny().subtract(purchaseSettlementInvoiceDetailVO.getTaxMny()));
            if (dataobject.getString("fplx").equals("01") || dataobject.getString("fplx").equals("02") || dataobject.getString("fplx").equals("08") || dataobject.getString("fplx").equals("20")) {
                purchaseSettlementInvoiceDetailVO.setInvoiceType("1");
                purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968");
            } else if (dataobject.getString("fplx").equals("04") || dataobject.getString("fplx").equals("10") || dataobject.getString("fplx").equals("11") || dataobject.getString("fplx").equals("14") || dataobject.getString("fplx").equals("21")) {
                purchaseSettlementInvoiceDetailVO.setInvoiceType("2");
                purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
            } else {
                purchaseSettlementInvoiceDetailVO.setInvoiceType("3");
                purchaseSettlementInvoiceDetailVO.setInvoiceTypeName("\u5176\u4ed6");
            }
            if (Invoicelist.size() > 0) {
                purchaseSettlementInvoiceDetailVO.setErrorMessage(fphm + "\uff0c\u8be5\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728\uff01");
                errorList.add(purchaseSettlementInvoiceDetailVO);
                continue;
            }
            successList.add(purchaseSettlementInvoiceDetailVO);
        }
        new TaxCalculateUtil().calculate(successList);
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

