/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractInvoiceReceiveApi;
import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveSettleEntity;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.util.NCUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceReceive")
public class InvoiceReceiveBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private ISubContractInvoiceReceiveApi subContractInvoiceReceiveApi;
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IMaterialSettlementApi materialSettlementApi;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("invoiceNumber", new Parameter("eq", (Object)entity.getInvoiceNumber()));
        List list = this.invoiceReceiveService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity entity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("invoiceNumber", new Parameter("eq", (Object)entity.getInvoiceNumber()));
        List list = this.invoiceReceiveService.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u53d1\u7968\u53f7\u7801\u5df2\u5b58\u5728!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(invoiceReceiveEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNcAr(invoiceReceiveEntity);
        }
        if (null != invoiceReceiveEntity.getContractId()) {
            CommonResponse stringCommonResponse;
            if (invoiceReceiveEntity.getContractType().equals("1") && !(stringCommonResponse = this.subContractInvoiceReceiveApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("2") && !(stringCommonResponse = this.equipmentContractApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("3") && !(stringCommonResponse = this.equipmentContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199-\u7269\u8d44\u91c7\u8d2d--- billId:" + billId + "  state:" + state);
                List<InvoiceReceiveSettleEntity> settleDetails = invoiceReceiveEntity.getSettleDetails();
                ArrayList settleList = new ArrayList();
                for (InvoiceReceiveSettleEntity settleEntity : settleDetails) {
                    TreeMap<String, String> settle = new TreeMap<String, String>();
                    settle.put("settleId", String.valueOf(settleEntity.getSettleId()));
                    settle.put("settleCode", settleEntity.getSettleCode());
                    settle.put("sumVerifyMny", String.valueOf(settleEntity.getSumVerifyMny()));
                    settle.put("sumVerifyTaxMny", String.valueOf(settleEntity.getSumVerifyTaxMny()));
                    settleList.add(settle);
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("5") && !(stringCommonResponse = this.rmatContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("6") && !(stringCommonResponse = this.otherContractApi.otherAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceReceiveEntity invoiceReceiveEntity = (InvoiceReceiveEntity)((Object)this.invoiceReceiveService.selectById(billId));
        if (StringUtils.isNotEmpty((CharSequence)invoiceReceiveEntity.getSourceId())) {
            String[] split;
            for (String sourceId : split = invoiceReceiveEntity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deleteapbill");
                json.put("pk_bill", (Object)sourceId);
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(InvoiceReceiveEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.invoiceReceiveService.update((Wrapper)wrapper);
        }
        if (null != invoiceReceiveEntity.getContractId()) {
            CommonResponse jsonObjectCommonResponse;
            if (invoiceReceiveEntity.getContractType().equals("1") && !(jsonObjectCommonResponse = this.subContractInvoiceReceiveApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("2") && !(jsonObjectCommonResponse = this.equipmentContractApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("3") && !(jsonObjectCommonResponse = this.equipmentContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("4")) {
                this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199-\u7269\u8d44\u91c7\u8d2d--- billId:" + billId + "  state:" + state);
                List<InvoiceReceiveSettleEntity> settleDetails = invoiceReceiveEntity.getSettleDetails();
                ArrayList settleList = new ArrayList();
                for (InvoiceReceiveSettleEntity settleEntity : settleDetails) {
                    TreeMap<String, String> settle = new TreeMap<String, String>();
                    settle.put("settleId", String.valueOf(settleEntity.getSettleId()));
                    settle.put("settleCode", settleEntity.getSettleCode());
                    settle.put("alreadyVerifyMny", String.valueOf(settleEntity.getAlreadyVerifyMny()));
                    settle.put("alreadyVerifyTaxMny", String.valueOf(settleEntity.getAlreadyVerifyTaxMny()));
                    settleList.add(settle);
                }
            }
            if (invoiceReceiveEntity.getContractType().equals("5") && !(jsonObjectCommonResponse = this.rmatContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
            if (invoiceReceiveEntity.getContractType().equals("6") && !(jsonObjectCommonResponse = this.otherContractApi.otherAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), invoiceReceiveEntity.getInvoiceMny(), invoiceReceiveEntity.getInvoiceTaxMny())).isSuccess()) {
                return CommonResponse.error((String)"\u64a4\u56de\u56de\u5199\u5f02\u5e38!");
            }
        }
        return CommonResponse.success();
    }

    private void pushToNcAr(InvoiceReceiveEntity invoiceReceiveEntity) {
        ApBillVO apNcVo = this.transferToNCVO(invoiceReceiveEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(invoiceReceiveEntity.getProjectId())).get(0);
        List<Long> orgIds = this.ncUtil.validateInvoiceMainOrg(project.getOrgId(), project.getMainOrgId());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            apNcVo.setPk_org(this.ncUtil.queryOrgById(orgId).getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)apNcVo).toString());
            sourceIds = sourceIds + sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(InvoiceReceiveEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)invoiceReceiveEntity.getId());
        this.invoiceReceiveService.update((Wrapper)wrapper);
    }

    private ApBillVO transferToNCVO(InvoiceReceiveEntity entity) {
        this.logger.info("----\u6536\u7968\u767b\u8bb0\u5e94\u4ed8\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ApBillVO ncVo = new ApBillVO();
        ncVo.setBusitype("apbill");
        ncVo.setTradetype("F1-Cxx-004");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ncVo.setPk_project(String.valueOf(entity.getProjectId()));
        ncVo.setDef1(Boolean.valueOf(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate()));
        ncVo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        ncVo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ncVo.setDef5(project.getAreaCode());
        ncVo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        SupplierVO supplierVO = this.ncUtil.querySupplierById(entity.getSupplierId());
        ncVo.setSupname(supplierVO.getName());
        ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());
        ncVo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        ncVo.setPk_dept(String.valueOf(project.getDeptId()));
        ncVo.setDef12(String.valueOf(entity.getId()));
        ncVo.setDef19(entity.getBillCode());
        ncVo.setDef20(this.ncUtil.getWebSite("ejc-tax-frontend/#/invoiceReceive/card?id=" + entity.getId()));
        ncVo.setDef21("BT200606000000001");
        if (entity.getType() == 1) {
            JSONObject object;
            if ("1".equals(entity.getContractType())) {
                object = this.ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200529000000001");
                ncVo.setDef7(this.ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("2".equals(entity.getContractType())) {
                object = this.ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200528000000001");
                ncVo.setDef7(this.ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("3".equals(entity.getContractType())) {
                object = this.ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200528000000003");
                ncVo.setDef7(this.ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("4".equals(entity.getContractType())) {
                object = this.ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT200608000000001");
                ncVo.setDef7(this.ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("5".equals(entity.getContractType())) {
                object = this.ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT210615000000001");
                ncVo.setDef7(this.ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
            if ("6".equals(entity.getContractType())) {
                object = this.ncUtil.queryBillDetail(String.valueOf(entity.getContractId()), "BT210916000000001");
                ncVo.setDef7(this.ncUtil.getTaxRateDefCode(object.getBigDecimal("taxRate")));
            }
        }
        if (entity.getType() == 2) {
            ncVo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        }
        ArrayList<ApBillDetailVO> detailVOS = new ArrayList<ApBillDetailVO>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getInvoiceMny());
        detailVO.setLocal_mny(entity.getInvoiceTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        ncVo.setDetail(detailVOS);
        return ncVo;
    }
}

