package com.ejianc.business.taxnew.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 抵扣申请单子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_deduction_apply_sub")
public class InvoiceDeducApplySubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 申请单编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="invoice_code")
    private String invoiceCode; // 发票代码
    @TableField(value="invoice_number")
    private String invoiceNumber; // 发票号码
    @TableField(value="invoice_date")
    private java.util.Date invoiceDate; // 开票日期
    @TableField(value="deduc_date")
    private java.util.Date deducDate; // 抵扣日期
    @TableField(value="invoice_mny")
    private java.math.BigDecimal invoiceMny; // 发票金额（不含税）
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税额
    @TableField(value="invoice_tax_mny")
    private java.math.BigDecimal invoiceTaxMny; // 价税合计
    @TableField(value="content")
    private String content; // 发票内容
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="actual_deduc_mny")
    private java.math.BigDecimal actualDeducMny; // 实际抵扣金额
    @TableField(value="actual_deduc_tax_mny")
    private java.math.BigDecimal actualDeducTaxMny; // 实际抵扣税额
    @TableField(value="can_deduc")
    private String canDeduc; // 是否可抵扣:汉字是、否
    @TableField(value="pid")
    private Long pid; // 主表申请单id
    @TableField(value="invoice_id")
    private Long invoiceId; // 进项发票表id
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="already_deduc")
    private Boolean alreadyDeduc; // 是否完成抵扣（抵扣单审批通过）
    @TableField(value="invoice_type")
    private Long invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    @TableField(value="supplier_name")
    private String supplierName; // 销方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 销方主键
    

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 发票代码
     */
    public String getInvoiceCode() {
        return invoiceCode;
    }

    /**
     * 发票代码
     */
    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    /**
     * 发票号码
     */
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    /**
     * 发票号码
     */
    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    /**
     * 开票日期
     */
    public java.util.Date getInvoiceDate() {
        return invoiceDate;
    }

    /**
     * 开票日期
     */
    public void setInvoiceDate(java.util.Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    /**
     * 发票金额（不含税）
     */
    public java.math.BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    /**
     * 发票金额（不含税）
     */
    public void setInvoiceMny(java.math.BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 价税合计
     */
    public java.math.BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    /**
     * 价税合计
     */
    public void setInvoiceTaxMny(java.math.BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }
    /**
     * 发票内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 发票内容
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 实际抵扣金额
     */
    public java.math.BigDecimal getActualDeducMny() {
        return actualDeducMny;
    }

    /**
     * 实际抵扣金额
     */
    public void setActualDeducMny(java.math.BigDecimal actualDeducMny) {
        this.actualDeducMny = actualDeducMny;
    }
    /**
     * 实际抵扣税额
     */
    public java.math.BigDecimal getActualDeducTaxMny() {
        return actualDeducTaxMny;
    }

    /**
     * 实际抵扣税额
     */
    public void setActualDeducTaxMny(java.math.BigDecimal actualDeducTaxMny) {
        this.actualDeducTaxMny = actualDeducTaxMny;
    }
    /**
     * 是否可抵扣:汉字是、否
     */
    public String getCanDeduc() {
        return canDeduc;
    }

    /**
     * 是否可抵扣:汉字是、否
     */
    public void setCanDeduc(String canDeduc) {
        this.canDeduc = canDeduc;
    }
    /**
     * 主表申请单id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表申请单id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Boolean getAlreadyDeduc() {
        return alreadyDeduc;
    }

    public void setAlreadyDeduc(Boolean alreadyDeduc) {
        this.alreadyDeduc = alreadyDeduc;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getDeducDate() {
        return deducDate;
    }

    public void setDeducDate(Date deducDate) {
        this.deducDate = deducDate;
    }

    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
