package com.ejianc.business.techmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 施工方案
 * 
 * @author generator
 * 
 */
public class ConstructionSchemeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编码
    private Integer billState; // 单据状态
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父组织ID
    private String parentOrgName; // 父组织名称
    private String parentOrgCode; // 父组织编码
    private Long buildUnitId; // 二级单位ID
    private String buildUnitName; // 二级单位
    private Long engineeringTypeId; // 工程类型ID
    private String engineeringType; // 工程类型
    private String measure; // 工程规模

    private Long schemeId; // 方案ID
    private String schemeName; // 方案名称
    private String schemeCode; // 方案编码
    private String schemeCodePlan; // 方案分类
    private String schemeCodeNum; // 方案版本号
    private String schemeParentId; // 方案上级ID

    private Long employeeId; // 经办人ID
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门ID
    private String departmentName; // 经办部门
    private String memo; // 备注
    private Long disclosureId; // 交底ID
    private Integer disclosureState; // 交底状态 0：未交底 1：已交底
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disclosureTime; // 交底日期
    private String disclosureContent; // 交底内容及结果说明
    private String billStateName; // 单据状态
    private String disclosureStateName; // 交底状态 0：未交底 1：已交底
    private Integer disclosureType; // 交底单据类型 1：方案交底 2：质量技术交底 3：安全技术交底

    public Integer getDisclosureType() {
        return disclosureType;
    }

    public void setDisclosureType(Integer disclosureType) {
        this.disclosureType = disclosureType;
    }

    public String getSchemeCodeNum() {
        return schemeCodeNum;
    }

    public void setSchemeCodeNum(String schemeCodeNum) {
        this.schemeCodeNum = schemeCodeNum;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDisclosureStateName() {
        return disclosureStateName;
    }

    public void setDisclosureStateName(String disclosureStateName) {
        this.disclosureStateName = disclosureStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getBuildUnitId() {
        return buildUnitId;
    }

    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }
    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }
    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    @ReferSerialTransfer(referCode = "zhht-scheme")
    public Long getSchemeId() {
        return schemeId;
    }
    @ReferDeserialTransfer
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    public String getSchemeCode() {
        return schemeCode;
    }

    public void setSchemeCode(String schemeCode) {
        this.schemeCode = schemeCode;
    }
    public String getSchemeCodePlan() {
        return schemeCodePlan;
    }

    public void setSchemeCodePlan(String schemeCodePlan) {
        this.schemeCodePlan = schemeCodePlan;
    }
    public String getSchemeParentId() {
        return schemeParentId;
    }

    public void setSchemeParentId(String schemeParentId) {
        this.schemeParentId = schemeParentId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getDisclosureId() {
        return disclosureId;
    }

    public void setDisclosureId(Long disclosureId) {
        this.disclosureId = disclosureId;
    }
    public Integer getDisclosureState() {
        return disclosureState;
    }

    public void setDisclosureState(Integer disclosureState) {
        this.disclosureState = disclosureState;
    }
    public Date getDisclosureTime() {
        return disclosureTime;
    }

    public void setDisclosureTime(Date disclosureTime) {
        this.disclosureTime = disclosureTime;
    }
    public String getDisclosureContent() {
        return disclosureContent;
    }

    public void setDisclosureContent(String disclosureContent) {
        this.disclosureContent = disclosureContent;
    }
    
}
