package com.ejianc.business.techmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.techmanagement.vo.DesignChangeDisclosureContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 设计变更交底
 * 
 * @author generator
 * 
 */
public class DesignChangeDisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 编码
    private Integer billState; // 单据状态
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String secondaryUnits; // 二级单位
    private String projectType; // 工程类型
    private String projectScale; // 工程规模
    private Long designChangeId; // 设计变更ID
    private String designChangeName; // 设计变更名称
    private String designChangeCode; // 设计变更编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disclosureTime; // 交底日期
    private Long disclosureId; // 交底人ID
    private String disclosureName; // 交底人名称
    private String disclosureCode; // 交底人编码
    private Long witnessId; // 见证人ID
    private String witnessName; // 见证人名称
    private String witnessCode; // 见证人编码
    private String disclosurePlace; // 交底部位
    private String disclosureContent; // 交底内容及结果说明
    private List<DesignChangeDisclosureContentVO> designChangeDisclosureContentList = new ArrayList<>(); // 设计变更交底子表

    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private String orgCode; // 组织编码

    private String billStateName; // 单据状态名称

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondaryUnits() {
        return secondaryUnits;
    }

    public void setSecondaryUnits(String secondaryUnits) {
        this.secondaryUnits = secondaryUnits;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }
    @ReferSerialTransfer(referCode="design_change")
    public Long getDesignChangeId() {
        return designChangeId;
    }
    @ReferDeserialTransfer
    public void setDesignChangeId(Long designChangeId) {
        this.designChangeId = designChangeId;
    }
    public String getDesignChangeName() {
        return designChangeName;
    }

    public void setDesignChangeName(String designChangeName) {
        this.designChangeName = designChangeName;
    }
    public String getDesignChangeCode() {
        return designChangeCode;
    }

    public void setDesignChangeCode(String designChangeCode) {
        this.designChangeCode = designChangeCode;
    }
    public Date getDisclosureTime() {
        return disclosureTime;
    }

    public void setDisclosureTime(Date disclosureTime) {
        this.disclosureTime = disclosureTime;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDisclosureId() {
        return disclosureId;
    }
    @ReferDeserialTransfer
    public void setDisclosureId(Long disclosureId) {
        this.disclosureId = disclosureId;
    }
    public String getDisclosureName() {
        return disclosureName;
    }

    public void setDisclosureName(String disclosureName) {
        this.disclosureName = disclosureName;
    }
    public String getDisclosureCode() {
        return disclosureCode;
    }

    public void setDisclosureCode(String disclosureCode) {
        this.disclosureCode = disclosureCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getWitnessId() {
        return witnessId;
    }
    @ReferDeserialTransfer
    public void setWitnessId(Long witnessId) {
        this.witnessId = witnessId;
    }
    public String getWitnessName() {
        return witnessName;
    }

    public void setWitnessName(String witnessName) {
        this.witnessName = witnessName;
    }
    public String getWitnessCode() {
        return witnessCode;
    }

    public void setWitnessCode(String witnessCode) {
        this.witnessCode = witnessCode;
    }
    public String getDisclosurePlace() {
        return disclosurePlace;
    }

    public void setDisclosurePlace(String disclosurePlace) {
        this.disclosurePlace = disclosurePlace;
    }
    public String getDisclosureContent() {
        return disclosureContent;
    }

    public void setDisclosureContent(String disclosureContent) {
        this.disclosureContent = disclosureContent;
    }
    
     public List<DesignChangeDisclosureContentVO> getDesignChangeDisclosureContentList() {
        return designChangeDisclosureContentList;
     }

     public void setDesignChangeDisclosureContentList(List<DesignChangeDisclosureContentVO> designChangeDisclosureContentList) {
        this.designChangeDisclosureContentList = designChangeDisclosureContentList;
     }
}
