package com.ejianc.business.techmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.techmanagement.vo.DrawingTriageContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 图纸会审
 * 
 * @author generator
 * 
 */
public class DrawingTriageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private Integer billState; // 单据状态
    private String projectName; // 项目名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编号
    private String unitName; // 二级单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date triageDate; // 会审日期
    private String triageName; // 会审名称
    private String departmentName; // 经办部门
    private String memo; // 会审情况说明
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人
    private String operatorCode; // 经办人编码
    private String billStateName; // 单据状态名称
    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private String orgCode; // 组织编码

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    private List<DrawingTriageContentVO> drawingTriageContentList = new ArrayList<>(); // 图纸会审子表

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Date getTriageDate() {
        return triageDate;
    }

    public void setTriageDate(Date triageDate) {
        this.triageDate = triageDate;
    }
    public String getTriageName() {
        return triageName;
    }

    public void setTriageName(String triageName) {
        this.triageName = triageName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getOperatorId() {
        return operatorId;
    }
    @ReferDeserialTransfer  
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    
     public List<DrawingTriageContentVO> getDrawingTriageContentList() {
        return drawingTriageContentList;
     }

     public void setDrawingTriageContentList(List<DrawingTriageContentVO> drawingTriageContentList) {
        this.drawingTriageContentList = drawingTriageContentList;
     }
}
