package com.ejianc.business.techmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.techmanagement.vo.ReviewPointsContentVO;

/**
 * 技术复核点编制 
 * 
 * @author generator
 * 
 */
public class TechnicalReviewPointsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String parentOrgName;
    private String parentOrgCode;
    private Long parentOrgId;
    private String orgCode;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String projectName; // 项目名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编号
    private String unitName; // 二级单位
    private Long unitId;
    private Long engineeringId;
    private String projectType; // 工程类型
    private String projectScale; // 工程规模
    private Long employeeId; // 经办人ID
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门ID
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Long orgId;
    private String orgName;
    private List<ReviewPointsContentVO> reviewPointsContentList = new ArrayList<>(); // 技术复核点编制子表

    private List<TechnologyReviewVO> technologyList=new ArrayList<>(); //复核情况

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
//    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
//    @ReferDeserialTransfer
    public void setOrgId(Long ordId) {
        this.orgId = ordId;
    }


    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEngineeringId() {
        return engineeringId;
    }

    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }

    public List<ReviewPointsContentVO> getReviewPointsContentList() {
        return reviewPointsContentList;
     }

     public void setReviewPointsContentList(List<ReviewPointsContentVO> reviewPointsContentList) {
        this.reviewPointsContentList = reviewPointsContentList;
     }

    public List<TechnologyReviewVO> getTechnologyList() {
        return technologyList;
    }

    public void setTechnologyList(List<TechnologyReviewVO> technologyList) {
        this.technologyList = technologyList;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
