package com.ejianc.business.techmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.techmanagement.vo.SafetyDisclosureContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分项工程安全技术交底
 * 
 * @author generator
 * 
 */
public class SafetyDisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 编码
    private Integer billState; // 单据状态
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 父组织ID
    private String parentOrgName; // 父组织名称
    private String parentOrgCode; // 父组织编码
    private String secondaryUnits; // 二级单位
    private String projectType; // 工程类型
    private String measure; // 工程规模
    private Long subProjectsId; // 分项工程ID
    private String subProjectsCode; // 分项工程编码
    private String subProjectsName; // 分项工程名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disclosureTime; // 交底日期
    private Long schemeId; // 方案ID
    private String schemeName; // 方案名称
    private String schemeCode; // 方案编码
    private String employeeId; // 交底人ID
    private String employeeName; // 交底人名称
    private String employeeCode; // 交底人编码
    private Long witnessId; // 见证人ID
    private String witnessName; // 见证人名称
    private String witnessCode; // 见证人编码
    private String memo; // 交底内容及结果说明

    private String billStateName; // 单据状态名称

    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public String getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(String employeeID) {
        this.employeeId = employeeID;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    private List<SafetyDisclosureContentVO> safetyDisclosureContentList = new ArrayList<>(); // 分项工程安全技术交底子表

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getSecondaryUnits() {
        return secondaryUnits;
    }

    public void setSecondaryUnits(String secondaryUnits) {
        this.secondaryUnits = secondaryUnits;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode="subject-project-wbs-ref")
    public Long getSubProjectsId() {
        return subProjectsId;
    }
    @ReferDeserialTransfer
    public void setSubProjectsId(Long subProjectsId) {
        this.subProjectsId = subProjectsId;
    }
    public String getSubProjectsCode() {
        return subProjectsCode;
    }

    public void setSubProjectsCode(String subProjectsCode) {
        this.subProjectsCode = subProjectsCode;
    }
    public String getSubProjectsName() {
        return subProjectsName;
    }

    public void setSubProjectsName(String subProjectsName) {
        this.subProjectsName = subProjectsName;
    }

    public Date getDisclosureTime() {
        return disclosureTime;
    }

    public void setDisclosureTime(Date disclosureTime) {
        this.disclosureTime = disclosureTime;
    }
    @ReferSerialTransfer(referCode="construction-scheme")
    public Long getSchemeId() {
        return schemeId;
    }
    @ReferDeserialTransfer
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    public String getSchemeCode() {
        return schemeCode;
    }

    public void setSchemeCode(String schemeCode) {
        this.schemeCode = schemeCode;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getWitnessId() {
        return witnessId;
    }
    @ReferDeserialTransfer
    public void setWitnessId(Long witnessId) {
        this.witnessId = witnessId;
    }
    public String getWitnessName() {
        return witnessName;
    }

    public void setWitnessName(String witnessName) {
        this.witnessName = witnessName;
    }
    public String getWitnessCode() {
        return witnessCode;
    }

    public void setWitnessCode(String witnessCode) {
        this.witnessCode = witnessCode;
    }
    
     public List<SafetyDisclosureContentVO> getSafetyDisclosureContentList() {
        return safetyDisclosureContentList;
     }

     public void setSafetyDisclosureContentList(List<SafetyDisclosureContentVO> safetyDisclosureContentList) {
        this.safetyDisclosureContentList = safetyDisclosureContentList;
     }
}
