package com.ejianc.business.techmanagement.service.impl;

import com.ejianc.business.techmanagement.vo.SchemeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.techmanagement.mapper.SchemeMapper;
import com.ejianc.business.techmanagement.bean.SchemeEntity;
import com.ejianc.business.techmanagement.service.ISchemeService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 方案字典
 * 
 * @author generator
 * 
 */
@Service("schemeService")
public class SchemeServiceImpl extends BaseServiceImpl<SchemeMapper, SchemeEntity> implements ISchemeService{

    @Override
    public List<SchemeEntity> queryByCode(String code, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        if (null != id){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SchemeEntity> entityList = super.queryList(queryParam);
        if(entityList != null && entityList.size() > 0) {
            return entityList;
        }
        return null;
    }

    @Override
    public List<SchemeVO> queryListByPid(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parent_id", new Parameter(QueryParam.EQ, id));
        List<SchemeEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return BeanMapper.mapList(entityList, SchemeVO.class);
        }
        return null;
    }

    @Override
    public List<SchemeEntity> querySchemeList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<String, Object>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SchemeEntity> resultList = baseMapper.querySchemeList(condition);
        return resultList;
    }

    @Override
    public List<SchemeVO> queryListEntityTree(Map<String, Object> params) {
        return baseMapper.queryListEntityTree(params);
    }
}
