/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.techmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.techmanagement.bean.TecRegisterContentEntity;
import com.ejianc.business.techmanagement.bean.TecRegisterEntity;
import com.ejianc.business.techmanagement.bean.TecTrackContentEntity;
import com.ejianc.business.techmanagement.bean.TecTrackEntity;
import com.ejianc.business.techmanagement.service.ITecRegisterContentService;
import com.ejianc.business.techmanagement.service.ITecRegisterService;
import com.ejianc.business.techmanagement.service.ITecTrackContentService;
import com.ejianc.business.techmanagement.service.ITecTrackService;
import com.ejianc.business.techmanagement.vo.TecRegisterContentVO;
import com.ejianc.business.techmanagement.vo.TecRegisterVO;
import com.ejianc.business.techmanagement.vo.TecTrackContentVO;
import com.ejianc.business.techmanagement.vo.TecTrackVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tecRegister"})
public class TecRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITecTrackService tecTrackService;
    @Autowired
    private ITecTrackContentService tecTrackContentService;
    @Autowired
    private ITecRegisterContentService tecRegisterContentService;
    private static final String BILL_CODE = "NEW-TECHNOLOGY-REGISTER";
    @Autowired
    private ITecRegisterService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TecRegisterVO> saveOrUpdate(@RequestBody TecRegisterVO saveOrUpdateVO) {
        TecRegisterEntity entity;
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            CommonResponse<TecRegisterVO> error = this.getCommonResponse(saveOrUpdateVO);
            if (error != null) {
                return error;
            }
        } else {
            CommonResponse<TecRegisterVO> error;
            Long id = saveOrUpdateVO.getId();
            TecRegisterEntity tecRegisterEntity = (TecRegisterEntity)((Object)this.service.selectById(id));
            if (!tecRegisterEntity.getProjectId().equals(saveOrUpdateVO.getProjectId()) && (error = this.getCommonResponse(saveOrUpdateVO)) != null) {
                return error;
            }
        }
        if ((entity = (TecRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TecRegisterEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.getTecRegisterContentList().forEach(tecRegisterContentEntity -> tecRegisterContentEntity.setCode((String)billCode.getData()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TecRegisterVO vo = (TecRegisterVO)BeanMapper.map((Object)((Object)entity), TecRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private CommonResponse<TecRegisterVO> getCommonResponse(TecRegisterVO saveOrUpdateVO) {
        Long projectId = saveOrUpdateVO.getProjectId();
        if (projectId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TecRegisterEntity::getProjectId, (Object)projectId);
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            int count = this.service.count((Wrapper)queryWrapper);
            if (count > 0) {
                return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u65b0\u6280\u672f\u767b\u8bb0\u5355\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e\uff01");
            }
        }
        return null;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TecRegisterVO> queryDetail(Long id) {
        TecRegisterEntity entity = (TecRegisterEntity)((Object)this.service.selectById(id));
        TecRegisterVO vo = (TecRegisterVO)BeanMapper.map((Object)((Object)entity), TecRegisterVO.class);
        Integer billState = entity.getBillState();
        BillStateEnum enumByStateCode = BillStateEnum.getEnumByStateCode((Integer)billState);
        if (enumByStateCode != BillStateEnum.COMMITED_STATE && enumByStateCode != BillStateEnum.PASSED_STATE) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        Long projectId = entity.getProjectId();
        if (projectId == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TecTrackEntity::getProjectId, (Object)projectId);
        queryWrapper.in(TecTrackEntity::getBillState, Arrays.asList(1, 3));
        queryWrapper.orderByDesc((Object[])new SFunction[]{TecTrackEntity::getTrackDate, BaseEntity::getCreateTime});
        List list = this.tecTrackService.list((Wrapper)queryWrapper);
        List tecTrackVOS = BeanMapper.mapList((Iterable)list, TecTrackVO.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        vo.setReviewStatus(tecTrackVOS);
        List<TecRegisterContentEntity> tecRegisterContentList = entity.getTecRegisterContentList();
        if (CollectionUtils.isEmpty(tecRegisterContentList)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        List trackIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List ids = tecRegisterContentList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(TecTrackContentEntity::getRegisterContentId, ids);
        wrapper.in(TecTrackContentEntity::getTecTrackId, trackIds);
        wrapper.eq(TecTrackContentEntity::getRegisterId, (Object)entity.getId());
        List tecTrackContentEntities = this.tecTrackContentService.list((Wrapper)wrapper);
        List tecTrackContentVOS = BeanMapper.mapList((Iterable)tecTrackContentEntities, TecTrackContentVO.class);
        HashMap<Long, TecTrackContentVO> map = new HashMap<Long, TecTrackContentVO>();
        HashMap score = new HashMap();
        for (int i = 0; i < trackIds.size(); ++i) {
            score.put(trackIds.get(i), i);
        }
        for (TecTrackContentVO tecTrackContentVO : tecTrackContentVOS) {
            Long registerContentId = tecTrackContentVO.getRegisterContentId();
            Long tecTrackId = tecTrackContentVO.getTecTrackId();
            if (!map.containsKey(registerContentId)) {
                map.put(registerContentId, tecTrackContentVO);
                continue;
            }
            TecTrackContentVO tecTrackContentVO1 = (TecTrackContentVO)map.get(registerContentId);
            if ((Integer)score.get(tecTrackId) >= (Integer)score.get(tecTrackContentVO1.getTecTrackId())) continue;
            map.put(registerContentId, tecTrackContentVO);
        }
        List tecRegisterContentVOS = BeanMapper.mapList(tecRegisterContentList, TecRegisterContentVO.class);
        for (TecRegisterContentVO tecRegisterContentVO : tecRegisterContentVOS) {
            Long registerContentId = tecRegisterContentVO.getId();
            if (!map.containsKey(registerContentId)) continue;
            TecTrackContentVO tecTrackContentVO = (TecTrackContentVO)map.get(registerContentId);
            tecRegisterContentVO.setReviewResult(tecTrackContentVO.getApplySituation());
        }
        vo.setTecRegisterContentList(tecRegisterContentVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TecRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TecRegisterVO tecRegisterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TecRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "unitName", "employeeName", "departmentName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        List records = page.getRecords();
        List tecRegisterVOS = BeanMapper.mapList((Iterable)records, TecRegisterVO.class);
        this.extracted(records, tecRegisterVOS);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(tecRegisterVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void extracted(List<TecRegisterEntity> records, List<TecRegisterVO> tecRegisterVOS) {
        List ids = records.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TecRegisterContentEntity::getTecRegisterId, ids);
        List list = this.tecRegisterContentService.list((Wrapper)queryWrapper);
        Map<Long, List<TecRegisterContentEntity>> resultMap = list.stream().collect(Collectors.groupingBy(TecRegisterContentEntity::getTecRegisterId));
        tecRegisterVOS.forEach(tecRegisterVO -> {
            Long id = tecRegisterVO.getId();
            if (resultMap.containsKey(id)) {
                List tecRegisterContentEntities = (List)resultMap.get(id);
                tecRegisterContentEntities.forEach(tecRegisterContentEntity -> {
                    String tecName = tecRegisterContentEntity.getTecName();
                    if (StringUtils.isNotEmpty((CharSequence)tecName)) {
                        if (StringUtils.isEmpty((CharSequence)tecRegisterVO.getNewTecnologyName())) {
                            tecRegisterVO.setNewTecnologyName(tecName);
                        } else {
                            tecRegisterVO.setNewTecnologyName(tecRegisterVO.getNewTecnologyName() + "," + tecName);
                        }
                    }
                });
            }
        });
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "unitName", "employeeName", "departmentName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List tecRegisterVOS = BeanMapper.mapList((Iterable)list, TecRegisterVO.class);
        this.extracted(list, tecRegisterVOS);
        tecRegisterVOS.forEach(item -> {
            Integer billState = item.getBillState();
            String description = BillStateEnum.getEnumByStateCode((Integer)billState).getDescription();
            item.setBillStateName(description);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", tecRegisterVOS);
        ExcelExport.getInstance().export("TecRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTecRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TecRegisterVO>> refTecRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TecRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

