package com.ejianc.business.techmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.techmanagement.bean.DrawingTriageContentEntity;
/**
 * 图纸会审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tec_drawing_triage")
public class DrawingTriageEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="unit_name")
    private String unitName; // 二级单位
    @TableField(value="triage_date")
    private Date triageDate; // 会审日期
    @TableField(value="triage_name")
    private String triageName; // 会审名称
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value="memo")
    private String memo; // 会审情况说明
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人
    @TableField(value="operator_code")
    private String operatorCode; // 经办人编码

    @TableField(value="org_id")

    private Long orgId; // 组织ID

    @TableField(value="org_name")
    private String orgName; // 组织名称

    @TableField(value="org_code")
    private String orgCode; // 组织编码

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @TableField(exist=false)
    @SubEntity(serviceName="drawingTriageContentService" ,pidName = "pid")
    private List<DrawingTriageContentEntity> drawingTriageContentList = new ArrayList<>(); // 图纸会审子表
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父组织编码

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Date getTriageDate() {
        return triageDate;
    }

    public void setTriageDate(Date triageDate) {
        this.triageDate = triageDate;
    }
    public String getTriageName() {
        return triageName;
    }

    public void setTriageName(String triageName) {
        this.triageName = triageName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    

    public List<DrawingTriageContentEntity> getDrawingTriageContentList() {
        return drawingTriageContentList;
    }

    public void setDrawingTriageContentList(List<DrawingTriageContentEntity> drawingTriageContentList) {
        this.drawingTriageContentList = drawingTriageContentList;
    }
}
