package com.ejianc.business.techmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.techmanagement.bean.DesignChangeEntity;
import com.ejianc.business.techmanagement.service.IDesignChangeService;
import com.ejianc.business.techmanagement.vo.DesignChangeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.techmanagement.bean.DesignChangeDisclosureEntity;
import com.ejianc.business.techmanagement.service.IDesignChangeDisclosureService;
import com.ejianc.business.techmanagement.vo.DesignChangeDisclosureVO;

/**
 * 设计变更交底
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("designChangeDisclosure")
public class DesignChangeDisclosureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DESIGN-CHANGE-DISCLOSURE";//此处需要根据实际修改

    @Autowired
    private IDesignChangeDisclosureService service;

    @Autowired
    private IDesignChangeService designChangeService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DesignChangeDisclosureVO> saveOrUpdate(@RequestBody DesignChangeDisclosureVO saveOrUpdateVO) {
    	DesignChangeDisclosureEntity entity = BeanMapper.map(saveOrUpdateVO, DesignChangeDisclosureEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        designChangeService.update(new UpdateWrapper<DesignChangeEntity>()
                .eq("id", entity.getDesignChangeId())
                .set("disclosure_code", entity.getCode())
        );
        service.saveOrUpdate(entity, false);
    	DesignChangeDisclosureVO vo = BeanMapper.map(entity, DesignChangeDisclosureVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DesignChangeDisclosureVO> queryDetail(Long id) {
    	DesignChangeDisclosureEntity entity = service.selectById(id);
    	DesignChangeDisclosureVO vo = BeanMapper.map(entity, DesignChangeDisclosureVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignChangeDisclosureVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DesignChangeDisclosureVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
     /*            CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }
            }*/
            }
        }
            QueryParam param = new QueryParam();
            ArrayList<Long> ids = new ArrayList<>();
            ArrayList<String> codes = new ArrayList<>();
            for (DesignChangeDisclosureVO vo : vos) {
                ids.add(vo.getId());
            }
            param.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<DesignChangeDisclosureEntity> designChangeDisclosureEntities = service.queryList(param, false);
            for (DesignChangeDisclosureEntity entity : designChangeDisclosureEntities) {
                codes.add(entity.getCode());
            }
            designChangeService.update(new UpdateWrapper<DesignChangeEntity>()
                    .set("disclosure_code", null)
                    .in("disclosure_code", codes)
            );
            service.removeByIds(vos.stream().map(DesignChangeDisclosureVO::getId).collect(Collectors.toList()), true);
            return CommonResponse.success("删除成功！");
        }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DesignChangeDisclosureVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondaryUnits");
        fuzzyFields.add("projectName");
        fuzzyFields.add("disclosureName");
        fuzzyFields.add("witnessName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离  */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<DesignChangeDisclosureEntity> page = service.queryPage(param,false);
        IPage<DesignChangeDisclosureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DesignChangeDisclosureVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondaryUnits");
        fuzzyFields.add("projectName");
        fuzzyFields.add("disclosureName");
        fuzzyFields.add("witnessName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<DesignChangeDisclosureEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<DesignChangeDisclosureVO> list = BeanMapper.mapList(pageData.getRecords(), DesignChangeDisclosureVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    //log.println("判断billState是否为空:" + billState);
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                        //log.print("判断billStateEnum是否为空:" + billStateEnum);
                        if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                        }
                    }
                });
            }
            beans.put("records", list);
            ExcelExport.getInstance().export("DesignChangeDisclosure-export.xlsx", beans, response);
        }
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDesignChangeDisclosureData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DesignChangeDisclosureVO>> refDesignChangeDisclosureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DesignChangeDisclosureEntity> page = service.queryPage(param,false);
        IPage<DesignChangeDisclosureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DesignChangeDisclosureVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
