package com.ejianc.business.techmanagement.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 技术复核
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tec_review")
public class TechnologyReviewEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "parent_org_name")
    private String parentOrgName;

    @TableField(value = "parent_org_code")
    private String parentOrgCode;
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    @TableField(value = "org_code")
    private String orgCode;
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="unit_name")
    private String unitName; // 二级单位
    @TableField(value = "unit_id")
    private Long unitId;
    @TableField(value="project_type")
    private String projectType; // 工程类型
    @TableField(value = "engineering_id")
    private Long engineeringId;
    @TableField(value="project_scale")
    private String projectScale; // 工程规模
    @TableField(value="review_date")
    private Date reviewDate; // 复核日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门ID
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value = "org_id")
    private Long orgId;
    @TableField(value = "org_name")
    private String orgName;

    @TableField(exist=false)
    private String billStateName;
    @TableField(exist=false)
    @SubEntity(serviceName="tecReviewContentService",pidName = "tecReviewId")
    private List<TecReviewContentEntity> tecReviewContentList = new ArrayList<>(); // 技术复核子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public Long getOrgId() {
        return orgId;
    }
    public void setOrgId(Long ordId) {
        this.orgId = ordId;
    }
    public String getOrgName() {
        return orgName;
    }
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEngineeringId() {
        return engineeringId;
    }

    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }

//    public List<TecReviewContentEntity> gettecReviewContentList() {
//        return tecReviewContentList;
//    }
//
//    public void settecReviewContentList(List<TecReviewContentEntity> tecReviewContentList) {
//        this.tecReviewContentList = tecReviewContentList;
//    }

    public List<TecReviewContentEntity> getTecReviewContentList() {
        return tecReviewContentList;
    }

    public void setTecReviewContentList(List<TecReviewContentEntity> tecReviewContentList) {
        this.tecReviewContentList = tecReviewContentList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
