package com.ejianc.business.techmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.techmanagement.bean.ProfitPointEntity;
import com.ejianc.business.techmanagement.bean.ProfitTrackEntity;
import com.ejianc.business.techmanagement.bean.TechnicalReviewPointsEntity;
import com.ejianc.business.techmanagement.bean.TechnologyReviewEntity;
import com.ejianc.business.techmanagement.service.IProfitPointService;
import com.ejianc.business.techmanagement.service.IProfitTrackService;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("profitPoint") 
public class ProfitPointBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IProfitPointService service;
	@Autowired
	private IProfitTrackService profitTrackService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		LambdaQueryWrapper<ProfitPointEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ProfitPointEntity::getId, billId);
		queryWrapper.eq(ProfitPointEntity::getDr,0);
		List<ProfitPointEntity> entity = service.list(queryWrapper);
		if (CollectionUtils.isEmpty(entity)){
			throw new BusinessException("无数据，不能进行撤回操作！");
		}
		Long projectId = entity.get(0).getProjectId();
		if (projectId!=null){
			LambdaQueryWrapper<ProfitTrackEntity> wrapper = new LambdaQueryWrapper<>();
			wrapper.eq(ProfitTrackEntity::getProjectId,projectId);
			wrapper.eq(ProfitTrackEntity::getDr,0);
			List<ProfitTrackEntity> list = profitTrackService.list(wrapper);
			if (CollectionUtils.isNotEmpty(list)){
				throw new BusinessException("项目已存在创效点跟踪单据，不能进行撤回操作！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LambdaQueryWrapper<ProfitPointEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ProfitPointEntity::getId, billId);
		queryWrapper.eq(ProfitPointEntity::getDr,0);
		List<ProfitPointEntity> entity = service.list(queryWrapper);
		if (CollectionUtils.isEmpty(entity)){
			throw new BusinessException("无数据，不能进行弃审操作！");
		}
		Long projectId = entity.get(0).getProjectId();
		if (projectId!=null){
			LambdaQueryWrapper<ProfitTrackEntity> wrapper = new LambdaQueryWrapper<>();
			wrapper.eq(ProfitTrackEntity::getProjectId,projectId);
			wrapper.eq(ProfitTrackEntity::getDr,0);
			List<ProfitTrackEntity> list = profitTrackService.list(wrapper);
			if (CollectionUtils.isNotEmpty(list)){
				throw new BusinessException("项目已存在创效点跟踪单据，不能进行弃审操作！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
