package com.ejianc.business.construction.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 施工图纸管理
 * 
 * @author generator
 * 
 */
public class DrawingsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Date serviceDate; // 编制日期
    private Long departmentId; // 所属部门id
    private String departmentName; // 所属部门
    private Long projectTypeId; // 工程类型id
    private String projectTypeName; // 工程类型名称
    private Long patrolGroup; // 所属巡检组
    private String patrolGroupName; // 所属巡检组名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractStartDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualStartDate; // 实际开工日期
    private String versionNumber; // 版本号
    private String versionMemo; // 版本说明
    private String constructionDrawingsType; // 施工图纸类型
    private String unitSiteEngineering; // 单位或部位工程
    private String drawingsReview; // 图纸已审查
    private String drawingsSubmitted; // 图纸已交底
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    //@ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectTypeId() {
        return projectTypeId;
    }
    @ReferDeserialTransfer
    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPatrolGroup() {
        return patrolGroup;
    }
    @ReferDeserialTransfer
    public void setPatrolGroup(Long patrolGroup) {
        this.patrolGroup = patrolGroup;
    }

    public String getPatrolGroupName() {
        return patrolGroupName;
    }

    public void setPatrolGroupName(String patrolGroupName) {
        this.patrolGroupName = patrolGroupName;
    }
    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }
    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }
    public String getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }
    public String getVersionMemo() {
        return versionMemo;
    }

    public void setVersionMemo(String versionMemo) {
        this.versionMemo = versionMemo;
    }
    public String getConstructionDrawingsType() {
        return constructionDrawingsType;
    }

    public void setConstructionDrawingsType(String constructionDrawingsType) {
        this.constructionDrawingsType = constructionDrawingsType;
    }
    public String getUnitSiteEngineering() {
        return unitSiteEngineering;
    }

    public void setUnitSiteEngineering(String unitSiteEngineering) {
        this.unitSiteEngineering = unitSiteEngineering;
    }
    public String getDrawingsReview() {
        return drawingsReview;
    }

    public void setDrawingsReview(String drawingsReview) {
        this.drawingsReview = drawingsReview;
    }
    public String getDrawingsSubmitted() {
        return drawingsSubmitted;
    }

    public void setDrawingsSubmitted(String drawingsSubmitted) {
        this.drawingsSubmitted = drawingsSubmitted;
    }
    
}
