package com.ejianc.business.constructor.service.impl;

import com.ejianc.business.constructor.bean.ZjlzfaEntity;
import com.ejianc.business.constructor.service.IZjlzfaService;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("zjlzfa") 
public class ZjlzfaBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IZjlzfaService service;
	@Autowired
	private IInstoreApi iInstoreApi;
	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ZjlzfaEntity entity = service.getById(billId);
		if (entity != null) {
			//审批通过对项目用印申请新增一条数据
			YysqVO yysqVO = new YysqVO();
			yysqVO.setBidId(billId);  //单据编号id
			yysqVO.setOrgId(entity.getOrgId());  //组织id
			yysqVO.setOrgName(entity.getOrgName());  //组织名称
			yysqVO.setBidCode(entity.getBillCode());  //单据编码

			yysqVO.setYysxId(589420729582256227L);
			yysqVO.setYysxName("技术管理-专家论证方案");
			yysqVO.setYyReason("技术管理-专家论证方案-" + entity.getBillCode());  //用印事由
			yysqVO.setDjlj("/ejc-technologymanage-frontend/#/zjlzfa/card");//单据链接

			yysqVO.setSqdwId(entity.getOrgId());  //申请单位id
			yysqVO.setSqdwName(entity.getOrgName());  //申请单位name
			yysqVO.setSqrId(sessionManager.getUserContext().getUserId());  //负责人id
			yysqVO.setSqrName(sessionManager.getUserContext().getUserName());  //负责人name
			yysqVO.setCreateUserCode(entity.getCreateUserCode());  //创建人
			yysqVO.setCreateUserName(sessionManager.getUserContext().getUserName());  //负责人名称
			//审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
			//因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
			CommonResponse<YzdjVO> yzdjVOCommonResponse = iInstoreApi.selectYzxxByCode("YZ-001");
			YzdjVO data = yzdjVOCommonResponse.getData();

			yysqVO.setYzbhId(data.getId());
			yysqVO.setYzlbId(data.getYzlbId());
			yysqVO.setYzlbName(data.getYzlbName());
			yysqVO.setYzjbId(data.getYzjbId());
			yysqVO.setYzjbName(data.getYzjbName());
			yysqVO.setYylxId(data.getYylxId());
			yysqVO.setYylxName(data.getYylxName());
			yysqVO.setBillState(3);  //推送数据默认为审批通过的
			yysqVO.setMessageFrom(1);// 数据来源：0自建，1原始审批单据
			yysqVO.setZkbmId(1502571153481273346L);//主控部门ID
			yysqVO.setZkbmName("经营部");//主控部门name
			yysqVO.setXgcs(0);//修改次数

			CommonResponse<String> yysqBack = iInstoreApi.addYysq(yysqVO);
			if(!yysqBack.isSuccess()){
				throw new BusinessException("新增项目用印申请表数据失败，原因：" + yysqBack);
			}
			logger.info("发送专家论证方案数据：{终审审核完回调}");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
