package com.ejianc.business.constructor.service.impl;

import com.ejianc.business.constructor.bean.FaRemarkEntity;
import com.ejianc.business.constructor.bean.FaSealEntity;
import com.ejianc.business.constructor.bean.SfhsfaEntity;
import com.ejianc.business.constructor.bean.ZjlzfaEntity;
import com.ejianc.business.constructor.service.IFaRemarkService;
import com.ejianc.business.constructor.service.IFaSealService;
import com.ejianc.business.constructor.service.ISfhsfaService;
import com.ejianc.business.constructor.service.IZjlzfaService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("faRemark") 
public class FaRemarkBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISfhsfaService sfhsfaService;

	@Autowired
	private IZjlzfaService zjlzfaService;

	@Autowired
	private IFaRemarkService faRemarkService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FaRemarkEntity entity = faRemarkService.selectById(billId);

		String operatorName = entity.getOperatorName();
		if(StringUtils.isNotEmpty(operatorName)){

			ZjlzfaEntity zjlzfaEntity = zjlzfaService.selectById(entity.getSourceId());
			zjlzfaEntity.setGd(0);
			zjlzfaService.saveOrUpdate(zjlzfaEntity);
			return CommonResponse.success();

		}
		return CommonResponse.error("未获取到方案所属类型！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
